package cn.quantgroup.report.mapper.master;

import cn.quantgroup.report.domain.baihang.BaiHangRepayment;
import cn.quantgroup.report.domain.baihang.BaiHangUpDateRecord;
import cn.quantgroup.report.domain.baihang.RepaymentLoanInfo;
import cn.quantgroup.report.domain.baihang.RepaymentLoanInfoVo;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 还款信息查询
 *
 * @Author fengjunkai
 * @Date 2019-03-26 15:27
 */
@Repository
public interface RepaymentLoanInfoDbMapper {

    void saveRepaymentLoanInfoLog(RepaymentLoanInfo repaymentLoanInfo);

    List<RepaymentLoanInfo> findAll();

    void updateCurrentRecordEnableFalse(BaiHangUpDateRecord baiHangUpDateRecord);

    RepaymentLoanInfo findLastOne(BaiHangRepayment baiHangRepayment);


    /**
     * 描述: 根据recordId查询op_code=A的  <br/>
     * 参数:   <br/>
     * 返回值:   <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.24  <br/>
     */
    List<RepaymentLoanInfoVo> findByRecordId(String[] recordIdArray);

}
