package cn.quantgroup.report.config.web;

import cn.quantgroup.report.interceptor.AuthHandlerInterceptorAdapter;
import cn.quantgroup.report.interceptor.HBaseHandlerInterceptorAdapter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.util.Arrays;

@Configuration
public class WebMvcConfigure extends WebMvcConfigurerAdapter {
  @Autowired
  private Environment environment;

  /**
   * 添加拦截器
   */
  @Override
  public void addInterceptors(InterceptorRegistry registry) {
    registry.addInterceptor(new HBaseHandlerInterceptorAdapter()).addPathPatterns("/**").excludePathPatterns("/");
    registry.addInterceptor(new AuthHandlerInterceptorAdapter(Arrays.stream(environment.getActiveProfiles()).anyMatch(o -> StringUtils.equalsAnyIgnoreCase(o, "dev", "test", "pre"))))
      .addPathPatterns("/**")
      .excludePathPatterns("/");
//      .excludePathPatterns("/ex/91zhengxin/call");
  }
}
