package cn.quantgroup.report.utils.http;

import cn.quantgroup.report.service.interceptor.CommonInterceptor;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

import javax.net.ssl.*;
import java.io.IOException;
import java.io.InputStream;
import java.security.*;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import static java.util.concurrent.TimeUnit.MINUTES;

public class HttpUtils {
  public static OkHttpClient getTrustAllClient(int maxIdleConnections, long keepAliveDuration, boolean log, CommonInterceptor commonInterceptor) throws NoSuchAlgorithmException, KeyManagementException {
    OkHttpClient.Builder builder = new OkHttpClient.Builder()
      .retryOnConnectionFailure(true)
      .connectionPool(new ConnectionPool(maxIdleConnections, keepAliveDuration, MINUTES))
      .connectTimeout(10, MINUTES)
      .readTimeout(10, MINUTES)
      .writeTimeout(10, MINUTES);
    if (commonInterceptor != null) {
      builder.addInterceptor(commonInterceptor);
    }
    if (log) {
      HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
      interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
      builder.addInterceptor(interceptor);
    }

    CommonTrustManager trustManager = new CommonTrustManager();
    SSLContext sc = SSLContext.getInstance("TLS");
    sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
    SSLSocketFactory ssfFactory = sc.getSocketFactory();
    builder.sslSocketFactory(ssfFactory, trustManager)
      .hostnameVerifier(new CommonHostnameVerifier());
    return builder.build();
  }

  public static OkHttpClient getTrustAllClient(SSLSocketFactory ssfFactory, X509TrustManager trustManager, int maxIdleConnections, long keepAliveDuration, boolean log, CommonInterceptor commonInterceptor) {
    OkHttpClient.Builder builder = new OkHttpClient.Builder()
      .retryOnConnectionFailure(true)
      .connectionPool(new ConnectionPool(maxIdleConnections, keepAliveDuration, MINUTES))
      .connectTimeout(10, MINUTES)
      .readTimeout(10, MINUTES)
      .writeTimeout(10, MINUTES);
    if (commonInterceptor != null) {
      builder.addInterceptor(commonInterceptor);
    }
    if (log) {
      HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
      interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
      builder.addInterceptor(interceptor);
    }
    builder.sslSocketFactory(ssfFactory, trustManager)
      .hostnameVerifier(new CommonHostnameVerifier());
    return builder.build();
  }

  public static class CommonHostnameVerifier implements HostnameVerifier {
    @Override
    public boolean verify(String hostname, SSLSession session) {
      return true;
    }
  }

  public static class CommonTrustManager implements X509TrustManager {
    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
      return new X509Certificate[0];
    }
  }


  public static SSLSocketFactory getSSLSocketFactory(TrustManager trustManager, String clientType, InputStream clientInputStream, String clientPassword) throws NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException, KeyStoreException, IOException, KeyManagementException {
    KeyManagerFactory keyManagerFactory = getKeyManagerFactory(clientType, clientInputStream, clientPassword);
    SSLContext context = SSLContext.getInstance("SSL");
    TrustManager[] trustManagers = new TrustManager[1];
    trustManagers[0] = trustManager;
    context.init(keyManagerFactory.getKeyManagers(), trustManagers, null);
    return context.getSocketFactory();
  }

  public static KeyManagerFactory getKeyManagerFactory(String type, InputStream inputStream, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException {
    KeyStore keyStore = KeyStore.getInstance(type);
    keyStore.load(inputStream, password.toCharArray());
    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
    keyManagerFactory.init(keyStore, password.toCharArray());
    return keyManagerFactory;
  }
}
