package cn.quantgroup.report.error;

public class QGPreconditions {
  private QGPreconditions() {
  }

  public static void checkArgument(boolean expression) {
    checkArgument(expression, QGExceptionType.COMMON_ILLEGAL_PARAM);
  }

  public static void checkArgument(boolean expression, Object errorMessage) {
    checkArgument(expression, QGExceptionType.COMMON_ILLEGAL_PARAM, errorMessage);
  }

  public static void checkArgument(boolean expression,
                                   String errorMessageTemplate, Object... errorMessageArgs) {
    checkArgument(expression, QGExceptionType.COMMON_ILLEGAL_PARAM, errorMessageTemplate, errorMessageArgs);
  }

  public static void checkArgument(boolean expression, QGExceptionType exceptionType) {
    if (!expression) {
      throw new QGException(exceptionType);
    }
  }

  public static void checkArgument(boolean expression, QGExceptionType exceptionType, Object... errorMessage) {
    if (!expression) {
      throw new QGException(exceptionType, errorMessage);
    }
  }
}
