package cn.quantgroup.report.service.manualTool;


import cn.quantgroup.report.config.aop.DistributedLock;
import cn.quantgroup.report.config.aop.Monitor;
import cn.quantgroup.report.config.aop.MonitorType;
import cn.quantgroup.report.domain.baihang.*;
import cn.quantgroup.report.mapper.baihang.LoanInfoMapper;
import cn.quantgroup.report.mapper.master.ApplyLoanInfoDbMapper;
import cn.quantgroup.report.mapper.master.LoanInfoDbMapper;
import cn.quantgroup.report.mapper.master.RepaymentLoanInfoDbMapper;
import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.CommonSuperService;
import cn.quantgroup.report.service.baihang.util.TuoMinUtils;
import cn.quantgroup.report.utils.ReadOrWriteTxt;
import cn.quantgroup.report.utils.commonutil.AesCrypto;
import cn.quantgroup.report.utils.commonutil.Base64;
import cn.quantgroup.report.utils.commonutil.MD5Util;
import cn.quantgroup.report.utils.commonutil.RSAEncrypt;
import cn.quantgroup.report.utils.http.HttpRequestUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.io.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: <br>
 * 作者: Administrator <br>
 * 时间: 2019.09.24 10:34 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Slf4j
@Service
public class ManualToolService implements CommonSuperService {

    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    @Autowired
    private RepaymentLoanInfoDbMapper repaymentLoanInfoDbMapper;

    @Autowired
    private LoanInfoMapper loanInfoMapper;

    @Autowired
    private ApplyLoanInfoDbMapper applyLoanInfoDbMapper;

    @Autowired
    public LoanInfoDbMapper loanInfoDbMapper;

    @Autowired
    private RedisTemplate<String,String> redisTemplate;



    //@Autowired
    //private PinTaiCreditScoreService pinTaiCreditScoreService;


    private ShellUtils executeCommand = null;
    private static final String P1_48MD5_01 = "120a97b4b73c440413933351a2db2512fc7698f157b5c60d";
    private static final String P1_48MD5_02 = "85b61d877f6ce41c4cc72413f6766ae6876405f06b607b02";
    private static final String P2_48MD5 = "d4893490905d534e6fc1512ba6619d14df8c312362589342";
    private static final String P3_48MD5 = "57971a003213360c6fa09f4b257d5eb5441ba97a5450aa63";

    private static String RSA_PRIVATEKEY = null;

    static {
        RSA_PRIVATEKEY = readRSAPrivateKey("/manualTool/rsa_private_key.pem");
    }

    @Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    @DistributedLock
    public Map<String,String> sendBaiHangData(String p1, String p2, String p3, String p4, String p5, String secretKey, String isSend,String errorCode, String isProduct, String sendIncludeType) {
        Map<String,String> resultMap = new HashMap<>();
        StringBuffer resultMsg = new StringBuffer();
        log.info("ManualToolService.sendBaiHangData Start>>>>>>");
        String base_path = "/home/quant_group/baihang-report/data";
        String base_url = "http://172.21.10.8:9021/zhudai/re_send";

        String A1_file ="/baihang/A1/data.txt";
        String D2_file ="/baihang/D2/data.txt";
        String D3_file ="/baihang/D3/data.txt";

        String A1_url = "/manual/buquan/mainApplySend";
        String D2_url = "/manual/buquan/mainLoanInfoSend";
        String D3_url = "/manual/buquan/mainRepaymentLoanInfo";

        String cNameWhiteListFile = base_path+"/baihang/changedName_loanId_whiteList.txt";

        if (StringUtils.isBlank(RSA_PRIVATEKEY)) {
            resultMap.put("error","参数错误1");
            return resultMap;
        }
        if (StringUtils.isBlank(secretKey)) {
            resultMap.put("error","参数错误2");
            return resultMap;
        }
        if (StringUtils.isAnyBlank(p1, p2, p3)) {
            resultMap.put("error","参数错误3");
            return resultMap;
        }

        try {
            String aes_key = RSAEncrypt.decrypt(secretKey, RSA_PRIVATEKEY);//"!QAZ@WSX3edc4rfv"
            //p1:host, p2:name, p3:pass, p4:forword, p5:date, p6:根路径
            //p1,p2,p3 做AES和base64加密
            //p1为127.0.0.1时p4必须是ip，且和172.21.10.8的MDd一致校验
            p1 = AesCrypto.decrypt(Base64.decode(p1.trim()), aes_key).trim();
            if (!(MD5Util.verify48Md5(p1, P1_48MD5_01) || MD5Util.verify48Md5(p1, P1_48MD5_02))) {
                resultMap.put("error","参数错误4");
                return resultMap;
            }
            p2 = AesCrypto.decrypt(Base64.decode(p2.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(p2, P2_48MD5)) {
                resultMap.put("error","参数错误5");
                return resultMap;
            }
            p3 = AesCrypto.decrypt(Base64.decode(p3.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(p3, P3_48MD5)) {
                resultMap.put("error","参数错误6");
                return resultMap;
            }
            //不是127.0.0.1时,p4不能为空
            //if (MD5Util.verify48Md5(p1, P1_48MD5_01)) {
                if (StringUtils.isBlank(p4)) {
                    resultMap.put("error","参数错误7");
                    return resultMap;
                } else {
                    p4 = AesCrypto.decrypt(Base64.decode(p4.trim()), aes_key).trim();
                }
            //}
        } catch (Exception e) {
            log.error("参数解析错误!", e);
            resultMap.put("error","参数错误8");
            return resultMap;
        }

        if (StringUtils.isEmpty(p5)) {
            p5 = sdf.format(System.currentTimeMillis());
        }
        boolean httpSend = false;
        if (StringUtils.isNotEmpty(isSend) && "true".equals(isSend)) {
            httpSend = true;
        }

        boolean isProduct2 = false;
        String char_n = "\n";
        if (StringUtils.isNotEmpty(isProduct) && "true".equals(isProduct)) {
            isProduct2 = true;
            char_n = "\r\n";
        }

        String sendInclude_type = "A1,D2,D3";
        if(StringUtils.isNotBlank(sendIncludeType)){
            sendInclude_type = sendIncludeType;
        }

        if (StringUtils.isEmpty(errorCode)) {
            /*"errorCode":"D2_009"
            "errorCode":"D3_035"
            "errorCode":"D3_036"
            "errorCode":"D3_041"
            "errorCode":"G_001"*/
            errorCode = "D3_035";
        }

        //还款信息D3,opCode:A>>>M,多条信息就回车存多行,中间不用逗号
        StringBuffer json_hk_D3 = new StringBuffer();
        //放款信息D2,多条信息就回车存多行,中间不用逗号
        StringBuffer json_fk_D2 = new StringBuffer();
        //A1申请
        StringBuffer json_sq_A1 = new StringBuffer();


        try {
            if (initShellConnect(executeCommand, p1, p2, p3)) {
                //获取远程日志中reqID
                String jsaonResult = getReqIdByRemoteLog(executeCommand, p4, p5, base_path);
                if (StringUtils.isNotBlank(jsaonResult)) {
                    List<String> reqIDList = new ArrayList<>();
                    List<String> loanIdList = new ArrayList<String>();

                    //2020.05.22 第一次报完D2后，修改了姓名，导致D3中姓名和D2中不一致，百行回复这样的D3数据不用补报修复
                    Map<String, String> cNameLoanIdMap = new HashMap<>();
                    try{
                        List<String> changedNameList = ReadOrWriteTxt.readTxtList(cNameWhiteListFile);
                        if(changedNameList!=null && changedNameList.size()>0){
                            for (String context : changedNameList){
                                //LoanId|历史姓名|修改后姓名
                                String value = context.trim();
                                cNameLoanIdMap.put(value.split(",")[0], value);
                            }
                        }
                    }catch (Exception e){
                        log.error("读取报送D3时修改过姓名的用户loanId白名单异常!", e);
                    }


                    JSONArray jsonArray = JSONArray.parseArray(jsaonResult);
                    resultMsg.append("getReqIdByRemoteLog size=" + (jsonArray!=null ? jsonArray.size() : "null") );
                    for (int i = 0; i < jsonArray.size(); i++) {
                        JSONObject jsonObj = jsonArray.getJSONObject(i);
                        boolean flag = false;
                        try{
                            JSONArray errorDetailArry = jsonObj.getJSONArray("errorDetail");
                            if(errorDetailArry!=null && errorDetailArry.size()>0){
                                JSONObject error = errorDetailArry.getJSONObject(0);
                                if(error.get("errorCode")!=null && errorCode.contains(error.getString("errorCode"))){ //D3_035,D3_036
                                    flag = true;
                                    reqIDList.add(jsonObj.getString("reqID"));
                                }
                            }
                        }catch (Exception e){
                            log.error("deal with reqIdByRemoteLog error!",e);
                        }finally {
                            if(!flag){
                                resultMsg.append(" |##OTHER ERRORCODE:" + jsonObj.toJSONString()+"##");
                                log.info("ManualToolService OTHER ERRORCODE:" + jsonObj.toJSONString());
                            }
                        }
                    }
                    resultMsg.append(" |reqIDList size=" + reqIDList.size() );

                    if (reqIDList.size() > 0) { //还款D3
                        String[] recordIdArray = reqIDList.toArray(new String[reqIDList.size()]);
                        log.info("RepaymentLoanInfoDbMapper getReqIdByRemoteLog reqID to D3:" + JSON.toJSONString(recordIdArray));
                        List<RepaymentLoanInfoLog> tmpLogList = repaymentLoanInfoDbMapper.findByD3RecordId(recordIdArray);

                        int cNameSize = 0;
                        boolean lengthIs0 = (json_hk_D3.length()==0);
                        //List<RepaymentInfoZhuDai> repaymentLoanInfoList = new ArrayList<>(tmpLogList.size());
                        for (RepaymentLoanInfoLog logBean : tmpLogList) {

                            //如果不在白名单里
                            if(!cNameLoanIdMap.containsKey(logBean.getLoanId())){

                                //查询d2使用
                                loanIdList.add(logBean.getLoanId());

                                RepaymentInfoZhuDai voBean = new RepaymentInfoZhuDai();
                                //添加了忽略username属性的赋值
                                //BeanUtils.copyProperties(book,book2,"username");
                                BeanUtils.copyProperties(logBean, voBean);
                                voBean.setOpCode("M");
                                if (voBean.getOverdueStatus() == null) {
                                    voBean.setOverdueStatus("");
                                }
                                //repaymentLoanInfoList.add(voBean);
                                if(lengthIs0){
                                    lengthIs0 = false;
                                    json_hk_D3.append(JSONObject.toJSONString(voBean));
                                }else{
                                    json_hk_D3.append(char_n);
                                    json_hk_D3.append(JSONObject.toJSONString(voBean));
                                }

                            }else{
                                cNameSize++;
                                log.info("用户报送D3时修改姓名, 跳过补报, WhiteList: {} ", cNameLoanIdMap.get(logBean.getLoanId()));
                            }

                        }
                        resultMsg.append(" |D3 List size=" + tmpLogList.size());
                        resultMsg.append(" |D3 修改姓名跳过=" + cNameSize);

                       /* boolean lengthIs0 = (json_hk_D3.length()==0);
                        for (RepaymentInfoZhuDai vo : repaymentLoanInfoList){
                            if(lengthIs0){
                                lengthIs0 = false;
                                json_hk_D3.append(JSONObject.toJSONString(vo));
                            }else{
                                json_hk_D3.append(char_n);
                                json_hk_D3.append(JSONObject.toJSONString(vo));
                            }
                        }*/
                    }


                    if (loanIdList.size() > 0) { //放款D2 及 申请A1
                        List<LoanInfoZhuDai> loanInfoVoList = new ArrayList<LoanInfoZhuDai>();

                        String[] orderNoArray = loanIdList.toArray(new String[loanIdList.size()]);
                        List<String> loanApplicationHistoryIdList = loanInfoMapper.findHistoryIdByOrderNo(orderNoArray);

                        //查询D2
                        for (String historyId : loanApplicationHistoryIdList) {
                            LoanInfoZhuDai loanInfozd_tmp = loanInfoMapper.findLoanInfoD2ByHistoryId(historyId);
                            //TargetRepayDateList报送时会查
                            loanInfoVoList.add(loanInfozd_tmp);
                        }
                        resultMsg.append(" |D2 List size=" + loanInfoVoList.size());

                        if (loanInfoVoList.size() > 0) {
                            boolean lengthIs0 = (json_fk_D2.length()==0);
                            for (LoanInfoZhuDai vo : loanInfoVoList){
                                if(lengthIs0){
                                    lengthIs0 = false;
                                    json_fk_D2.append(JSONObject.toJSONString(vo));
                                }else{
                                    json_fk_D2.append(char_n);
                                    json_fk_D2.append(JSONObject.toJSONString(vo));
                                }
                            }
                        }


                        //查询A1
                        if(sendInclude_type.contentEquals("A1")){
                            List<ApplyLoanInfoZhuDai> applyInfoList = new ArrayList<>();
                            for (String historyId : loanApplicationHistoryIdList) {
                                ApplyLoanInfoZhuDai applyInfo = applyLoanInfoDbMapper.findApplyInfoA1ByHistoryId(historyId);
                                //邮箱有错误的就不传
                                if(!TuoMinUtils.checkEmail(applyInfo.getEmailAddress())){
                                    applyInfo.setEmailAddress(null);
                                }
                                applyInfoList.add(applyInfo);
                            }

                            if(applyInfoList.size()>0){
                                boolean lengthIs0 = (json_sq_A1.length()==0);
                                for (ApplyLoanInfoZhuDai vo : applyInfoList){
                                    if(lengthIs0){
                                        lengthIs0 = false;
                                        json_sq_A1.append(JSONObject.toJSONString(vo));
                                    }else{
                                        json_sq_A1.append(char_n);
                                        json_sq_A1.append(JSONObject.toJSONString(vo));
                                    }
                                }
                                resultMsg.append(" |A1 List size=" + applyInfoList.size());
                            }
                        }

                    }

                    resultMsg.append(" >>>> ");
                    //------------处理--------------
                    if (StringUtils.isNotBlank(json_sq_A1)) {
                        log.info("json_sq_A1 DATA:" + json_sq_A1.toString());
                        //A1的data.txt写入
                        if(isProduct2){
                            ReadOrWriteTxt.writeTxt(base_path + A1_file, json_sq_A1.toString());
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData writ remote file (product By file)...baihang/A1/data.txt END.");
                            resultMsg.append(" |write A1 end.(product By file)");
                        }else{
                            String cmd_res = writeJsonFileOnRemote(executeCommand, base_path + A1_url, json_sq_A1.toString());
                            resultMsg.append("| write A1 end.(local By shell)");
                        }
                        resultMap.put("json_sq_A1", "true");

                        //掉A1手动报送接口
                        if (httpSend) {
                            Map<String, Object> params = new HashMap<String, Object>();
                            params.put("key", "b5140fb2-2c85-4b5a-abcf-3e97528014db");
                            String http_res = HttpRequestUtil.mySelfDoGet(base_url + "/mainLoanInfoSend", params);
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData http request A1>>>mainLoanInfoSend END,r:" + http_res);
                            resultMsg.append("|");
                            resultMsg.append(http_res);
                        }
                    }else{
                        resultMsg.append(" |申请A1 json_sq_A1 isEmpty.");
                    }


                    if (StringUtils.isNotBlank(json_fk_D2)) {
                        log.info("json_fk_D2 DATA:" + json_fk_D2.toString());
                        //D2的data.txt写入
                        if(isProduct2){
                            ReadOrWriteTxt.writeTxt(base_path + D2_file,json_fk_D2.toString());
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData writ remote file (product By file)...baihang/D2/data.txt END.");
                            resultMsg.append(" |write D2 end.(product By file)");
                        }else{
                            String cmd_res = writeJsonFileOnRemote(executeCommand, base_path + D2_url, json_fk_D2.toString());
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData writ remote file (local By shell)...baihang/D2/data.txt END,r:" + cmd_res);
                            resultMsg.append(" |write D2 end.(local By shell)");
                        }
                        resultMap.put("json_fk_D2", "true");

                        //掉D2手动报送接口
                        if (httpSend) {
                            Map<String, Object> params = new HashMap<String, Object>();
                            params.put("key", "b5140fb2-2c85-4b5a-abcf-3e97528014db");
                            String http_res = HttpRequestUtil.mySelfDoGet(base_url + "/mainLoanInfoSend", params);
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData http request D2>>>mainLoanInfoSend END,r:" + http_res);
                            resultMsg.append(" |");
                            resultMsg.append(http_res);
                        }
                    }else{
                        resultMsg.append(" |放款D2 json_fk_D2 isEmpty.");
                    }


                    if (StringUtils.isNotBlank(json_hk_D3)) {
                        log.info("json_hk_D3 DATA:" + json_hk_D3.toString());
                        //D3的data.txt写入
                        if(isProduct2){
                            ReadOrWriteTxt.writeTxt(base_path + D3_file, json_hk_D3.toString());
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData writ remote file (product By file)...baihang/D3/data.txt END.");
                            resultMsg.append(" |write D3 end.(product By file)");
                        }else{
                            String cmd_res = writeJsonFileOnRemote(executeCommand, base_path + D3_url, json_hk_D3.toString());
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData writ remote file (local By shell)...baihang/D3/data.txt END,r:" + cmd_res);
                            resultMsg.append(" |write D3 end.(local By shell)");
                        }
                        resultMap.put("json_hk_D3", "true");

                        //掉D3手动报送接口
                        if (httpSend) {
                            Map<String, Object> params = new HashMap<String, Object>();
                            params.put("key", "b5140fb2-2c85-4b5a-abcf-3e97528014db");
                            String http_res = HttpRequestUtil.mySelfDoGet(base_url + "/mainRepaymentLoanInfo", params);
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData http request D3>>>mainRepaymentLoanInfo END,r:" + http_res);
                            resultMsg.append(" |");
                            resultMsg.append(http_res);
                        }
                    }else {
                        resultMsg.append(" |还款D3 json_hk_D3 isEmpty.");
                    }

                    //退出登录
                    List<String> cmdList = new ArrayList<String>();
                    cmdList.add("echo '++CMD LAST++' \n\r");
                    cmdList.add("exit \n\r");
                    cmdList.add("exit \n\r");
                    executeCommand.execute(cmdList, false);

                    resultMap.put("success", resultMsg.toString());
                    return resultMap;

                } else {
                    log.info("RepaymentLoanInfoDbMapper.getReqIdByRemoteLog redult isEmpty.");
                    resultMap.put("success","百行征信手动报送,获取日志为空");
                    resultMap.put("isEmpty","isEmpty");

                    boolean have_logFile = false;
                    try{
                        ArrayList<String> fileNameList = new ArrayList<>();
                        String logPath = base_path + "/" +p5;
                        getAllFileName(logPath, fileNameList);

                        if(fileNameList!=null && fileNameList.size()>0){
                            for (String name : fileNameList) {
                                log.info("目录: {} 下的文件包括: {}", logPath, name);
                                if(StringUtils.isNotEmpty(name) && name.endsWith(".log")
                                        && !name.endsWith("_logicerror.log") && !name.endsWith("_inputerror.log")){
                                    have_logFile = true;
                                }
                            }
                        }
                    }catch (Exception e){
                        log.error("获取报送日志文件夹下文件异常, path: {} ", e);
                    }

                    if(!have_logFile){
                        resultMap.put("alarm","反馈日志主文件不存在,请注意确认");
                    }

                    return resultMap;
                }


            }
        } catch (Exception e) {
            log.error("ManualToolService.sendBaiHangData Error,", e);
            resultMap.put("error", "百行征信手动报送异常"+e.getMessage());
            return resultMap;
        } finally {
            if (executeCommand != null) {
                executeCommand.ioclose();
                executeCommand.closeChannelShell();
                executeCommand = null;
            }
            try {
                ShellUtils.LOCK.unlock();
            } catch (IllegalMonitorStateException e) {
                log.warn("锁已释放,无需重复释放." + e);
            }
        }
        log.info("ManualToolService.sendBaiHangData All END<<<<<<");
        resultMap.put("error","百行征信手动报送失败");
        return resultMap;
    }

    /**
     * 描述: 初始化 ShellUtils  <br/>
     * 参数: [p1:host, p2:name, p3:pass]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.25  <br/>
     */
    private boolean initShellConnect(ShellUtils executeCommand, String p1, String p2, String p3) {
        try {
            ShellUtils.LOCK.lock();
            if (executeCommand == null) {
                executeCommand = new ShellUtils(p1, p2, p3);
                if (executeCommand.login()) {
                    executeCommand.initChannel(ShellUtils.CHANNEL_TYPE_SHELL);
                    this.executeCommand = executeCommand;
                    return true;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("ManualToolService.initShellConnect Error," + e.getMessage());
        } finally {
            ShellUtils.LOCK.unlock();
        }
        return false;
    }

    /**
     * 描述: 获取远程服务器的日志信息  <br/>
     * 参数: [p4:forword, p5:date, p6:根路径]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.25  <br/>
     */
    private String getReqIdByRemoteLog(ShellUtils executeCommand, String p4, String p5, String p6) {
        String result = null;
        try {
            ShellUtils.LOCK.lock();
            if (executeCommand != null) {
                log.info(".......>>>>start deal with cmd:1 outputStream execute Start.......");
                List<String> cmdList = new ArrayList<>();
                cmdList.add("ssh " + p4 + " \n\r");
                cmdList.add("/sbin/ifconfig  |grep \"inet\" \n\r");
                cmdList.add("cd " + p6 + " \n\r");
                cmdList.add("sh download_zhudai_baihang_error_log.sh " + Integer.parseInt(p5) + " \n\r");
                executeCommand.execute(cmdList, true);
                //打印执行结果
                executeCommand.outCmdResult();
                log.info(".......>>>>start deal with cmd:1 inputStream getResult End.......");
                ShellUtils.LOCK.unlock();

                ShellUtils.LOCK.lock();
                cmdList = new ArrayList<>();
                log.info(".......>>>>start deal with cmd:2 outputStream execute Start.......");
                cmdList.add("cd " + p6 + "/" + p5 + " \n\r");
                cmdList.add("cat *_logicerror.log \n\r");
                executeCommand.execute(cmdList, true);
                //获取reqID结果
                result = executeCommand.getResult();
                log.info(".......>>>>start deal with cmd:2 inputStream getResult End.......result:\n" + result);
                ShellUtils.LOCK.unlock();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                ShellUtils.LOCK.unlock();
            } catch (IllegalMonitorStateException e) {
                log.warn("锁已释放,无需重复释放." + e);
            }
        }
        return result;
    }


    /**
     * 描述: 往远程服务器写文件 <br/>
     * 参数: [p4:forword, p5:date, p6:根路径]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.25  <br/>
     */
    private String writeJsonFileOnRemote(ShellUtils executeCommand, String filePath, String context) {
        String result = null;
        try {
            ShellUtils.LOCK.lock();
            if (executeCommand != null) {
                log.info(".......>>>>start deal with cmd:3 outputStream execute Start.......");
                List<String> cmdList = new ArrayList<>();
                String path = filePath.substring(0, filePath.lastIndexOf("/"));
                cmdList.add("cd " + path + " \n\r");
                cmdList.add("pwd \n\r");
                cmdList.add("printf '" + context + "' >./data.txt \n\r");
                cmdList.add("cat data.txt |wc -l \n\r");
                executeCommand.execute(cmdList, true);
                //打印执行结果
                executeCommand.outCmdResult();
                log.info(".......>>>>start deal with cmd:3 inputStream getResult End.......");
                result = "写入成功:" + filePath;
                ShellUtils.LOCK.unlock();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                ShellUtils.LOCK.unlock();
            } catch (IllegalMonitorStateException e) {
                log.warn("锁已释放,无需重复释放." + e);
            }
        }
        return result;
    }

    /**
     * 描述: 读取私钥 <br/>
     * 参数: [fileName]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.26  <br/>
     */
    private static String readRSAPrivateKey(String fileName) {
        InputStream isr = ManualToolService.class.getResourceAsStream(fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(isr));
        StringBuilder builder = new StringBuilder();
        try {
            boolean inKey = false;
            for (String line = br.readLine(); line != null; line = br.readLine()) {
                line = line.trim();
                if (!inKey) {
                    if (line.contains("BEGIN PRIVATE KEY")) {
                        inKey = true;
                    }
                    continue;
                } else {
                    if (line.contains("END PRIVATE KEY")) {
                        inKey = false;
                        break;
                    }
                    builder.append(line);
                }
            }
            br.close();
            isr.close();
        } catch (IOException e) {
            e.printStackTrace();
            log.error("读取:" + fileName + "异常", e);
        }
        return builder.toString();
    }



    @Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    @DistributedLock
    public GlobalResponse buildLoanInfoD2(String jsonFile) {
        StringBuffer resultMsg = new StringBuffer();
        if(StringUtils.isEmpty(jsonFile)){
            return new GlobalResponse("1000", "百行征信手动报送失败");
        }
        //jsonFile = "C:\\Users\\Administrator\\Desktop\\百行历史数据报送实时放款数据D2(历史百行征信报送).json";
        String context = ReadOrWriteTxt.readTxt(jsonFile);

        JSONObject jSONObject = JSON.parseObject(context);
        JSONArray jsonArray = jSONObject.getJSONArray("RECORDS");
        for (int i = 0; i < jsonArray.size() ; i++) {
            JSONObject object = jsonArray.getJSONObject(i);
            Object reqID = object.get("reqID");
            if(reqID!=null){
                List<String> list = loanInfoMapper.findTargetRepaymentDayList(reqID.toString());
                if(list!=null && list.size()>0){
                    String[] strArry = list.toArray(new String[list.size()]);
                    object.put("targetRepayDateList",strArry);
                }else{
                    object.put("targetRepayDateList",new String[0]);
                }
            }
        }

        String json_fk_D2 = JSONArray.toJSONString(jsonArray);
        //json_fk_D2 = json_fk_D2.replace("[", "");
        //json_fk_D2 = json_fk_D2.replace("]", "");
        json_fk_D2 = json_fk_D2.replace("},", "}\n");


        String writeName = jsonFile.substring(0,jsonFile.lastIndexOf("\\"))+"\\d2.txt";
        ReadOrWriteTxt.writeTxt(writeName,json_fk_D2);
        System.out.print("放款信息 D2 写入文件OK:"+writeName);
        return new GlobalResponse("0", "放款信息 D2 写入文件OK:"+writeName);
    }


    public boolean checkSecretKey(String p3,String secretKey) {
        StringBuffer resultMsg = new StringBuffer();
        if (StringUtils.isAnyBlank(RSA_PRIVATEKEY,p3,secretKey)) {
            return false;
        }
        try {
            String aes_key = RSAEncrypt.decrypt(secretKey, RSA_PRIVATEKEY);//"!QAZ@WSX3edc4rfv"
            String tmp = AesCrypto.decrypt(Base64.decode(p3.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(tmp, P3_48MD5)) {
                return false;
            }
        } catch (Exception e) {
            log.error("参数解析错误.");
            return false;
        }
        return true;
    }


    public GlobalResponse dealWithExcelData(String filePath,String type) {
        if(StringUtils.isAnyBlank(filePath,type)){
            return new GlobalResponse("1000", "百行征信手动报送失败");
        }
        List<Object> jsonArray = new ArrayList<Object>();

        List<String> lineList = ReadOrWriteTxt.readTxtList(filePath);

        String[] titleKeys = lineList.get(0).split("\t");

        StringBuffer jsonStr = new StringBuffer();
        DateFormat df_uploadTs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        for (int i = 1; i < lineList.size() ; i++) {
            String[] datas = lineList.get(i).split("\t");
            JSONObject json = new JSONObject();

            for (int k=0; k<titleKeys.length; k++){
                json.put(titleKeys[k].trim(), (datas[k]!=null ? datas[k].toString().trim() :null));
            }

            if("A1".equals(type)){
                //ApplyLoanInfoZhuDai bean = new Gson().fromJson(json.toJSONString(), new TypeToken<ApplyLoanInfoZhuDai>(){}.getType());
                ApplyLoanInfoZhuDai bean = JSONObject.toJavaObject(json, ApplyLoanInfoZhuDai.class);
                String uploadTs = df_uploadTs.format(new Date());
                bean.setUploadTs(uploadTs.replace(" ","T"));

                jsonArray.add(bean);

                jsonStr.append(JSON.toJSONString(bean));
                jsonStr.append("\n");

            }else if("D2".equals(type)){
                //LoanInfoZhuDaiVo bean = new Gson().fromJson(json.toJSONString(), new TypeToken<LoanInfoZhuDaiVo>(){}.getType());
                //FinTechAgencyBusinessZhuDai finTechAgencyBusiness = new Gson().fromJson(json.toJSONString(), new TypeToken<FinTechAgencyBusinessZhuDai>(){}.getType());
                //bean.setFinTechAgencyBusiness(finTechAgencyBusiness);

                LoanInfoZhuDai bean = JSONObject.toJavaObject(json, LoanInfoZhuDai.class);
                String uploadTs = df_uploadTs.format(new Date());
                bean.setUploadTs(uploadTs.replace(" ","T"));

                jsonArray.add(bean);

                jsonStr.append(JSON.toJSONString(bean));
                jsonStr.append("\n");

            }else if("D3".equals(type)){
                //RepaymentInfoZhuDai bean = new Gson().fromJson(json.toJSONString(), new TypeToken<RepaymentInfoZhuDai>(){}.getType());
                RepaymentInfoZhuDai bean = JSONObject.toJavaObject(json, RepaymentInfoZhuDai.class);
                String uploadTs = df_uploadTs.format(new Date());
                bean.setUploadTs(uploadTs.replace(" ","T"));
                jsonArray.add(bean);

                jsonStr.append(JSON.toJSONString(bean));
                jsonStr.append("\n");

            }else{
                log.error("其他类型type:"+type);
                jsonArray.add(json);

                jsonStr.append(JSON.toJSONString(json));
                jsonStr.append("\n");
            }
        }

        //String jsonStr = JSONArray.toJSONString(jsonArray);

        String writeName = filePath.substring(0,filePath.lastIndexOf("\\"));
        writeName = writeName + "\\build\\";
        writeName = writeName + filePath.substring(filePath.lastIndexOf("\\")+1, filePath.length());
        ReadOrWriteTxt.writeTxt(writeName,jsonStr.toString());
        log.info("处理后数据入文件OK:"+writeName);
        return new GlobalResponse("0", "处理后数据入文件OK:"+writeName);
    }


    public static void writeLog(String msg) {
        System.out.println(msg);
        try {
            String fileName = "D:\\JavaTeam\\D3_build\\out_log.txt";
            FileUtils.write(new File(fileName), msg+"\r\n", "UTF-8", true);
        } catch (IOException e) {
            e.printStackTrace();
            System.err.println("writeLog Error."+e);
        }
    }

    public static void writeLogByName(String fileName, String msg) {
        System.out.println(msg);
        try {
            //String fileName = "D:\\JavaTeam\\D3_build\\out_log.txt";
            FileUtils.write(new File(fileName), msg+"\r\n", "UTF-8", true);
        } catch (IOException e) {
            e.printStackTrace();
            System.err.println("writeLog Error."+e);
        }
    }


    public static void buildA1() {
        //A1
        String[] err_inp_reqIDs = {"..."};
        //D2
        //String[] err_inp_reqIDs = {"..."};
        Map<String,String> err_inp_reqIDMap = new HashMap<>(err_inp_reqIDs.length);
        for (String tmp1 :err_inp_reqIDs){
            err_inp_reqIDMap.put(tmp1,"err_inp");
        }
        System.out.println("err_inp_reqIDMap大小:"+err_inp_reqIDMap.size());

        //A1
        String[] err_log_reqIDs = {"986af677071e4f0aa8763688e02e6e81","c305c77631d34ad78db6a2fdae01520e"};
        //D2
        //String[] err_log_reqIDs = {"..."};
        Map<String,String> err_log_reqIDMap = new HashMap<>(err_log_reqIDs.length);
        for (String tmp2 : err_log_reqIDs){
            err_log_reqIDMap.put(tmp2,"err_log");
        }
        System.out.println("err_log_reqIDMap大小:"+err_log_reqIDMap.size());
        //---------------------------------------------------------------


        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\生产数据\\lhp_A1_20170209_20191025_01.txt");
        System.out.println("lineList:"+lineList.size());
        String fileName = "D:\\用户目录\\Downloads\\生产数据\\new_lhp_A1_20170209_20191025_01.txt";


        for(int i=0;i<lineList.size();i++){
            int flag = 0;
            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            JSONObject jsonObj= JSONObject.parseObject(str);
            String id = jsonObj.getString("reqID");

            if(err_inp_reqIDMap.containsKey(id)){
                jsonObj.put("emailAddress",null);
                writeLog(id+" Set emailAddress null.");
                flag++;
            }

            if(err_log_reqIDMap.containsKey(id)){
                err_log_reqIDMap.remove(id);
                writeLog(id+" Set remove.");
                flag++;

                if(flag>=2){
                    writeLog("发现两个错误类别都存在:"+id);
                }

                continue;
            }

            try {

                FileUtils.write(new File(fileName), jsonObj.toJSONString()+"\r\n", "UTF-8", true);
            } catch (IOException e) {
                System.err.println("build data,"+e);
            }

        }
        System.err.println("build data finTechAgencyBusiness end.");
    }

    public static void buildD2_inputerror() {
        List<String> ok_data_json = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\A1D2_M\\build_D2_01_M.txt");
        Map<String,String> ok_data_Map = new HashMap<>(ok_data_json.size());
        for(int i=0; i<ok_data_json.size(); i++){
            JSONObject jsonObj= JSONObject.parseObject(ok_data_json.get(i));
            JSONObject business = jsonObj.getJSONObject("finTechAgencyBusiness");
            ok_data_Map.put(business.getString("orderID"),jsonObj.toJSONString());
        }


        //D2
        String[] err_inp_reqIDs = {"..."};
        Map<String,String> err_inp_reqIDMap = new HashMap<>(err_inp_reqIDs.length);
        for (String tmp1 :err_inp_reqIDs){
            err_inp_reqIDMap.put(tmp1,"err_inp");
        }
        System.out.println("err_inp_reqIDMap大小:"+err_inp_reqIDMap.size());


        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\生产数据\\lhp_D2_20170209_20191025_01.txt");
        System.out.println("lineList:"+lineList.size());
        String fileName = "D:\\用户目录\\Downloads\\生产数据\\new_lhp_D2_20170209_20191025_01.txt";

        for(int i=0;i<lineList.size();i++){
            String w_str = "";

            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            JSONObject jsonObj= JSONObject.parseObject(str);
            String reqId = jsonObj.getString("reqID");
            JSONObject business = jsonObj.getJSONObject("finTechAgencyBusiness");



            if(err_inp_reqIDMap.containsKey(reqId)){

                String orderID = business.getString("orderID");
                w_str = ok_data_Map.get(orderID);
                writeLog("reqId="+reqId+" Find, orderID find "+(StringUtils.isNotBlank(w_str))+":"+w_str);
            }else{
                business.remove("institutionalFundingPartnerLoanID");//资金合作方贷款/授信账户编号
                business.remove("preCreditLimit");//预授信额度
                jsonObj.put("finTechAgencyBusiness",business);
                w_str = jsonObj.toJSONString();
            }

            try {
                FileUtils.write(new File(fileName), w_str+"\r\n", "UTF-8", true);
            } catch (IOException e) {
                System.err.println("build data,"+e);
            }

        }
        System.err.println("build data finTechAgencyBusiness end.");
    }


    public static void buildD2_logicerror() {
        //D2
        String[] err_log_reqIDs = {"492ccc1de1114529bf67c63dd766ed3c"};
        Map<String,String> err_log_reqIDMap = new HashMap<>(err_log_reqIDs.length);
        for (String tmp1 : err_log_reqIDs){
            err_log_reqIDMap.put(tmp1,"err_log_reqIDs");
        }
        System.out.println("err_log_reqIDMap大小:"+err_log_reqIDMap.size());

        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\lhp_D2_20170209_20191025_TEST_01.txt");
        System.out.println("lineList:"+lineList.size());

        String fileName = "D:\\用户目录\\Downloads\\D2_TEST_logicerror_data.txt";

        for(int i=0;i<lineList.size();i++){
            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            JSONObject jsonObj= JSONObject.parseObject(str);
            String reqId = jsonObj.getString("reqID");

            if(err_log_reqIDMap.containsKey(reqId)){
                try {
                    FileUtils.write(new File(fileName), jsonObj.toJSONString()+"\r\n", "UTF-8", true);
                } catch (IOException e) {
                    System.err.println("build data,"+e);
                }
            }
        }
        System.err.println("build data finTechAgencyBusiness end.");
    }



    public static void buildD3_logicerror() {
        //"D3_041", 贷款账户编号loanId+还款期数termNo+还款状态确认时间statusConfirmAt+业务发生机构代码在还款记录中唯一。
        List<String> logicerrorList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\生产p2p\\err041_7.log");
        Map<String,String> err_log_loanIdMap = new HashMap<>(logicerrorList.size());
        for (String strs : logicerrorList){
            String[] tmpArr = strs.split("[|]");
            err_log_loanIdMap.put(tmpArr[0]+","+tmpArr[1]+","+tmpArr[2], strs);
        }
        System.out.println("err_log_loanIdMap 大小:"+err_log_loanIdMap.size());


        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\生产p2p\\sc_D3_20190910_20191012_7.txt");
        System.out.println("lineList:"+lineList.size());
        String ok_fileName = "D:\\用户目录\\Downloads\\生产p2p\\bulid_ok\\" + "ok7_D3_20190910_20191012.txt";


        String err_D3_041_fileName = "D:\\用户目录\\Downloads\\生产p2p\\remove\\" + "rm7_e041.txt";
        String err_30003_fileName = "D:\\用户目录\\Downloads\\生产p2p\\remove\\" + "rm7_e30003.txt";

        int totalCount = 0,removeCount=0,removeCount2=0;
        for(int i=0;i<lineList.size();i++){
            System.out.println("START:"+i);

            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            RepaymentInfoZhuDai repaymentLoanInfo = new Gson().fromJson(str, new TypeToken<RepaymentInfoZhuDai>(){}.getType());
            String loanId = repaymentLoanInfo.getLoanId();
            String key = loanId+","+repaymentLoanInfo.getTermNo()+","+repaymentLoanInfo.getStatusConfirmAt();
            //"errorCode":"D3_041"
            if (err_log_loanIdMap.containsKey(key)) {
                //100011189,9,2019-02-22T00:00:00
                //删掉  本次还款金额 实际还款时间 为空的一条   "realRepayment":0,"realRepaymentDate":""
                if (repaymentLoanInfo.getRealRepayment() == null || repaymentLoanInfo.getRealRepayment().intValue() == 0) {
                    if (repaymentLoanInfo.getRealRepaymentDate() == null || repaymentLoanInfo.getRealRepaymentDate().equals("")) {
                        writeLogByName(err_D3_041_fileName,JSON.toJSONString(repaymentLoanInfo));
                        removeCount++;
                        continue;
                    }
                }
            }

            //{"errorCode":"ERR_30003"
            if(repaymentLoanInfo.getMobile()==null || repaymentLoanInfo.getMobile().length()!=11){
                writeLogByName(err_30003_fileName,JSON.toJSONString(repaymentLoanInfo));
                removeCount2++;
                continue;
            }

            try {
                FileUtils.write(new File(ok_fileName), JSON.toJSONString(repaymentLoanInfo)+"\r\n", "UTF-8", true);
            } catch (IOException e) {
                System.err.println("build D3 data,"+e);
            }
            totalCount++;
        }
        System.out.println("build D3 end, lineList="+lineList.size()+",totalCount="+totalCount+",removeCount="+removeCount+",removeCount2="+removeCount2+
                ", 合="+(totalCount+removeCount+removeCount2));
    }


    /**
     * 描述: 删除掉D3中本LoanId一样，本次还款金额&实际还款时间 为空的一条 <br/>
     * |awk -F ',"' '{print $1 $17 "\"" $14}' |awk -F '"' '{print $4 $6"_"$9}' |sort |uniq -c |awk '$1 > 1 {print $1}' |more
     * 参数: [oldDataFile, cfLoanIdLogFile, newDataFile]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.12.22  <br/>
     */
    public static String remove_D3_loanId_chunfu(String oldDataFile, String cfLoanIdLogFile, String newFileName, String rmIdFileName,String rmPhoneFileName) {
        try{
            List<String> logicerrorList = ReadOrWriteTxt.readTxtList(cfLoanIdLogFile);
            Map<String,String> err_log_loanIdMap = new HashMap<>(logicerrorList.size());
            for (String strs : logicerrorList){
                //2 SP290206392723262586192081:11_2019-11-03T00:00:00
                if(strs.trim().length()<10){
                    log.info("remove_D3_loanId_chunfu warn strs="+strs);
                    continue;
                }
                String[] tmpArr = strs.trim().split("[ ]");
                tmpArr = tmpArr[1].split("[_]");
                //SP290206392723262586192081,11,2019-11-03T00:00:00
                err_log_loanIdMap.put(tmpArr[0].replace(":",",")+","+tmpArr[1], strs.trim());
            }
            logicerrorList = null;
            log.info("remove_D3_loanId_chunfu err_log_loanIdMap 大小:"+err_log_loanIdMap.size());

            List<String> lineList = ReadOrWriteTxt.readTxtList(oldDataFile);
            log.info("remove_D3_loanId_chunfu lineList:"+lineList.size());

            int totalCount = 0,removeCount=0,removeCount2=0;
            for(int i=0;i<lineList.size();i++){
                log.info("START:"+i);

                String JsonStr = lineList.get(i);
                if(JsonStr.length() < 30 ){//#singleLoanRepayInfo
                    continue;
                }
                RepaymentInfoZhuDai repaymentLoanInfo = new Gson().fromJson(JsonStr, new TypeToken<RepaymentInfoZhuDai>(){}.getType());
                String loanId = repaymentLoanInfo.getLoanId();
                String key = loanId+","+repaymentLoanInfo.getTermNo()+","+repaymentLoanInfo.getStatusConfirmAt();
                //"errorCode":"D3_041"
                if (err_log_loanIdMap.containsKey(key)) {
                    //100011189,9,2019-02-22T00:00:00
                    //删掉  本次还款金额 实际还款时间 为空的一条   "realRepayment":0,"realRepaymentDate":""
                    if (repaymentLoanInfo.getRealRepayment() == null || repaymentLoanInfo.getRealRepayment().intValue() == 0) {
                        if (repaymentLoanInfo.getRealRepaymentDate() == null || repaymentLoanInfo.getRealRepaymentDate().equals("")) {
                            writeLogByName(rmIdFileName, JsonStr);
                            removeCount++;
                            continue;
                        }
                    }
                }

                //{"errorCode":"ERR_30003"
                if(repaymentLoanInfo.getMobile()==null || repaymentLoanInfo.getMobile().length()!=11){
                    writeLogByName(rmPhoneFileName, JsonStr);
                    removeCount2++;
                    continue;
                }

                try {
                    FileUtils.write(new File(newFileName), JsonStr+"\r\n", "UTF-8", true);
                } catch (IOException e) {
                    log.error("remove_D3_loanId_chunfu write newD3 data error,"+e);
                }
                totalCount++;
            }
            log.info("remove_D3_loanId_chunfu end, lineList="+lineList.size()+",totalCount="+totalCount+",removeCount="+removeCount+",removeCount2="+removeCount2+
                    ", 合="+(totalCount+removeCount+removeCount2));
            return "lineList="+lineList.size()+",totalCount="+totalCount+",removeCount="+removeCount+",removeCount2="+removeCount2+ ", 合="+(totalCount+removeCount+removeCount2);

        }catch (Exception e){
            log.error("check_D3loanId_InD2 Error,",e);
        }
        return null;
    }

    /**
     * 描述: 监测D3中的loanId是否在D2中 <br/>
     * 参数: [d3LoanIdFile, d2File, inFileName, notInFileName]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.12.22  <br/>
     */
    public static String check_D3loanId_InD2(String d3LoanIdFile, String d2File, String inFileName, String notInFileName) {
        try{
            List<String> d2DataList = ReadOrWriteTxt.readTxtList(d2File);
            Map<String,String> d2_loanIdMap = new HashMap<>(d2DataList.size());
            int d2size = 0;
            for (String strs : d2DataList){
           /* if(strs.trim().length()<30){
                log.info("check_D3loanId_InD2 warn strs="+strs);
                continue;
            }
            JSONObject d2Json = JSONObject.parseObject(strs);
            d2_loanIdMap.put(d2Json.getString("loanId"), d2Json.getString("reqID"));*/

                if(strs.trim().length()<1){
                    log.info("check_D3loanId_InD2 warn strs="+strs);
                    continue;
                }
                //key=loanId
                d2_loanIdMap.put(strs.trim(), ""+(d2size++));
            }
            log.info("check_D3loanId_InD2 d2DataList大小: {} , d2_loanIdMap大小: {} ", d2DataList.size(), d2_loanIdMap.size());
            d2DataList = null;

            //cat lhp_D3.txt |grep -v '#singleLoanRepayInfo' |awk -F '"loanId":"' '{print $2}' |awk -F '","' '{print $1}' |sort |uniq -c |more
            List<String> d3LoanIdList = ReadOrWriteTxt.readTxtList(d3LoanIdFile);
            log.info("check_D3loanId_InD2 d3LoanIdList:"+d3LoanIdList.size());
            int in=0, notin=0;
            for(int i=0; i<d3LoanIdList.size(); i++){

                if(d3LoanIdList.get(i).trim().length()<1){
                    log.info("check_D3loanId_InD2 warn strs="+d3LoanIdList.get(i).trim());
                    continue;
                }

                // 2 SP12323232
                String[] tmpArr = d3LoanIdList.get(i).trim().split("[ ]");
                if(d2_loanIdMap.containsKey(tmpArr[1])){
                    try {
                        FileUtils.write(new File(inFileName), d3LoanIdList.get(i).trim()+"\r\n", "UTF-8", true);
                    } catch (IOException e) {
                        log.error("check_D3loanId_InD2 write in data error,"+e);
                    }
                    in++;
                }else{
                    try {
                        FileUtils.write(new File(notInFileName), d3LoanIdList.get(i).trim()+"\r\n", "UTF-8", true);
                    } catch (IOException e) {
                        log.error("check_D3loanId_InD2 write notin data error,"+e);
                    }
                    notin++;
                }
            }
            log.info("d3LoanIdList="+d3LoanIdList.size()+",d2_loanIdMap="+d2_loanIdMap.size()+",in="+in+",notin="+notin);
            return "d3LoanIdList="+d3LoanIdList.size()+",d2_loanIdMap="+d2_loanIdMap.size()+",in="+in+",notin="+notin;
        }catch (Exception e){
            log.error("check_D3loanId_InD2 Error,",e);
        }
        return null;
    }

    /**
     * 描述: 监测D2中的loanId是否在D3中已完结 <br/>
     * 参数: [d3LoanIdFile, d2File, inFileName, notInFileName]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.12.22  <br/>
     */
    public static String check_D2loanId_InD3WanJie(String d3LoanIdFile, String d2File, String notWJFileName) {
        try{
            List<String> d2DataList = ReadOrWriteTxt.readTxtList(d2File);
            Map<String,String> d2_loanIdMap = new HashMap<>(d2DataList.size());
            int d2size=0;
            for (String strs : d2DataList){
            /*if(strs.trim().length()<30){
                log.info("check_D2loanId_InD3WanJie warn strs="+strs);
                continue;
            }

            JSONObject d2Json = JSONObject.parseObject(strs);
            d2_loanIdMap.put(d2Json.getString("loanId"), ""+d2Json.getIntValue("totalTerm"));*/

                if(strs.trim().length()<1){
                    log.info("check_D2loanId_InD3WanJie warn strs="+strs);
                    continue;
                }
                //key=loanId
                d2_loanIdMap.put(strs.trim(), ""+(d2size++));

            }
            log.info("check_D2loanId_InD3WanJie d2DataList大小: {}, d2_loanIdMap大小: {} ",d2DataList.size(), d2_loanIdMap.size());
            d2DataList = null;

            //cat lhp_D3.txt |grep '"loanStatus":3,' |awk -F '"loanId":"' '{print $2}' |awk -F '","' '{print $1}' |sort |uniq -c |more
            List<String> d3LoanIdList = ReadOrWriteTxt.readTxtList(d3LoanIdFile);
            log.info("check_D2loanId_InD3WanJie d3LoanIdList:"+d3LoanIdList.size());

            int d2rmCount=0, d2_loanIdMapSize=d2_loanIdMap.size();
            for(int i=0; i<d3LoanIdList.size(); i++){
            /*if(d3LoanIdList.get(i).length()<30){
                log.info("check_D2loanId_InD3WanJie warn strs="+d3LoanIdList.get(i));
                continue;
            }
            JSONObject d3Json = JSONObject.parseObject(d3LoanIdList.get(i));
            if(d3Json.containsKey("loanStatus") && d3Json.getIntValue("loanStatus")==3){
                if(d2_loanIdMap.containsKey(d3Json.getString("loanId"))){
                    log.info("CHECK_D2LOANID_IND3WANJIE IN d2Map rm>>"+d3Json.getString("loanId")+","+d2_loanIdMap.get(d3Json.getString("loanId")));
                    d2_loanIdMap.remove(d3Json.getString("loanId"));
                    d2rmCount++;
                }else{
                    log.error("CHECK_D2LOANID_IND3WANJIE not IN d2Map d3Msg>>>"+d3LoanIdList.get(i));
                }
            }*/

                if(d3LoanIdList.get(i).length()<1){
                    log.info("check_D2loanId_InD3WanJie warn d3Sort="+d3LoanIdList.get(i));
                    continue;
                }
                // 2 SP12323232
                String[] tmpArr = d3LoanIdList.get(i).trim().split("[ ]");
                if(tmpArr.length>=2){
                    if(d2_loanIdMap.containsKey(tmpArr[1])){
                        log.info("CHECK_D2LOANID_IND3WANJIE IN d2Map rm>>"+tmpArr[1]+","+d2_loanIdMap.get(tmpArr[1]));
                        d2_loanIdMap.remove(tmpArr[1]);
                        d2rmCount++;
                    }else{
                        log.error("CHECK_D2LOANID_IND3WANJIE not IN d2Map d3Msg>>>"+d3LoanIdList.get(i));
                    }
                }else{
                    log.error("CHECK_D2LOANID_IND3WANJIE d3Sort !length>=2 :"+d3LoanIdList.get(i));
                }
            }
            d3LoanIdList = null;
            log.info("check_D2loanId_InD3WanJie d2_loanIdMapSize:"+d2_loanIdMapSize+",d2rmCount="+d2rmCount+",d2have="+d2_loanIdMap.size());


            if(d2_loanIdMap.size()>0){
                for(Map.Entry<String,String> d2Id_totalTerm : d2_loanIdMap.entrySet()){
                    String msg = d2Id_totalTerm.getKey()+","+d2Id_totalTerm.getValue();
                    try {
                        FileUtils.write(new File(notWJFileName), msg+"\r\n", "UTF-8", true);
                    } catch (IOException e) {
                        log.error("check_D2loanId_InD3WanJie notWJFile error,"+e);
                    }
                }
            }

            return "check_D2loanId_InD3WanJie d2_loanIdMapSize:"+d2_loanIdMapSize+",d2rmCount="+d2rmCount+",d2have="+d2_loanIdMap.size();
        }catch (Exception e){
            log.error("check_D3loanId_InD2 Error,",e);
        }
        return null;
    }


    public static void manualGC() {
        try {
            long totalMemory = Runtime.getRuntime().totalMemory();
            long freeMemory = Runtime.getRuntime().freeMemory();
            long usedMemory = totalMemory - freeMemory;
            java.text.NumberFormat format = new java.text.DecimalFormat("###,###");

            String memoryInfo = "垃圾回收前，内存使用情况为：已用内存/总内存：" + format.format(usedMemory) + "/" + format.format(totalMemory);
            System.out.println("gc:" + memoryInfo);
            System.out.println("gc:垃圾回收开始，时间为:" + System.currentTimeMillis());

            System.gc();

            totalMemory = Runtime.getRuntime().totalMemory();
            freeMemory = Runtime.getRuntime().freeMemory();
            usedMemory = totalMemory - freeMemory;
            memoryInfo = "垃圾回收后，内存使用情况为：已用内存/总内存：" + format.format(usedMemory) + "/" + format.format(totalMemory);
            System.out.println(memoryInfo);
            System.out.println("垃圾回收结束，时间为:" + System.currentTimeMillis());
        } catch (Exception e) {
            System.err.println("gc: error!" + e.toString());
        }
    }

    public static void testMd5() {
        String newJsonFile = "E:\\桌面_工作\\新阳Md5\\aa.txt";
        String fileName = "E:\\桌面_工作\\新阳Md5\\aa_2.txt";

        List<String> newJsonList = ReadOrWriteTxt.readTxtList(newJsonFile);
        System.out.println("newJsonList大小:" + newJsonList.size());

        for (int i = 0; i < newJsonList.size(); i++) {
            System.out.println("Start:"+i);
            String[] arr = newJsonList.get(i).split("[|]");
            //loanId|name|pid|mobile
            String msg = arr[0]+"\t";
            msg+=MD5Util.getMd5(arr[1])+"\t";
            msg+=MD5Util.getMd5(arr[2])+"\t";
            msg+=MD5Util.getMd5(arr[3])+"\t";

            try {
                FileUtils.write(new File(fileName), msg+"\r\n", "UTF-8", true);
            } catch (IOException e) {
                System.err.println("build data,"+e);
            }
        }
    }



    @Async
    public void newD3ReplaceReqId(String newD3FilePath, String newD3FileNames, String oldD3ReqIdFile, String mapNotEmptyFile) {
        try{
            List<String>  oldD3ReqIdFileList = ReadOrWriteTxt.readTxtList(oldD3ReqIdFile);
            Map<String,String> oldD3_reqIdMap = new HashMap<>(oldD3ReqIdFileList.size());
            String[] tmpArry = null;
            for (String reqIdMsg : oldD3ReqIdFileList){
                //SP117934268911419343386834|2|2018-07-18T00:00:00|ts:normal|ls:1=bcc7c1b0a39a4c79a8622adc7c735bea
                if(reqIdMsg.length()<5){
                    continue;
                }
                tmpArry = reqIdMsg.split("[=]");
                oldD3_reqIdMap.put(tmpArry[0], tmpArry[1]);
            }
            log.info("newD3ReplaceReqId listSize: {} , mapSize: {} ", oldD3ReqIdFileList.size(), oldD3_reqIdMap.size());
            oldD3ReqIdFileList = null;

            String[] all_id3_fileNames = newD3FileNames.split(",");

            List<String> d3lineList = null;
            RepaymentInfoZhuDai repaymentLoanInfo = null;
            for(String fileName : all_id3_fileNames){
                log.info("THE FILENAME:"+fileName);
                if(!newD3FilePath.endsWith("/") && !newD3FilePath.endsWith("\\")){
                    newD3FilePath = newD3FilePath + "/";
                }
                d3lineList = ReadOrWriteTxt.readTxtList(newD3FilePath + fileName);
                int have = 0, notHave=0, listSize=d3lineList.size();
                log.info(fileName+" lineList size:"+d3lineList.size());

                for(int i=0;i<d3lineList.size();i++){
                    try {
                        log.info(fileName+"S:"+i);

                        String d3JsonStr = d3lineList.get(i);
                        if(d3JsonStr.length()<30){//#singleLoanRepayInfo
                            continue;
                        }
                        repaymentLoanInfo = new Gson().fromJson(d3JsonStr, new TypeToken<RepaymentInfoZhuDai>(){}.getType());

                        String key_replace = repaymentLoanInfo.getLoanId()+"|"+repaymentLoanInfo.getTermNo()+"|"+repaymentLoanInfo.getStatusConfirmAt()
                                +"|ts:"+repaymentLoanInfo.getTermStatus()+"|ls:"+repaymentLoanInfo.getLoanStatus();

                        if(oldD3_reqIdMap.containsKey(key_replace)){//找到了
                            have++;
                            repaymentLoanInfo.setReqID(oldD3_reqIdMap.get(key_replace));
                            repaymentLoanInfo.setOpCode("M");
                            //是要删除，D3_035
                            FileUtils.write(new File(newD3FilePath+"in_new_"+fileName), JSON.toJSONString(repaymentLoanInfo)+"\r\n", "UTF-8", true);

                            oldD3_reqIdMap.remove(key_replace);
                        }else{
                            notHave++;
                            FileUtils.write(new File(newD3FilePath+"notIn_new_"+fileName), JSON.toJSONString(repaymentLoanInfo)+"\r\n", "UTF-8", true);
                        }
                    } catch (Exception e) {
                        log.error(fileName+":筛选替换 error,", e);
                    }
                }
                log.info(fileName+":筛选替换 end, listSize: {} , have: {} , notHave: {} , 合计: {} ", listSize,have,notHave,(have+notHave));
                d3lineList = null;
                repaymentLoanInfo = null;
                have=0;notHave=0;listSize=0;

                Thread.sleep(1500);
            }


            if(oldD3_reqIdMap.size()>0){
                log.warn("oldD3_reqIdMap IS NOT EMPTY:"+oldD3_reqIdMap.size());
                int wr = 0;
                for(String key : oldD3_reqIdMap.keySet()){
                    log.info("oldD3_reqIdMap wr:"+(wr++));
                    try {
                        FileUtils.write(new File(mapNotEmptyFile), key+"="+oldD3_reqIdMap.get(key)+"\r\n", "UTF-8", true);
                    } catch (IOException e) {
                        log.error("oldD3_reqIdMap 写入 error ", e);
                    }
                }
            }

        }catch (Exception e){
            log.error("newD3ReplaceReqId 异常",e);
        }

        log.info("All newD3ReplaceReqId() end.");
    }


    @Async
    public void d2_saveLog(String d2JsonFileName,String reqIdFileName,String no_reqId_start, String isHaveRecordId) {
        boolean haveReqID = false;
        List<String> reqID_Str_List = null;
        HashMap<String,String> reqID_Map = null;

        try{
            if(StringUtils.isNotEmpty(reqIdFileName)){
                reqID_Str_List = ReadOrWriteTxt.readTxtList(reqIdFileName);
                log.info("files reqID_Str_List size="+reqID_Str_List.size());
                reqID_Map = new HashMap<>(reqID_Str_List.size());

                String[] arry = null;
                //oldReqID=30067778,newReqID=199bbec95c0b41178055f1c5164bd7fb
                for(String str : reqID_Str_List){
                    if(str.length()<2){
                        continue;
                    }
                    arry = str.split("=");
                    reqID_Map.put(arry[2],arry[1].split(",")[0]);
                }
                haveReqID = true;
            }
            log.info("param haveReqID: {} , reqID_Str_List: {} , reqID_Map: {} ", haveReqID, (reqID_Str_List!=null ? reqID_Str_List.size() : "null"), (reqID_Map!=null ? reqID_Map.size() : "null"));
            reqID_Str_List = null;


            List<String> d2JsonList = ReadOrWriteTxt.readTxtList(d2JsonFileName);
            log.info("files d2JsonList size="+d2JsonList.size());

            int no_reqId = 0, saveCount=0;
            if(StringUtils.isNotEmpty(no_reqId_start)){
                no_reqId = Integer.parseInt(no_reqId_start);
            }

            boolean haveRecordId = false;
            if(StringUtils.isNotEmpty(isHaveRecordId) && isHaveRecordId.equals("true")){
                haveRecordId = true;
            }

            for(int i=0; i<d2JsonList.size(); i++){
                String jsonStr = d2JsonList.get(i);
                if(jsonStr.length()<30){
                    continue;
                }
                //LoanInfoZhuDaiVo loanInfo

                JSONObject jsonObject = JSONObject.parseObject(jsonStr);
                JSONObject business = jsonObject.getJSONObject("finTechAgencyBusiness");
                FinTechAgencyBusinessZhuDai finTechAgencyBusiness = JSONObject.parseObject(business.toJSONString(), FinTechAgencyBusinessZhuDai.class);


                LoanInfoZhuDai loanInfozd_tmp = JSONObject.parseObject(jsonStr, LoanInfoZhuDai.class);

                loanInfozd_tmp.setInstitutionalFundingPartner(finTechAgencyBusiness.getInstitutionalFundingPartner());
                loanInfozd_tmp.setInstitutionalFundingPartnerID(finTechAgencyBusiness.getInstitutionalFundingPartnerID());
                loanInfozd_tmp.setRelationID(finTechAgencyBusiness.getRelationID());
                loanInfozd_tmp.setInstitutionalFundingPartnerLoanID(finTechAgencyBusiness.getInstitutionalFundingPartnerLoanID());
                loanInfozd_tmp.setOrderID(finTechAgencyBusiness.getOrderID());
                loanInfozd_tmp.setPreCreditLimit(finTechAgencyBusiness.getPreCreditLimit());

                if(!haveRecordId){
                    loanInfozd_tmp.setRecordId(loanInfozd_tmp.getReqID());
                    loanInfozd_tmp.setReqID(null);
                }

                if(haveReqID && reqID_Map.containsKey(loanInfozd_tmp.getRecordId())){
                    loanInfozd_tmp.setReqID(reqID_Map.get(loanInfozd_tmp.getRecordId()));
                    reqID_Map.remove(loanInfozd_tmp.getRecordId());
                }

                if(StringUtils.isEmpty(loanInfozd_tmp.getReqID())){
                    no_reqId++;
                    loanInfozd_tmp.setReqID("no_"+no_reqId);

                }

                try{
                    loanInfoDbMapper.saveLoanInfoRecordLog(loanInfozd_tmp);
                    saveCount++;
                }catch(Exception e){
                    log.error("保存放款记录失败, DATA: {} ", jsonStr, e);
                }

                log.info("Build End:"+i);
            }
            log.info("All D2 LOG:保存放款记录结束, d2JsonList: {} , no_reqId: {} , saveCount: {} ",d2JsonList.size(),no_reqId,saveCount);
        }catch (Exception e){
            log.error("处理放款记录异常！", e);
        }
    }

    @Async
    public void d3_saveLog(String d3FilePath, String d3JsonFileNames, String reqIdLogName, String no_reqId_start, String isHaveRecordId) {
        try{
            boolean haveReqID = false;
            List<String> reqID_Str_List = null;
            HashMap<String,String> reqID_Map = null;

            if(StringUtils.isNotEmpty(reqIdLogName)){
                reqID_Str_List = ReadOrWriteTxt.readTxtList(reqIdLogName);
                log.info("files reqID_Str_List size="+reqID_Str_List.size());
                reqID_Map = new HashMap<>(reqID_Str_List.size());

                String[] arry = null;
                //oldReqID=30067778,newReqID=199bbec95c0b41178055f1c5164bd7fb
                for(String str : reqID_Str_List){
                    if(str.length()<2){
                        continue;
                    }
                    arry = str.split("=");
                    reqID_Map.put(arry[2],arry[1].split(",")[0]);
                }
                haveReqID = true;
            }
            log.info("param haveReqID: {} , reqID_Str_List: {} , reqID_Map: {} ", haveReqID, (reqID_Str_List!=null ? reqID_Str_List.size() : "null"), (reqID_Map!=null ? reqID_Map.size() : "null"));
            reqID_Str_List = null;

            boolean haveRecordId = false;
            if(StringUtils.isNotEmpty(isHaveRecordId) && isHaveRecordId.equals("true")){
                haveRecordId = true;
            }


            int no_reqId = 0;
            if(StringUtils.isNotEmpty(no_reqId_start)){
                no_reqId = Integer.parseInt(no_reqId_start);
            }

            List<String> d3lineList = null;

            String[] all_id3_fileNames = d3JsonFileNames.trim().split(",");
            for(String fileName : all_id3_fileNames){
                log.info(">>>>>>>>THE FILENAME START:"+fileName);

                if(!d3FilePath.endsWith("/") && !d3FilePath.endsWith("\\")){
                    d3FilePath = d3FilePath + "/";
                }

                d3lineList = ReadOrWriteTxt.readTxtList(d3FilePath + fileName);
                int saveCount = 0, tmp_not_recordId=0, listSize=d3lineList.size();
                log.info(fileName+" lineList size:"+d3lineList.size());

                RepaymentInfoZhuDai repaymentLoanInfo = null;
                for(int i=0;i<d3lineList.size();i++){
                    try {
                        String d3JsonStr = d3lineList.get(i);

                        if(d3JsonStr.length()<30){//#singleLoanRepayInfo
                            continue;
                        }

                        repaymentLoanInfo = new Gson().fromJson(d3JsonStr, new TypeToken<RepaymentInfoZhuDai>(){}.getType());

                        if(!haveRecordId){
                            repaymentLoanInfo.setRecordId(repaymentLoanInfo.getReqID());
                            repaymentLoanInfo.setReqID(null);
                        }

                        if(haveReqID && reqID_Map.containsKey(repaymentLoanInfo.getRecordId())){
                            repaymentLoanInfo.setReqID(reqID_Map.get(repaymentLoanInfo.getRecordId()));
                            reqID_Map.remove(repaymentLoanInfo.getRecordId());
                        }

                        if(StringUtils.isEmpty(repaymentLoanInfo.getReqID())){
                            no_reqId++;
                            tmp_not_recordId++;
                            repaymentLoanInfo.setReqID("no_"+no_reqId);
                        }

                        try{
                            repaymentLoanInfoDbMapper.saveRepaymentLoanInfoLog(repaymentLoanInfo);
                            saveCount++;
                        }catch(Exception e){
                            log.error("保存还款数据记录失败, fileName: {} , DATA: {} ", fileName, d3JsonStr, e);
                        }

                        log.info("Build Save D3 End:"+i);
                    } catch (Exception e) {
                        log.error("保存还款数据处理异常, fileName: {} , DATA: {} ", fileName, d3lineList.get(i), e);
                    }
                }
                log.info(fileName+"<<<<<<保存还款数据记录结束, listSize: {} , saveCount: {} , tmp_not_recordId: {} ", listSize, saveCount, tmp_not_recordId);
                d3lineList = null;
                repaymentLoanInfo = null;
                saveCount=0;tmp_not_recordId=0;listSize=0;

                Thread.sleep(1500);
            }
        }catch (Exception e){
            log.error("newD3ReplaceReqId 异常",e);
        }
        log.info("-----All 保存还款数据记录结束-----.");
    }


    public void deleteRedisKey(String key1, String key2, String key3) {
        String full_rediskey = "";
        if (StringUtils.isNotEmpty(key1)) {
            full_rediskey += key1;
        }
        if (StringUtils.isNotEmpty(key2)) {
            full_rediskey += key2;
        }
        if (StringUtils.isNotEmpty(key3)) {
            full_rediskey += key3;
        }
        redisTemplate.delete(full_rediskey);
        log.info("删除RedisKey成功, key1: {} , key2: {} , key3: {} , full_rediskey: {} ", key1, key2, key3, full_rediskey);
    }

    public String getRedisVal(String key) {
        Map<String,Object> map = new HashMap<>();
        map.put("key",key);
        if(StringUtils.isBlank(key)){
            return JSONObject.toJSONString(map);
        }
        try{
            String value = redisTemplate.opsForValue().get(key);
            Long expire = redisTemplate.getExpire(key);
            map.put("value",value);
            map.put("expire", expire);
        }catch (Exception e){
            log.error("获取redis里值异常, key: {} ", key, e);
        }
        return map.toString();
    }



    /**
     * 获取某个文件夹下的所有文件
     *
     * @param fileNameList 存放文件名称的list
     * @param path 文件夹的路径
     * @return
     */
    private static void getAllFileName(String path, ArrayList<String> fileNameList) {
        boolean flag = false;
        File file = new File(path);
        File[] tempList = file.listFiles();

        if(tempList==null || tempList.length<=0){
            return;
        }
        for (int i = 0; i < tempList.length; i++) {
            if (tempList[i].isFile()) {
                fileNameList.add(tempList[i].getName());
            }
            if (tempList[i].isDirectory()) {
                getAllFileName(tempList[i].getAbsolutePath(),fileNameList);
            }
        }
        return;
    }


}
