package cn.quantgroup.report.controller;

import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author fengjunkai
 */
@Slf4j
@RestController
@RequestMapping("/")
public class DiscoveryManagerController {

    @Autowired
    @Qualifier("eurekaClient")
    private EurekaClient eurekaClient;

    @RequestMapping("clientShutdown")
    public void clientShutdown(){
        try{
            eurekaClient.shutdown();
            log.info("百行报送项目通知eureka下线成功");
        }catch(Exception e){
            log.error("百行报送项目通知eureka下线异常", e);
        }
    }

    @RequestMapping("test1")
    public String test(){
        try {
            log.info("开始执行");
            Thread.sleep(10000);
            log.info("执行结束");
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        return "hello world !!!";
    }

}
