package cn.quantgroup.report.service.xyqbuser;

import cn.quantgroup.report.error.QGExceptionType;
import cn.quantgroup.report.mapper.xyqbuser.UserMapper;
import cn.quantgroup.report.domain.xyqbuser.User;
import cn.quantgroup.report.domain.xyqbuser.UserDetail;
import cn.quantgroup.report.error.QGPreconditions;
import cn.quantgroup.report.mapper.xyqbuser.UserDetailMapper;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
@Slf4j
public class XyqbUserService {
  @Autowired
  private UserDetailMapper userDetailMapper;
  @Autowired
  private UserMapper userMapper;

  public Long findUserIdByIdentityNumberAndName(String identityNumber, String name) {
    List<UserDetail> userDetailList = userDetailMapper.selectByIdentityNumber(identityNumber);
    log.info("91征信匹配查询用户详细信息, identityNumber:{}, name:{}, 结果:{}", identityNumber, name, JSON.toJSONString(userDetailList));
    QGPreconditions.checkArgument(CollectionUtils.isNotEmpty(userDetailList), QGExceptionType.XYQB_USER_NOT_EXSIT);
    Optional<UserDetail> optional = userDetailList.parallelStream().filter(detail -> StringUtils.equals(detail.getName(), name)).findFirst();
    QGPreconditions.checkArgument(optional.isPresent(), QGExceptionType.XYQB_USER_NOT_MATCH);
    return optional.get().getUserId();
  }

  public User getUserByUUid(String uuid) {
    return userMapper.selectByUuid(uuid);
  }

  public User getUserById(Long id) {
    return userMapper.selectByPrimaryKey(id);
  }

  public UserDetail getUserDetailByUserID(Long userId) {
    return userDetailMapper.selectByUserId(userId);
  }

}
