package cn.quantgroup.report.controller;

import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.common.CommonQueryService;
import cn.quantgroup.report.service.manualTool.ManualToolService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value = "/manualtool")
public class ManualToolController {

  @Autowired
  private ManualToolService manualToolService;

  @Autowired
  private CommonQueryService queryService;

 /* @Autowired
  private RedisTemplate redisTemplate;*/

  /*@RequestMapping("/clear_huadao_token")
  public GlobalResponse clearHuadaoToken(){
    try{
      redisTemplate.delete("NEW_HUADAO_QUERY_TOKEN_KEY");
      log.info("清除华道缓存token成功");
      return GlobalResponse.generate("清除华道缓存token成功");
    }catch(Exception e){
      log.info("清除华道缓存token异常");
      return GlobalResponse.generate("清除华道缓存token异常");
    }
  }*/


  @RequestMapping("/send/baihang")
  public GlobalResponse sendBaihang(String p1,String p2,String p3,String p4,String p5,String secretKey, String isSend,String errorCode) {
    try{
      return manualToolService.sendBaiHangData(p1,p2,p3,p4,p5,secretKey,isSend,errorCode);
    }catch (Exception e){
      log.error("百行征信手动报送异常, {} , {} ", e.getMessage(), e);
      return GlobalResponse.generate(e.getMessage());
    }
  }


  /**
   * 描述: 放款信息 D2 <br/>
   * 参数: [jsonFile]  <br/>
   * 返回值: GlobalResponse  <br/>
   * 创建人: yanhui.Hao  <br/>
   * 创建时间: 2019.09.27  <br/>
   */
  @RequestMapping("/build/d2")
  public GlobalResponse buildLoanInfoD2(String jsonFile) {
    try{
      return manualToolService.buildLoanInfoD2(jsonFile);
    }catch (Exception e){
      log.error("百行征信手动报送异常, {} , {} ", e.getMessage(), e);
      return GlobalResponse.generate(e.getMessage());
    }
  }


  /**
   * 描述: 应商务要求测试-品钛高德分 <br/>
   * 参数: [jsonFile]  <br/>
   * 返回值: GlobalResponse  <br/>
   * 创建人: yanhui.Hao  <br/>
   * 创建时间: 2019.10.17  <br/>
   */
  @RequestMapping("/request/pinTaiCreditScoreV1")
  public GlobalResponse pinTaiCreditScoreV1(String filePath,String p3,String secretKey) {
    try{
      return manualToolService.testPTCreditScoreV1(filePath,p3,secretKey);
    }catch (Exception e){
      log.error("品钛高德分测试异常, {} , {} ", e.getMessage(), e);
      return GlobalResponse.generate(e.getMessage());
    }
  }


  /**
   * 描述: 手动刷新getUuiidWhiteListByServiceAndMethod <br/>
   * 参数: [p3, secretKey]  <br/>
   * 返回值: void  <br/>
   * 创建人: yanhui.Hao  <br/>
   * 创建时间: 2019.10.22  <br/>
   */
  @RequestMapping("/refreshUuidWhite")
  public GlobalResponse refreshUuidWhite(String p3,String secretKey){
    if(manualToolService.checkSecretKey(p3,secretKey)){
      return queryService.refreshUuidWhite();
    }else{
      log.info("refreshUuidWhite checkSecretKey fail.");
      return new GlobalResponse("1012", "参数错误");
    }
  }

  /**
   * 描述: 插入库，或修改库 <br/>
   * 参数: [p3, secretKey, type, params]
   * type, 可传insert或delete <br/>
   * params, 是methodName|serviceName|uuid，多个用户可以用逗号分隔  <br/>
   * 返回值: void  <br/>
   * 创建人: yanhui.Hao  <br/>
   * 创建时间: 2019.10.22  <br/>
   */
  @RequestMapping("/updateUuidWhite")
  public GlobalResponse updateUuidWhite(String p3,String secretKey, String type, String params){
    if(manualToolService.checkSecretKey(p3,secretKey)){
      return queryService.updateUuidWhite(type,params);
    }else{
      log.info("updateUuidWhite checkSecretKey fail.");
      return new GlobalResponse("1012", "参数错误");
    }
  }

}
