package cn.quantgroup.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;



@PropertySource({
		"classpath:application.properties"
})
//@ComponentScan(basePackages = {"cn.quantgroup.report"})
@SpringBootApplication
@Slf4j
@EnableAsync
@EnableScheduling
@EnableConfigurationProperties
public class BaihangReportApplication {

	public static void main(String[] args) {
		JSON.DEFAULT_GENERATE_FEATURE = JSON.DEFAULT_GENERATE_FEATURE |= SerializerFeature.WriteEnumUsingToString.getMask();

		SpringApplication.run(BaihangReportApplication.class, args);
		log.info(">>>>baihang-report start server OK...");
	}
}
