package cn.quantgroup.report.service.common;

import cn.quantgroup.report.ApplicationContextHolder;
import cn.quantgroup.report.cmpt.CommonAlarmCmpt;
import cn.quantgroup.report.constant.TransactionCodeEnum;
import cn.quantgroup.report.domain.master.DsSpecialUserHandle;
import cn.quantgroup.report.domain.sdk.SdkUser;
import cn.quantgroup.report.mapper.master.DsSpecialUserHandleMapper;
import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.CommonSuperService;
import cn.quantgroup.report.service.common.model.CommonParams;
import cn.quantgroup.report.service.usersdk.IUserCenterService;
import cn.quantgroup.report.utils.CheckUtils;
import cn.quantgroup.report.utils.IdUtils;
import cn.quantgroup.report.utils.StringUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.lang.reflect.InvocationTargetException;
import java.util.*;
import java.util.concurrent.*;

/**
 * Created by fengjunkai on 2018/8/31 0031 上午 11:51
 **/
@Slf4j
@Service
public class CommonQueryService implements CommonSuperService {

    private static Map<String, List<String>> getThirdFieldByServiceAndMethod = new ConcurrentHashMap<>();
    private static Map<String, String> getMappingFieldByThirdField = new ConcurrentHashMap<>();
    private static Map<String,String> getServiceNameByMappingField = new ConcurrentHashMap<>();
    private static Map<String,String> getMethodNameByMappingField = new ConcurrentHashMap<>();
    private static Map<String,List<String>> getLocationMethodByServiceName = new ConcurrentHashMap<>();

    //根据UUID，将接口返回500的转换成400
    private static Map<String, String> getUuiidWhiteListByServiceAndMethod = new ConcurrentHashMap<>();

    private ThreadPoolExecutor TASK_POOL = new ThreadPoolExecutor(50, 1000,
            200L, TimeUnit.MILLISECONDS,
            new SynchronousQueue<>());

    @Autowired
    private IUserCenterService iUserCenterService;

    @Autowired
    private CommonAlarmCmpt commonAlarmCmpt;

    @Autowired
    private DsSpecialUserHandleMapper uuidWhiteListConfigMapper;

    public Object commonQuery(String source_types, String inUuid, String name, String phone, String identity, String backDate, String business_type, String order_id, boolean isReadCache){
        log.info("三方数据源统一查询接口, 入参, inUuid: {} ,sourceType:{}, businessType:{} , orderId:{}, isReadCache: {} ", inUuid, source_types, business_type, order_id, isReadCache);
        Stopwatch stopwatch = Stopwatch.createStarted();
        String transactionId = IdUtils.getUuid();
        Map<String, Object> resultMap = new ConcurrentHashMap<>();
        try {
            if (StringUtils.isAnyBlank(source_types, inUuid) && StringUtils.isBlank(name) && StringUtils.isBlank(phone) && StringUtils.isBlank(identity)) {
                return ImmutableMap.of("transactionId", transactionId, "code", 201, "message", "参数不能为空" + "sourceType:" + source_types);
            }

            CommonParams commonParams = null;
            if(StringUtils.isBlank(inUuid)){
                commonParams = new CommonParams();
                commonParams.setName(name);
                commonParams.setPhoneNo(phone);
                commonParams.setIdNo(identity);
                commonParams.setUuid(UUID.randomUUID().toString());
            } else {
                SdkUser userFullInfoByUuid = iUserCenterService.getUserFullInfoByUuid(inUuid);
                if(userFullInfoByUuid == null){
                    commonAlarmCmpt.alarm("Warn", "用户中心查询不到该用户", "uuid :" + inUuid);
                    return ImmutableMap.of( "code", 500, "message", "查询异常", "data", resultMap);
                }
                commonParams = new CommonParams(userFullInfoByUuid);
            }
            String uuid = commonParams.getUuid();

            if (commonParams == null) {
                return ImmutableMap.of("transactionId", transactionId, "code", 301, "message", "没有查询到当前用户" + "sourceType:" + source_types + ", uuid: " + uuid);
            }
            //modify 2019.10.10 增加md5加密
            if(source_types.startsWith("lhp_hit_by_")){//lhp_hit_by_idNo，lhp_hit_by_phone
                if (StringUtils.isAnyBlank(commonParams.getName(), commonParams.getIdNoMd5(), commonParams.getPhoneNoMd5())) {
                    return ImmutableMap.of("transactionId", transactionId, "code", 301, "message", "没有查询到当前用户信息不全md5" + "sourceType:" + source_types + ", uuid: " + uuid);
                }
            }else{
                if (StringUtils.isAnyBlank(commonParams.getName(), commonParams.getIdNo(), commonParams.getPhoneNo())) {
                    return ImmutableMap.of("transactionId", transactionId, "code", 301, "message", "没有查询到当前用户信息不全" + "sourceType:" + source_types + ", uuid: " + uuid);
                }
                checkUser(transactionId, commonParams);
            }

            Map<String, String> mapping = new ConcurrentHashMap<>();
            List<String> sourceTypes = Arrays.asList(source_types.split(","));
            List<String> errorFeatureKeys = new ArrayList<>();
            sourceTypes.forEach(o->{
                String s = getServiceNameByMappingField.get(o);
                if(StringUtils.isBlank(s)){
                    errorFeatureKeys.add(o);
                }
            });
            if(errorFeatureKeys.size()>0){
                log.info("非法特征调用, transactionId: {} , uuid: {} , sourceKeys: {} ", transactionId, uuid, JSON.toJSONString(errorFeatureKeys));
                return ImmutableMap.of("code", 500, "message", "温馨提示: 非法特征, 请不要随意调用 ^_^", "data", errorFeatureKeys);
            }
            sourceTypes.forEach(o -> {
                mapping.put(getMethodNameByMappingField.get(o), getServiceNameByMappingField.get(o).concat(":").concat(o));  //method  service:locationMethod
            });
            log.info("三方数据源统一查询接口, 数据源数量, uuid: {} , 传入sourceTypes个数：{}, 去重后sourceTypes个数：{}, 去重后结果:{}", uuid, sourceTypes.size(), mapping.size(), mapping);
            CountDownLatch countDownLatch = new CountDownLatch(mapping.size());
            CommonParams params = commonParams;
            mapping.forEach((methodName, serviceName) -> {
                log.info("TASK_POOL ActiveCount : {} , Task Queue size : {} ", TASK_POOL.getActiveCount(), TASK_POOL.getQueue().size());
                TASK_POOL.execute(() -> {
                    try {
                        String serviceNameO1 = serviceName.split(":")[0];
                        String keysO1 = serviceName.split(":")[1];
                        execute(transactionId, serviceNameO1, methodName, resultMap, params, keysO1, backDate, isReadCache);
                    } catch (Exception e) {
                        log.error("三方数据源统一查询接口, 异常, uuid: {} , sourceType:{}, keys:{}", uuid, serviceName.split(":")[0], serviceName.split(":")[1], e);
                        if(StringUtils.equalsAnyIgnoreCase(serviceName.split(":")[0], "xinYanService", "baiRongStrategyService", "anLiangService", "tianChuangService", "bingJianService", "ficoService", "jiGuangService", "zhongChengXinCheckService")){
                            putErrorBody(uuid,resultMap, serviceName.split(":")[0], methodName);
                        }else{
                            putErrorBodyOld(uuid,resultMap, serviceName.split(":")[0]);
                        }
                        commonAlarmCmpt.alarm("Warn", "统一查询接口异常", "异常:" + e.toString()+";transactionId: " +transactionId+" ;inUuid: " + inUuid);
                    } finally {
                        countDownLatch.countDown();
                    }
                });
            });
            countDownLatch.await(60, TimeUnit.SECONDS);
            if (resultMap.size() > 0) {
                putTransactionId(transactionId, resultMap);
                putIsFromCache(resultMap, isReadCache);
                log.info("三方数据源统一查询接口, 查询结果, uuid: {} , sourceType:{}, businessType:{}, orderId:{}, resultMap:{}, userTime:{} , isReadCache: {} ",
                        uuid, mapping, business_type, order_id, StringUtil.shortPrintLog(JSON.toJSONString(resultMap)), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), isReadCache);
                return ImmutableMap.of("code", 200, "message", "查询成功", "data", resultMap);
            } else {
                putTransactionId(transactionId, resultMap);
                putIsFromCache(resultMap, isReadCache);
                    log.warn("三方数据源统一查询接口, 为空 uuid: {} , sourceType:{}, mapping:{}, businessType:{}, orderId:{}, userTime:{} , isReadCache: {} ",
                        uuid, source_types, mapping, business_type, order_id, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), isReadCache);
                return ImmutableMap.of("code", 500, "message", "查询异常", "data", resultMap);
            }
        }catch(Exception e){
            commonAlarmCmpt.alarm("Warn", "统一查询接口异常", "异常:" + e.toString()+";transactionId: " +transactionId+" ;inUuid: " + inUuid);
            putTransactionId(transactionId, resultMap);
            putIsFromCache(resultMap, isReadCache);
            log.error("三方数据源统一查询接口, 异常, inUuid: {} , sourceType:{}, businessType:{}, orderId:{}, userTime:{} , isReadCache: {} ",
                    inUuid, source_types, business_type, order_id, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS), isReadCache, e);
            return ImmutableMap.of( "code", 500, "message", "查询异常", "data", resultMap);
        }
    }

    private void checkUser(String transactionId, CommonParams userFullInfo) {
        if(userFullInfo == null) return;
        if(!CheckUtils.checkIfNameOk(userFullInfo.getName())){
            String name = userFullInfo.getName();
            if(StringUtils.isNotBlank(name)) {
                String result = name.replaceAll("[^\\u4e00-\\u9fa5\\·.]", "");
                if(StringUtils.isNotBlank(result)){
                    log.info("姓名特殊字符处理：transactionId : {}, name : {} , result : {} ", transactionId, name, result);
                    userFullInfo.setName(result);
                }
            }
            commonAlarmCmpt.alarm("Warn", "用户姓名检验失败", JSON.toJSONString(userFullInfo));
        }
        if(!CheckUtils.checkIfPhoneOk(userFullInfo.getPhoneNo())){
            commonAlarmCmpt.alarm("Warn", "用户手机号检验失败", JSON.toJSONString(userFullInfo));
        }
    }


    public GlobalResponse refreshUuidWhite(){
        String msg = locationUuiidWhiteList();
        return GlobalResponse.generate("刷新成功,"+msg);
    }

    public GlobalResponse updateUuidWhite(String type, String params) {
        if (StringUtils.isAnyBlank(type, params)) {
            return new GlobalResponse("1012", "参数错误");
        }
        int count = 0;
        if ("insert".equalsIgnoreCase(type)) {
            DsSpecialUserHandle event = null;
            String[] strArry = params.split("[,]");
            for (String tmp : strArry) {
                //methodName|serviceName|uuid，多个用户可以用逗号分隔
                try {
                    if (StringUtils.isNotBlank(tmp.trim())) {
                        String[] bean = tmp.split("[|]");
                        if (bean.length >= 3) {
                            event = new DsSpecialUserHandle();
                            event.setMethodName(bean[0]);
                            event.setServiceName(bean[1]);
                            event.setUuid(bean[2]);
                            int result = uuidWhiteListConfigMapper.insert(event);
                            count += result;
                            log.info("updateUuidWhite type[" + type + "] 插入结束, result=" + result);
                        }
                    }
                } catch (Exception e) {
                    log.warn("updateUuidWhite type[" + type + "] 插入异常, param=" + tmp, e);
                }
            }
            return GlobalResponse.generate("插入成功,count=" + count);
        } else if ("delete".equalsIgnoreCase(type)) {
            DsSpecialUserHandle record = null;
            String[] strArry = params.split("[,]");
            for (String tmp : strArry) {
                //methodName|serviceName|uuid，多个用户可以用逗号分隔
                if (StringUtils.isNotBlank(tmp.trim())) {
                    String[] bean = tmp.trim().split("[|]");
                    if (bean.length > 0) {
                        record = new DsSpecialUserHandle();
                        record.setMethodName(bean[0]);
                        if (bean.length > 1) {
                            record.setServiceName(StringUtils.isNotBlank(bean[1]) ? bean[1] : null);
                        }
                        if (bean.length > 2) {
                            record.setUuid(StringUtils.isNotBlank(bean[2]) ? bean[2] : null);
                        }
                        int result = uuidWhiteListConfigMapper.updateNotEnableByParams(record);
                        count += result;
                        log.info("updateUuidWhite type[" + type + "] 更新结束, result=" + result);
                    }
                }
            }
            return GlobalResponse.generate("更新成功,count=" + count);
        } else {
            log.warn("updateUuidWhite 参数 type is null.");
            return new GlobalResponse("1012", "参数错误");
        }
    }




    //--------------------------------------------------------------------------------------

    private void execute(String transactionId, String serviceName, String methodName, Map<String,Object> resultMap, CommonParams userFullInfo, String keys, String backDate, boolean isReadCache) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String uuid = userFullInfo.getUuid();
        CommonSuperService superService = ApplicationContextHolder.getBean(serviceName);
        Stopwatch stopwatch = Stopwatch.createStarted();
        if("lhpBlackListService".equalsIgnoreCase(serviceName)){
            convertLhpBlackList(transactionId, resultMap, serviceName, uuid, methodName, keys, userFullInfo, isReadCache);
        } /*else if("zhongHuJinVerificateService".equalsIgnoreCase(serviceName)){

        }*/
        log.info("三方数据源统一查询接口, 查询结束, uuid: {} , serviceName： {} ,methodName ： {} ， time:{}", uuid, serviceName, methodName, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }



    private void put400Body(Map<String,Object> resultMap, String serviceName){
        List<String> fields = getLocationMethodByServiceName.get(serviceName);
        fields.forEach(o1->{
            Map<String,Object> bodyMap = new HashMap<>();
            bodyMap.put("state", 400);
            bodyMap.put("value", 0);
            resultMap.put(o1, bodyMap);
        });
    }

    private void put400Body(Map<String,Object> resultMap, String serviceName, String method){
        List<String> fields = getThirdFieldByServiceAndMethod.get(serviceName+method);
        fields.forEach(o1->{
            Map<String,Object> bodyMap = new HashMap<>();
            bodyMap.put("state", 400);
            bodyMap.put("value", 0);
            resultMap.put(getMappingFieldByThirdField.get(o1), bodyMap);
        });
    }


    public String getXyKeysV2(String key, int flag){
        String keys = key;
        if(0==flag){
            if("loans_org_count".equalsIgnoreCase(key) || "consfin_org_count".equalsIgnoreCase(key) || "loans_credibility".equalsIgnoreCase(key) ||
                    "consfin_org_count".equalsIgnoreCase(key) || "latest_six_month".equalsIgnoreCase(key) || "latest_three_month".equalsIgnoreCase(key)
                    || "latest_one_month".equalsIgnoreCase(key) ||"loans_org_count".equalsIgnoreCase(key) || "loans_credibility".equalsIgnoreCase(key)){
                keys = getMappingFieldByThirdField.get("xyqjldc_"+key+"_new");
            }else{
                keys = getMappingFieldByThirdField.get(key+"_new");
            }
        }else if(1==flag){
            if("consfin_org_count".equalsIgnoreCase(key) || "latest_six_month".equalsIgnoreCase(key) || "latest_three_month".equalsIgnoreCase(key) || "latest_one_month".equalsIgnoreCase(key) ||"loans_org_count".equalsIgnoreCase(key) || "loans_credibility".equalsIgnoreCase(key)){
                return getMappingFieldByThirdField.get("xyqjldb_"+key+"_new");
            }else{
                keys = getMappingFieldByThirdField.get(key+"_new");
            }
        }else if(2==flag){
            if("latest_six_month".equalsIgnoreCase(key) || "latest_three_month".equalsIgnoreCase(key) || "latest_one_month".equalsIgnoreCase(key)){
                return getMappingFieldByThirdField.get("xyqjlda_"+key+"_new");
            }else{
                keys = getMappingFieldByThirdField.get(key+"_new");
            }
        }
        return keys;
    }

    //500 by serviceName, no WhiteList 抛异常时使用
    private void putErrorBodyOld(String uuid,Map<String,Object> resultMap, String serviceName){
        List<String> fields = getLocationMethodByServiceName.get(serviceName);
        fields.forEach(o1->{
            Map<String,Object> bodyMap = new HashMap<>();
            bodyMap.put("state", 500);
            bodyMap.put("value", 0);
            resultMap.put(o1, bodyMap);
        });
    }


    private void putTestErrorBody(Map<String,Object> resultMap, String serviceName){
        List<String> fields = getLocationMethodByServiceName.get(serviceName);
        fields.forEach(o1->{
            Map<String,Object> bodyMap = new HashMap<>();
            bodyMap.put("state", 501);
            bodyMap.put("value", 0);
            resultMap.put(o1, bodyMap);
        });
    }

    //500 by serviceName+methodName
    private void putErrorBody(String uuid,Map<String,Object> resultMap, String serviceName, String methodName){
       List<String> fields = getThirdFieldByServiceAndMethod.get(serviceName + methodName);
        fields.forEach(o1->{
            Map<String,Object> bodyMap = new HashMap<>();
            bodyMap.put("state", 500);
            bodyMap.put("value", 0);
            resultMap.put(getMappingFieldByThirdField.get(o1), bodyMap);
        });
    }

    private void putTestErrorBody(Map<String,Object> resultMap, String serviceName, String methodName){
        List<String> fields = getThirdFieldByServiceAndMethod.get(serviceName + methodName);
        fields.forEach(o1->{
            Map<String,Object> bodyMap = new HashMap<>();
            bodyMap.put("state", 501);
            bodyMap.put("value", 0);
            resultMap.put(getMappingFieldByThirdField.get(o1), bodyMap);
        });
    }

    private void putTransactionId(String transactionId, Map<String,Object> resultMap){
        Map<String, Object> bodyMap = new HashMap<>();
        bodyMap.put("state", 200);
        bodyMap.put("value", transactionId);
        resultMap.put("transactionId", bodyMap);
    }

    private void putIsFromCache(Map<String,Object> resultMap, boolean isReadCache){
        Map<String, Object> bodyMap = new HashMap<>();
        bodyMap.put("state", 200);
        bodyMap.put("value", isReadCache ? true : false);
        resultMap.put("isFromCache", bodyMap);
    }



    @PostConstruct
    public void queryServiceMap(){
        //locationUuiidWhiteList();
    }


    /**
     * 描述: 刷入本地缓存，（根据UUID将接口返回500的转换成400） <br/>
     * 参数: []  <br/>
     * 返回值: void  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.22  <br/>
     */
    private String locationUuiidWhiteList(){
        int listSize = 0;
        try{
            List<DsSpecialUserHandle> uuidWhiteLists = uuidWhiteListConfigMapper.selectAllByEnable();
            if(uuidWhiteLists!=null && uuidWhiteLists.size()>0){
               /* getUuiidWhiteListByServiceAndMethod = uuidWhiteLists.stream().collect(
                        Collectors.groupingBy((o->o.getServiceName()+o.getMethodName()), Collectors.mapping(DsSpecialUserHandle::getUuid, Collectors.toList()))
                );*/
                Map<String, String> tmpMap = new ConcurrentHashMap<>();
                for(DsSpecialUserHandle bean : uuidWhiteLists){
                    tmpMap.put(bean.getUuid()+bean.getServiceName()+bean.getMethodName(),"1");
                }
                getUuiidWhiteListByServiceAndMethod = tmpMap;
                listSize=uuidWhiteLists.size();
            }
            log.info("DsSpecialUserHandle刷入本地缓存end!");
        }catch (Exception e){
            log.error("DsSpecialUserHandle刷入本地缓存error!",e);
        }

        if(getUuiidWhiteListByServiceAndMethod!=null){
            return "keyNum="+getUuiidWhiteListByServiceAndMethod.size()+",valNum="+listSize;
        }else{
            return "keyNum=0,valNum="+listSize;
        }
    }



    private void convertLhpBlackList(String transactionId, Map<String, Object> resultMap, String serviceName, String uuid, String methodName, String keys, CommonParams userFullInfo, boolean isReadCache)  throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        CommonSuperService superService = ApplicationContextHolder.getBean(serviceName);
        Object resultObject = superService.getClass().getMethod(methodName, String.class, String.class, String.class, String.class, String.class)
                .invoke(superService, transactionId, userFullInfo.getIdNoMd5(), userFullInfo.getPhoneNoMd5(), userFullInfo.getName(), uuid);
        GlobalResponse globalResponse = (GlobalResponse) resultObject;
        Object object = globalResponse.getBody();
        boolean flag = globalResponse.getTransactionResult().stream().filter(o -> (o != null) && TransactionCodeEnum.Fail.equals(o.getTansactionCode())).count() > 0;

        if(object!=null){
            Map<String,String> jsonObject = (Map<String,String>)object;

            Map<String,Object> bodyMap1 = new HashMap<>();
            bodyMap1.put("state", jsonObject.get("by_idNo")!=null ? 200:400);
            bodyMap1.put("value", jsonObject.get("by_idNo"));
            resultMap.put("lhp_hit_by_idNo", bodyMap1);

            Map<String,Object> bodyMap2 = new HashMap<>();
            bodyMap2.put("state", jsonObject.get("by_phone")!=null ? 200:400);
            bodyMap2.put("value", jsonObject.get("by_phone"));
            resultMap.put("lhp_hit_by_phone", bodyMap2);

        }else{
            if (flag && !isReadCache) {
                putErrorBodyOld(uuid,resultMap, serviceName);
            }else if(flag && isReadCache){
                putTestErrorBody(resultMap, serviceName);
            } else{
                put400Body(resultMap, serviceName);
            }
        }

    }


}