package cn.quantgroup.report.config.filter;

import cn.quantgroup.report.fastjson.CustomValueFilter;
import com.google.common.collect.Sets;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ValueFilterConfig {
  @Bean("qianHaiMaskedValueFilter")
  public CustomValueFilter qianHaiMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("idNo", "idType", "name"));
  }

  @Bean("jdMaskedValueFilter")
  public CustomValueFilter jdMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("mobile", "c_mobile", "address", "cust_id"));
  }

  @Bean("creditXMaskedValueFilter")
  public CustomValueFilter creditXMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("id", "user_name", "mobile_number", "identity_number"));
  }

  @Bean("baiRongMaskedValueFilter")
  public CustomValueFilter baiRongMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("id", "name", "cell", "bank_id"));
  }

  @Bean("shuMeiMaskedValueFilter")
  public CustomValueFilter shuMeiMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("phone", "imei", "idfa", "name", "prcid", "cardid"));
  }

  @Bean("tongDunMaskedValueFilter")
  public CustomValueFilter tongDunMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("account_name", "id_number", "account_mobile"));
  }

  @Bean("zhiMaMaskedValueFilter")
  public CustomValueFilter zhiMaMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("address", "bankCard", "certNo", "bank_card", "cert_no", "mobile"));
  }

  @Bean("qCloudMaskedValueFilter")
  public CustomValueFilter qCloudMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("idNumber", "phoneNumber", "name","uid","userIp"));
  }

  @Bean("zhengXin91MaskedValueFilter")
  public CustomValueFilter zhengXin91MaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("realName", "idCard"));
  }

  @Bean("haoAnMaskedValueFilter")
  public CustomValueFilter haoAnMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name", "id", "appkey", "phone"));
  }

  @Bean("baiDuMaskedValueFilter")
  public CustomValueFilter baiDuMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name", "identity", "appkey", "phone", "sp_no"));
  }

  @Bean("intelliCreditMaskedValueFilter")
  public CustomValueFilter intelliCreditMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name", "pid", "mobile"));
  }
  @Bean("baiQiShiMaskedValueFilter")
  public CustomValueFilter baiQiShiMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name", "identity","phone","verifyKey","partnerId"));
  }
  @Bean("dianHuaBangMaskedValueFilter")
  public CustomValueFilter dianHuaBangMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("phone"));
  }
  @Bean("rong360MaskedValueFilter")
  public CustomValueFilter rong360MaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("orderNo"));
  }

  @Bean("unionPayMaskedValueFilter")
  public CustomValueFilter unionPayMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("bankCardNo","name","identityNo","phone"));
  }

  @Bean("chengAnMaskedValueFilter")
  public CustomValueFilter chengAnMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name","idCard","mobiel"));
  }
  @Bean("shengDunMaskedValueFilter")
  public CustomValueFilter shengDunMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name","identityNumber","phone"));
  }
  @Bean("xinYanMaskedValueFilter")
  public CustomValueFilter xinYanMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name","identity","phone","bankCard"));
  }

  @Bean("elevenBeiMaskedValueFilter")
  public CustomValueFilter elevenBeiMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("identity"));
  }

  @Bean("tianXingHuiMaskedValueFilter")
  public CustomValueFilter tianXingHuiMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name","identity","phone"));
  }
  @Bean("zhongChengXinMaskedValueFilter")
  public CustomValueFilter zhongChengXinMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name","identityNumber"));
  }
  @Bean("jiGuangMaskedValueFilter")
  public CustomValueFilter jiGuangMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name","id_number","phone"));
  }
  @Bean("kaNiuMaskedValueFilter")
  public CustomValueFilter kaNiuMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name"));
  }

  @Bean("shuChuangMaskedValueFilter")
  public CustomValueFilter shuChuangMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("mobile"));
  }

  @Bean("faHaiMaskedValueFilter")
  public CustomValueFilter faHaiMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name", "idCard"));
  }

  @Bean("tianChuangMaskedValueFilter")
  public CustomValueFilter tianChuangMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name", "identity", "phone"));
  }

  @Bean("tanZhiMaskedValueFilter")
  public CustomValueFilter tanZhiMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name", "identity", "phone"));
  }

  @Bean("jiAoMaskedValueFilter")
  public CustomValueFilter jiAoMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name", "idCard"));
  }

  @Bean("bingJianMaskedValueFilter")
  public CustomValueFilter bingJianMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name", "id", "phone", "bankCard"));
  }

  @Bean("anLiangMaskedValueFilter")
  public CustomValueFilter anLiangMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name", "idCard", "mobile", "bankCard"));
  }

  @Bean("zhiShuMaskedValueFilter")
  public CustomValueFilter zhiShuMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("name", "idCard", "mobile"));
  }

  @Bean("ficoMaskedValueFilter")
  public CustomValueFilter ficoMaskedValueFilter() {
    return new CustomValueFilter(Sets.newHashSet("mobile", "idCard"));
  }
}