package cn.quantgroup.report.controller;

import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.common.CommonQueryService;
import cn.quantgroup.report.service.manualTool.CleanningTransactionLogService;
import cn.quantgroup.report.service.manualTool.ManualToolService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping(value = "/manualtool")
public class ManualToolController {

  @Autowired
  private ManualToolService manualToolService;

  @Autowired
  private CommonQueryService queryService;

  @Autowired
  private CleanningTransactionLogService cleanningTransactionLogService;

 /* @Autowired
  private RedisTemplate redisTemplate;*/

  /*@RequestMapping("/clear_huadao_token")
  public GlobalResponse clearHuadaoToken(){
    try{
      redisTemplate.delete("NEW_HUADAO_QUERY_TOKEN_KEY");
      log.info("清除华道缓存token成功");
      return GlobalResponse.generate("清除华道缓存token成功");
    }catch(Exception e){
      log.info("清除华道缓存token异常");
      return GlobalResponse.generate("清除华道缓存token异常");
    }
  }*/


  @RequestMapping("/send/baihang")
  public GlobalResponse sendBaihang(String p1,String p2,String p3,String p4,String p5,String secretKey, String isSend,String errorCode, String isProduct, String sendIncludeType) {
    try{
      return manualToolService.sendBaiHangData(p1,p2,p3,p4,p5,secretKey,isSend,errorCode, isProduct, sendIncludeType);
    }catch (Exception e){
      log.error("百行征信手动报送异常, {} , {} ", e.getMessage(), e);
      return GlobalResponse.generate(e.getMessage());
    }
  }


  /**
   * 描述: 放款信息 D2 <br/>
   * 参数: [jsonFile]  <br/>
   * 返回值: GlobalResponse  <br/>
   * 创建人: yanhui.Hao  <br/>
   * 创建时间: 2019.09.27  <br/>
   */
  @RequestMapping("/build/d2")
  public GlobalResponse buildLoanInfoD2(String jsonFile) {
    try{
      return manualToolService.buildLoanInfoD2(jsonFile);
    }catch (Exception e){
      log.error("百行征信手动报送异常, {} , {} ", e.getMessage(), e);
      return GlobalResponse.generate(e.getMessage());
    }
  }


  /**
   * 描述: 手动刷新getUuiidWhiteListByServiceAndMethod <br/>
   * 参数: [p3, secretKey]  <br/>
   * 返回值: void  <br/>
   * 创建人: yanhui.Hao  <br/>
   * 创建时间: 2019.10.22  <br/>
   */
  @RequestMapping("/refreshUuidWhite")
  public GlobalResponse refreshUuidWhite(String p3,String secretKey){
    if(manualToolService.checkSecretKey(p3,secretKey)){
      return queryService.refreshUuidWhite();
    }else{
      log.info("refreshUuidWhite checkSecretKey fail.");
      return new GlobalResponse("1012", "参数错误");
    }
  }

  /**
   * 描述: 插入库，或修改库 <br/>
   * 参数: [p3, secretKey, type, params]
   * type, 可传insert或delete <br/>
   * params, 是methodName|serviceName|uuid，多个用户可以用逗号分隔  <br/>
   * 返回值: void  <br/>
   * 创建人: yanhui.Hao  <br/>
   * 创建时间: 2019.10.22  <br/>
   */
  @RequestMapping("/updateUuidWhite")
  public GlobalResponse updateUuidWhite(String p3,String secretKey, String type, String params){
    if(manualToolService.checkSecretKey(p3,secretKey)){
      return queryService.updateUuidWhite(type,params);
    }else{
      log.info("updateUuidWhite checkSecretKey fail.");
      return new GlobalResponse("1012", "参数错误");
    }
  }


  @RequestMapping("/testQueryDb")
  public GlobalResponse testQueryDb(String p3,String secretKey){
    if(manualToolService.checkSecretKey(p3,secretKey)){
      return queryService.testQueryDb();
    }else{
      log.info("testQueryDb checkSecretKey fail.");
      return new GlobalResponse("1012", "参数错误");
    }
  }

  @RequestMapping("/dealWithExcelData")
  public GlobalResponse dealWithExcelData(String filePath,String type){
    return manualToolService.dealWithExcelData(filePath,type);
  }


  @RequestMapping("/removeD3LoanIdChunfu")
  public String remove_D3_loanId_chunfu(String oldDataFile, String cfLoanIdLogFile, String newFileName, String rmIdFileName,String rmPhoneFileName){
    return manualToolService.remove_D3_loanId_chunfu(oldDataFile,cfLoanIdLogFile,newFileName,rmIdFileName,rmPhoneFileName);
  }
  @RequestMapping("/checkD3loanIdInD2")
  public String check_D3loanId_InD2(String d3LoanIdFile, String d2File, String inFileName, String notInFileName){
    return manualToolService.check_D3loanId_InD2(d3LoanIdFile,d2File,inFileName,notInFileName);
  }
  @RequestMapping("/checkD2loanIdInD3WanJie")
  public String check_D2loanId_InD3WanJie(String d3LoanIdFile, String d2File, String notWJFileName){
    return manualToolService.check_D2loanId_InD3WanJie(d3LoanIdFile,d2File,notWJFileName);
  }

  @RequestMapping("/newD3ReplaceReqId")
  public String newD3ReplaceReqId(String newD3FilePath, String newD3FileNames, String oldD3ReqIdFile, String mapNotEmptyFile){
     manualToolService.newD3ReplaceReqId(newD3FilePath,newD3FileNames,oldD3ReqIdFile,mapNotEmptyFile);
    return "调用结束";
  }

  @RequestMapping("/d2_saveLog")
  public String d2_saveLog(String d2JsonFileName,String reqIdFileName,String no_reqId_start, String isHaveRecordId){
    manualToolService.d2_saveLog(d2JsonFileName,reqIdFileName,no_reqId_start,isHaveRecordId);
    return "d2_saveLog调用结束";
  }

    @RequestMapping("/d3_saveLog")
    public String d3_saveLog(String d3FilePath, String d3JsonFileNames, String reqIdLogName, String no_reqId_start, String isHaveRecordId){
        manualToolService.d3_saveLog(d3FilePath,d3JsonFileNames,reqIdLogName,no_reqId_start,isHaveRecordId);
        return "d3_saveLog调用结束";
    }


  @RequestMapping("/synCallRecordNew")
  public String synCallRecordNew(String newYnrTime,String isExecuteOnce){
    cleanningTransactionLogService.synCallRecordNew(newYnrTime,isExecuteOnce);
    return "synCallRecordNew调度完成";
  }

  @RequestMapping("/checkCallRecordCF")
  public String checkCallRecordCF(String newYnrTime,String isExecuteOnce){
    cleanningTransactionLogService.checkCallRecordCF(newYnrTime,isExecuteOnce);
    return "checkCallRecordCF调度完成";
  }
  @RequestMapping("/checkTransactionLogCF")
  public String checkTransactionLogCF(String newYnrTime,String isExecuteOnce){
    cleanningTransactionLogService.checkTransactionLogCF(newYnrTime,isExecuteOnce);
    return "checkTransactionLogCF调度完成";
  }

  @RequestMapping("/checkCallRecordCFByTransactionLog")
  public String checkCallRecordCFByTransactionLog(String newYnrTime,String isExecuteOnce){
    cleanningTransactionLogService.checkCallRecordCFByTransactionLog(newYnrTime,isExecuteOnce);
    return "checkCallRecordCFByTransactionLog调度完成";
  }

  @RequestMapping("/checkCallRecordCFByTransactionLog2")
  public String checkCallRecordCFByTransactionLog2(String newYnrTime,String isExecuteOnce){
    cleanningTransactionLogService.checkCallRecordCFByTransactionLog2(newYnrTime,isExecuteOnce);
    return "checkCallRecordCFByTransactionLog2调度完成";
  }

  @RequestMapping("/deleteTidbCallRecordCF")
  public String deleteTidbCallRecordCF(String cfFileName, String bakFileName){
    cleanningTransactionLogService.deleteTidbCallRecordCF(cfFileName,bakFileName);
    return "deleteTidbCallRecordCF调度完成";
  }

}
