package cn.quantgroup.report.response;

import cn.quantgroup.report.error.QGException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;

/**
 * Created by yanminmin on 2017/3/24.
 */
@ControllerAdvice({"cn.quantgroup.report"})
@Slf4j
public class GlobalControllerHandler {
  // 定义全局异常处理，value属性可以过滤拦截条件，此处拦截所有的Exception
  @ExceptionHandler(value = Exception.class)
  @ResponseBody
  public GlobalResponse exception(Exception ex, WebRequest request) {
    return new GlobalResponse(QGException.wrap(ex));
  }
}
