package cn.quantgroup.report.controller.external;

import cn.quantgroup.report.service.baihang.BaiHangQueryService;
import cn.quantgroup.report.service.common.CommonQueryService;
import cn.quantgroup.report.utils.IdUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * Created by fengjunkai on 2018/8/13 0013 下午 4:48
 **/
@Slf4j
@RestController
@RequestMapping(value = "/ex/common", method = RequestMethod.POST)
public class CommonSourceController {

    @Autowired
    private CommonQueryService queryService;

    @Autowired
    private BaiHangQueryService baiHangQueryService;

    @RequestMapping("/query")
    public Object commonQuery(String source_types, String uuid, String name, String phone, String identity, String backDate, String business_type, String order_id, boolean isReadCache){
        Object object = queryService.commonQuery(source_types, uuid, name, phone, identity, backDate, business_type, order_id, isReadCache);
        return object;
    }


    /**
     * -----------------------------------------------------------------------------<br>
     * 描  述: 百行个人征信报告查询 <br>
     * 创建人: yanhui.Hao <br>
     * 创建时间: 2020.05.13 16:53 <br>
     * 最后修改人:  <br>
     * 最后修改时间: 2020.05.13 16:53 <br>
     * 入参说明: [transactionId, uuid, identity, phone, name, queryReason, loanId] <br>
     * 出参说明: java.lang.String <br>
     * -----------------------------------------------------------------------------
     */
    @RequestMapping("/zxlmbh/persionCreditReport")
    public String persionCreditReport(String key, String transactionId, String uuid, String identity, String phone, String name, String queryReason, String loanId) {
        Map<String, Object> resultMap = null;
        if(StringUtils.isEmpty(key) || !"b5140fb2-2c85-4b5a-abcf-3e97528014db".equals(key)){
            resultMap = ImmutableMap.of("code", "301", "msg", "权限参数不能为空！");
        }

        if (StringUtils.isAnyBlank(identity, name, queryReason)) {
            resultMap = ImmutableMap.of("code", "301", "msg", "业务参数不能为空！");
        }else{
            if (StringUtils.isEmpty(transactionId)) {
                transactionId = IdUtils.getUuid();
            }
            resultMap = baiHangQueryService.queryBaiHangQ1OfZxlm(transactionId, uuid, identity, phone, name, queryReason, loanId);
        }

        return JSON.toJSONString(resultMap);
    }



}
