package cn.quantgroup.report.service.baihang;

import cn.quantgroup.report.domain.baihang.*;
import cn.quantgroup.report.domain.sdk.SdkUser;
import cn.quantgroup.report.enums.RequestUrlType;
import cn.quantgroup.report.mapper.baihang.ApplyLoanInfoMapper;
import cn.quantgroup.report.mapper.baihang.LoanInfoMapper;
import cn.quantgroup.report.mapper.baihang.RepaymentLoanInfoMapper;
import cn.quantgroup.report.mapper.master.ApplyLoanInfoDbMapper;
import cn.quantgroup.report.service.baihang.client.BhFileCreditApiClient;
import cn.quantgroup.report.service.baihang.client.BhInterfaceCreditApiClient;
import cn.quantgroup.report.service.baihang.request.FileUploadRequest;
import cn.quantgroup.report.service.baihang.request.InterfaceUploadValidationRequest;
import cn.quantgroup.report.service.baihang.response.FileUploadResponse;
import cn.quantgroup.report.service.baihang.response.FileUploadValidationResponse;
import cn.quantgroup.report.service.baihang.response.InterfaceUploadResponse;
import cn.quantgroup.report.service.baihang.response.InterfaceUploadValidationResponse;
import cn.quantgroup.report.service.baihang.util.BHRSAUtils;
import cn.quantgroup.report.service.http.IHttpService;
import cn.quantgroup.report.service.thirdpartymonitor.ThirdpartyApiMonitorService;
import cn.quantgroup.report.service.usersdk.IUserCenterService;
import cn.quantgroup.report.mapper.master.LoanInfoDbMapper;
import cn.quantgroup.report.mapper.master.RepaymentLoanInfoDbMapper;
import cn.quantgroup.report.service.baihang.request.FileUploadValidationRequest;
import cn.quantgroup.report.service.baihang.request.InterfaceUploadRequest;
import cn.quantgroup.report.service.baihang.util.Base64;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@Service
public class BaiHangService {

    private static final Logger log = LoggerFactory.getLogger(BaiHangService.class);

    //    private static String ERLY_DATE = "2017-10-20T00:00:00";
    private static String ERLY_DATE = "2019-05-07T00:00:00";
    //    private static String ERLY_DATE = "2017-10-22T00:00:00";
    private static String END_DATE = "2019-05-29T00:00:00";
//    private static String END_DATE = "2017-10-29T00:00:00";

    @Autowired
    public ApplyLoanInfoMapper applyLoanInfoMapper;
    @Autowired
    public LoanInfoMapper loanInfoMapper;
    @Autowired
    public RepaymentLoanInfoMapper repaymentLoanInfoMapper;
    @Autowired
    public ApplyLoanInfoDbMapper applyLoanInfoDbMapper;
    @Autowired
    public LoanInfoDbMapper loanInfoDbMapper;
    @Autowired
    public RepaymentLoanInfoDbMapper repaymentLoanInfoDbMapper;
    @Autowired
    private ThirdpartyApiMonitorService thirdpartyApiMonitorService;

    @Autowired
    private IUserCenterService iUserCenterService;

    @Autowired
    public IHttpService iHttpService;

    @Value("${baihang.zhudai.D2.data.url}")
    public String baihangHandD2DataUrl;
    @Value("${baihang.zhudai.D3.data.url}")
    public String baihangHandD3DataUrl;

    @Value("${baihang.zhudai.applyloan.url}")
    public String baiHangApplyLoanInfoUrl;
    @Value("${baihang.zhudai.loaninfo.url}")
    public String baiHangLoanInfoUrl;
    @Value("${baihang.zhudai.repaymentloaninfo.url}")
    public String baiHangRepayMentLoanInfoUrl;
    @Value("${baihang.zhudai.account.name}")
    public String account;
    @Value("${baihang.zhudai.password}")
    public String password;

    /**
     * 实时报送用户贷款申请数据
     *  //Scheduled 贷款申请（百行征信报送）
     */
    public void sendApplyLoanInfoReportToBaiHang() {
        Stopwatch queryWatch = Stopwatch.createStarted();
        List<ApplyLoanInfo> applyLoanInfos = applyLoanInfoMapper.findApplyLoanInfo();
        log.info("广达小贷TO百行征信报送非循环贷贷款申请查询完成, 耗时: {} ", queryWatch.stop().elapsed(TimeUnit.MILLISECONDS));
        Stopwatch sendWatch = Stopwatch.createStarted();
        AtomicInteger atomicInteger = new AtomicInteger();
        for (int i = 0; i < applyLoanInfos.size(); i++) {
            try {
                ApplyLoanInfo applyLoanInfo = applyLoanInfos.get(i);
                applyLoanInfo.setName(interfaceUploadClient(applyLoanInfo.getName()));
                applyLoanInfo.setMobile(interfaceUploadClient(applyLoanInfo.getMobile()));
                applyLoanInfo.setPid(interfaceUploadClient(applyLoanInfo.getPid()));
                String resultStr = iHttpService.postBaiHang(baiHangApplyLoanInfoUrl, getHeader(), JSON.toJSONString(applyLoanInfo));
                if (Objects.isNull(resultStr) || !(resultStr.contains("queryHistory") && resultStr.contains("nonRevolvingLoan") && resultStr.contains("revolvingLoan"))) {
                    log.info("广达小贷TO百行征信报送贷款申请返回结果不正确, loanId: {} ", applyLoanInfo.getLoanId());
                } else {
                    atomicInteger.getAndIncrement();
                }
            } catch (Exception e) {
                log.error("广达小贷TO百行征信报送贷款申请信息异常", e);
            }
        }
        log.info("广达小贷TO百行征贷款申请报送完成, 实际大小: {} , 报送成功大小: {} , 耗时: {} ", applyLoanInfos.size(), atomicInteger.get(), sendWatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }

    /**
     * 重新报送实时放款数据
     * Scheduled 实时放款数据（百行征信报送）
     */
    public void sendLoaInfoReportToBaiHang() {
        AtomicInteger atomicInteger = new AtomicInteger();
        List<LoanInfo> loanInfos = new ArrayList<>();
        Stopwatch sendWatch = Stopwatch.createStarted();
        try{
            Stopwatch queryWatch = Stopwatch.createStarted();
            loanInfos = loanInfoMapper.findLoanInfo();
            log.info("广达小贷TO百行放款申请报送开始, 大小: {} , 耗时: {} ", loanInfos.size(), queryWatch.stop().elapsed(TimeUnit.MILLISECONDS));

            for (int i = 0; i < loanInfos.size(); i++) {
                LoanInfo loanInfo = loanInfos.get(i);
                String id = "";
                try {
                    String loanInfoReqId = loanInfo.getReqID();
                    if (loanInfo.getTotalTerm() > 1) {
                        List<String> targetRepaymentDayList = loanInfoMapper.findTargetRepaymentDayList(loanInfoReqId);
                        loanInfo.setTargetRepayDateList(String.join(",", targetRepaymentDayList));
                    }
                    UUID loanInfoId = UUID.randomUUID();
                    id = loanInfoId.toString().replaceAll("-", "");
                    loanInfo.setRecordId(id);
                    try{
                        loanInfoDbMapper.saveLoanInfoRecordLog(loanInfo);
                    }catch(Exception e){}
                    loanInfo.setRecordId(null);
                    loanInfo.setReqID(id);
                    loanInfo.setName(interfaceUploadClient(loanInfo.getName()));
                    loanInfo.setPid(interfaceUploadClient(loanInfo.getPid()));
                    loanInfo.setMobile(interfaceUploadClient(loanInfo.getMobile()));
                    String resultStr = iHttpService.postBaiHang(baiHangLoanInfoUrl, getHeader(), JSON.toJSONString(loanInfo));
                    log.info("放款用户报送结果, param: {} , resultStr: {} ", JSON.toJSONString(loanInfo), resultStr);
                    if (Objects.isNull(resultStr) || !"success".equalsIgnoreCase(JSON.parseObject(resultStr).getString("status"))) {
                        log.info("广达小贷TO百行征信报送放款返回结果不正确, recordId: {} , loanId: {} , bean: {} ", id, loanInfo.getLoanId(), JSON.toJSONString(loanInfo));
                        loanInfoDbMapper.updateCurrentRecordEnableFalce(BaiHangUpDateRecord.builder().enable("0").recordId(id).build());
                    } else {
                        atomicInteger.getAndIncrement();
                    }
                } catch (Exception e) {
                    log.error("广达小贷TO百行征信报送放款信息异常, recordId: {} , loanId: {} ", id, loanInfo.getLoanId(), e);
                }
            }
        }catch(Exception e){
            log.error("广达小贷放款报送异常", e);
        }
        log.info("广达小贷TO百行征信报送放款申请完成, 实际大小: {} , 报送成功大小: {} , 耗时: {} ", loanInfos.size(), atomicInteger.get(), sendWatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }

    /**
     *Scheduled 实时还款&实时逾期还款（百行征信报送）
     */
    public void sendRepaymentReportToBaiHang() {

        String startTime = LocalDateTime.now().plusDays(-1).format(DateTimeFormatter.ISO_DATE);
        String endTime = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE);

        for (int j = 0; j < 2; j++) {

            Stopwatch sendWatch = Stopwatch.createStarted();

            try {
                List<RepaymentLoanInfo> repaymentLoanInfos = null;
                if (j == 0) {
                    Stopwatch realTimeStopWatch = Stopwatch.createStarted();
                    repaymentLoanInfos = repaymentLoanInfoMapper.findRepayMentLoanInfo(BaiHangTimeRecord.builder().startTime(startTime).endTime(endTime).build());
                    log.info("广达小贷TO百行征信报送实时还款, startTime: {} , endTime: {} , 大小: {} , 耗时: {} ", startTime, endTime, repaymentLoanInfos.size(), realTimeStopWatch.stop().elapsed(TimeUnit.MILLISECONDS));
                } else {
                    Stopwatch realTimeOverdueStopWatch = Stopwatch.createStarted();
                    repaymentLoanInfos = repaymentLoanInfoMapper.findRepayMentLoanInfoOverdue(BaiHangTimeRecord.builder().startTime(startTime).endTime(endTime).build());
                    log.info("广达小贷TO百行征信报送实时还款逾期, startTime: {} , endTime: {} , 大小: {} , 耗时: {} ", startTime, endTime, repaymentLoanInfos.size(), realTimeOverdueStopWatch.stop().elapsed(TimeUnit.MILLISECONDS));
                }

                AtomicInteger atomicInteger = new AtomicInteger();

                for (int i = 0; i < repaymentLoanInfos.size(); i++) {
                    RepaymentLoanInfo repaymentLoanInfo = repaymentLoanInfos.get(i);
                    String id = "";
                    try {
                        RepaymentLoanInfo repaymentLoanInfo1 = repaymentLoanInfoDbMapper.findLastOne(BaiHangRepayment.builder().loanId(repaymentLoanInfo.getLoanId()).termNo(repaymentLoanInfo.getTermNo()).build());
                        if (j > 0 && Objects.nonNull(repaymentLoanInfo1)) {
                            log.info("广达小贷TO百行征信报送实时还款逾期跳过报送, startTime: {} , endTime: {} , bean: {} ", startTime, endTime, JSON.toJSONString(repaymentLoanInfo1));
                            continue;
                        }

                        id = UUID.randomUUID().toString().replaceAll("-", "");
                        repaymentLoanInfo.setRecordId(id);
                        try {
                            repaymentLoanInfoDbMapper.saveRepaymentLoanInfoLog(repaymentLoanInfo);
                        } catch (Exception e) {
                        }
                        repaymentLoanInfo.setPid(interfaceUploadClient(repaymentLoanInfo.getPid()));
                        repaymentLoanInfo.setName(interfaceUploadClient(repaymentLoanInfo.getName()));
                        repaymentLoanInfo.setMobile(interfaceUploadClient(repaymentLoanInfo.getMobile()));
                        repaymentLoanInfo.setReqID(id);
                        repaymentLoanInfo.setRecordId(null);
                        String resultStr = iHttpService.postBaiHang(baiHangRepayMentLoanInfoUrl, getHeader(), JSON.toJSONString(repaymentLoanInfo));
                        log.info("还款用户报送结果, param: {} , resultStr: {} ", JSON.toJSONString(repaymentLoanInfo), resultStr);
                        if (Objects.isNull(resultStr) || !"success".equalsIgnoreCase(JSON.parseObject(resultStr).getString("status"))) {
                            log.info("广达小贷TO百行征信报送还款返回结果不正确, 开始时间: {} , 结束时间: {} , recordId: {} , loanId: {} , bean: {} ", startTime, endTime, id, repaymentLoanInfo.getLoanId(), JSON.toJSONString(repaymentLoanInfo));
                            repaymentLoanInfoDbMapper.updateCurrentRecordEnableFalse(BaiHangUpDateRecord.builder().enable("0").recordId(id).build());
                        } else {
                            atomicInteger.getAndIncrement();
                        }
                    } catch (Exception e) {
                        log.error("广达小贷TO百行征信报送还款信息异常, recordId: {} , loanId: {} ", id, repaymentLoanInfo.getLoanId(), e);
                    }
                }
                log.info("广达小贷TO百行征信报送还款申请完成 J: {} , 开始时间: {} , 结束时间: {} , 实际大小: {} , 报送成功大小: {} , 耗时: {} ", j, startTime, endTime, repaymentLoanInfos.size(), atomicInteger.get(), sendWatch.stop().elapsed(TimeUnit.MILLISECONDS));
            } catch (Exception e) {
                log.error("广达小贷TO百行征信还款报送异常 J: {} , 开始时间: {} , 结束时间: {} ", j, startTime, endTime, e);
            }
        }

    }

    /**
     * 重新报送实时还款数据 (手动报送D2)
     * @throws Exception
     */
    public void sendHandLoaInfoReportToBaiHang() throws Exception {

        List<String> handLoanInfos = FileUtils.readLines(new File(baihangHandD2DataUrl), "utf-8");
        log.info("百行征信报送放款数据, {}", JSON.toJSONString(handLoanInfos));
        for(int i=0;i<handLoanInfos.size();i++){

            LoanInfo loanInfo = new Gson().fromJson(handLoanInfos.get(i), new TypeToken<LoanInfo>(){}.getType());
            log.info("百行征信报送放款数据单个数据, {}", JSON.toJSONString(loanInfo));
            String loanInfoReqId = loanInfo.getReqID();

            if(loanInfo.getTotalTerm() > 1){
                List<String> targetRepaymentDayList = loanInfoMapper.findTargetRepaymentDayList(loanInfoReqId);
                loanInfo.setTargetRepayDateList(String.join(",", targetRepaymentDayList));
            }
            try{
                loanInfoDbMapper.saveLoanInfoRecordLog(loanInfo);
            }catch(Exception e){}
            loanInfo.setMobile(interfaceUploadClient(loanInfo.getMobile()));
            loanInfo.setName(interfaceUploadClient(loanInfo.getName()));
            loanInfo.setPid(interfaceUploadClient(loanInfo.getPid()));
            String resultStr = iHttpService.postBaiHang(baiHangLoanInfoUrl, getHeader(), JSON.toJSONString(loanInfo));
            log.info("广达小贷TO百行征信报送放款记录(手动) loanId: {} , bean: {} , result: {} ", loanInfo.getLoanId(), JSON.toJSONString(loanInfo), resultStr);
//            log.info("广达小贷TO百行征信报送放款记录(手动) loanId: {} , bean: {} , result: {} ", loanInfo.getLoanId(), JSON.toJSONString(loanInfo), "");

        }
    }

    /**
     * 手动报送实时还款数据 (手动报送D3)
     */
    public void sendHandRepaymentReportToBaiHang1() {

        try {
            List<String> repaymentLoanInfos = FileUtils.readLines(new File(baihangHandD3DataUrl), "utf-8");
            log.info("百行征信报送还款数据, {}", JSON.toJSONString(repaymentLoanInfos));
            for(int i=0;i<repaymentLoanInfos.size();i++){
                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(repaymentLoanInfos.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
                log.info("百行征信报送还款数据单个数据, {}", JSON.toJSONString(repaymentLoanInfo));
                try {
                    repaymentLoanInfoDbMapper.saveRepaymentLoanInfoLog(repaymentLoanInfo);
                } catch (Exception e) {
                }
                repaymentLoanInfo.setPid(interfaceUploadClient(repaymentLoanInfo.getPid()));
                repaymentLoanInfo.setName(interfaceUploadClient(repaymentLoanInfo.getName()));
                repaymentLoanInfo.setMobile(interfaceUploadClient(repaymentLoanInfo.getMobile()));
                repaymentLoanInfo.setReqID(repaymentLoanInfo.getRecordId());
                repaymentLoanInfo.setRecordId(null);
                String resultStr = iHttpService.postBaiHang(baiHangRepayMentLoanInfoUrl, getHeader(), JSON.toJSONString(repaymentLoanInfo));
                log.info("百行征信手动报送还款记录 json: {} , result: {} ", JSON.toJSONString(repaymentLoanInfo), resultStr);
//                log.info("百行征信手动报送还款记录 json: {} , result: {} ", JSON.toJSONString(repaymentLoanInfo), "");
            }
        } catch (Exception e) {
            log.error("百行征信手动报送还款异常", e);
        }

    }


    /**
     * http 存量数据整理(主要是)
     * 申请
     */
    public void stockApplyLoanInfo() {
        List<ApplyLoanInfo> applyLoanInfos = applyLoanInfoMapper.findStockApplyLoanInfo();
        String upladTs = LocalDateTime.now().toString().substring(0, 19);
        for (int i = 0; i < applyLoanInfos.size(); i++) {
            try {
                ApplyLoanInfo applyLoanInfo = applyLoanInfos.get(i);
                applyLoanInfo.setUploadTs(upladTs);
                applyLoanInfo.setReqID(UUID.randomUUID().toString().replaceAll("-", ""));

//                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190508/baihang_source_c1.txt"), JSON.toJSONString(applyLoanInfo)+"\r\n", true);
                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190529/xinjiangguangda_C1_2019052910580303_0001.txt"), JSON.toJSONString(applyLoanInfo) + "\r\n", true);
                System.out.println("第" + i + "个");
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    //http 存量放款数据报送
    public void stockLoanInfo() {
        List<LoanInfo> loanInfos = loanInfoMapper.stockLoanInfo();
        for (int i = 0; i < loanInfos.size(); i++) {
            LoanInfo loanInfo = loanInfos.get(i);
            String id = "";
            try {
                String loanInfoReqId = loanInfo.getReqID();
                if (loanInfo.getTotalTerm() > 1) {
                    List<String> targetRepaymentDayList = loanInfoMapper.findTargetRepaymentDayList(loanInfoReqId);
                    loanInfo.setTargetRepayDateList(String.join(",", targetRepaymentDayList));
                }
                loanInfo.setReqID(UUID.randomUUID().toString().replaceAll("-", ""));
//                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190508/baihang_source_d2.txt"), JSON.toJSONString(loanInfo)+"\r\n", true);
//                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190529/xinjiangguangda_D2_2019052910580303_0001.txt"), JSON.toJSONString(loanInfo) + "\r\n", true);
                FileUtils.write(new File("/Users/fengjunkai/Documents/百行征信数据报送20190702/xinjiangguangda_D2_20190702113409_0001.txt"), JSON.toJSONString(loanInfo) + "\r\n", true);
            } catch (Exception e) {
                log.error("广达小贷TO百行征信报送放款信息异常, recordId: {} , loanId: {} ", id, loanInfo.getLoanId(), e);
            }
        }
    }

    //http 存量还款数据清洗
    public void stockRepaymentLoanInfo() {

        int counter = 0;
        LocalDateTime erlyDate = LocalDateTime.parse(ERLY_DATE);
        LocalDateTime endDate = LocalDateTime.parse(END_DATE);
        log.info("开始整理还款存量信息......");
        while (true) {
            counter++;
            if (erlyDate.plusDays(counter + 1).compareTo(endDate) >= 0) {
                break;
            }
            List<RepaymentLoanInfo> repaymentLoanInfos = new ArrayList<>();
            String starTime = erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE);
            String endTime = erlyDate.plusDays(counter + 1).format(DateTimeFormatter.ISO_DATE);
            log.info("整理startTime: {} , endTime: {} ", starTime, endTime);

            for (int i = 0; i < 2; i++) {
                try {
                    if (i == 0) {
                        Stopwatch stopwatch = Stopwatch.createStarted();
                        repaymentLoanInfos = repaymentLoanInfoMapper.findStockRepayMentLoanInfo(BaiHangTimeRecord.builder().startTime(starTime).endTime(endTime).build());
                        log.info("查询还款 startTime: {} , endTime: {} , 大小: {} , 耗时: {} ", starTime, endTime, repaymentLoanInfos.size(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                    } else {
                        Stopwatch stopwatch = Stopwatch.createStarted();
                        repaymentLoanInfos = repaymentLoanInfoMapper.findStockRepayMentLoanInfoOverdue(BaiHangTimeRecord.builder().startTime(starTime).endTime(endTime).build());
                        log.info("查询逾期还款 startTime: {} , endTime: {} , 大小: {} , 耗时: {} ", starTime, endTime, repaymentLoanInfos.size(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                    }
                    for (int j = 0; j < repaymentLoanInfos.size(); j++) {
                        RepaymentLoanInfo repaymentLoanInfo = repaymentLoanInfos.get(j);
//                        FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190508/baihang_source_d3.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//                        FileUtils.write(new File("/vpants/shaun/risk-datasource/鹰潭市信江广达小额贷款股份有限公司_D3_2019050805310101_0001.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
                        FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190529/xinjiangguangda_D3_2019052910580303_0001.txt"), JSON.toJSONString(repaymentLoanInfo) + "\r\n", true);
                    }
                } catch (Exception e) {
                    log.error("整理存量数据发生异常, startTime: {} , endTime: {} , num: {} ", starTime, endTime, e);
                }
            }
        }
        log.info("整理还款存量信息结束......");
//        try{
//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/鹰潭市信江广达小额贷款股份有限公司_D3_20190422110303_0003_new1.txt"), "utf-8");
////            List<RepaymentLoanInfo> repaymentLoanInfos = new Gson().fromJson(JSON.toJSONString(list), new TypeToken<ArrayList<RepaymentLoanInfo>>(){}.getType());
//            Map<String, RepaymentLoanInfo> speedMap = new HashMap<>();
//
//            for(int i=0;i<list.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
//                BaiHangNameResult baiHangNameResult = repaymentLoanInfoMapper.findName(BaiHangName.builder().loanId(repaymentLoanInfo.getLoanId()).build());
//                repaymentLoanInfo.setName(baiHangNameResult.getName());
//                repaymentLoanInfo.setPid(baiHangNameResult.getPid());
//                repaymentLoanInfo.setMobile(baiHangNameResult.getMobile());
////                UUID uuid = UUID.randomUUID();
////                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/reqIdMappingToUuid.txt"), repaymentLoanInfo.getReqID()+":"+uuid.toString().replaceAll("-", "")+"\r\n", true);
////                repaymentLoanInfo.setReqID(uuid.toString().replaceAll("-",""));
////                if(repaymentLoanInfo.getLoanStatus()==3 && "overdue".equalsIgnoreCase(repaymentLoanInfo.getTermStatus())){
////                    System.out.println("跳过第"+i+"个"+"    "+JSON.toJSONString(repaymentLoanInfo));
////                    continue;
////                }
////                loanId+termNo+状态确认时间一样的 把没有实际还款时间的删掉
//                RepaymentLoanInfo repaymentLoanInfoCache = speedMap.get(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getTermNo()+repaymentLoanInfo.getStatusConfirmAt());
//                if(repaymentLoanInfoCache!=null){ //说明里面包含了同样的记录
//                    String realRepaymentDate = repaymentLoanInfoCache.getRealRepaymentDate();
//                    if(StringUtils.isBlank(realRepaymentDate)){
//                        System.out.println("----------------------------------------------------------------跳过"+i);
//                        continue;
//                    }else{
//                        System.out.println("----------覆盖保存"+i);
//                        speedMap.put(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getTermNo()+repaymentLoanInfo.getStatusConfirmAt(), repaymentLoanInfo);
//                    }
//                }else{
//                    System.out.println("---------------正常保存"+i);
//                    speedMap.put(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getTermNo()+repaymentLoanInfo.getStatusConfirmAt(), repaymentLoanInfo);
//                }
//            }
//
//            speedMap.forEach((k, v)->{
//                RepaymentLoanInfo repaymentLoanInfo = speedMap.get(k);
//                try {
//                    FileUtils.write(new File("/Users/fengjunkai/Desktop/new/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            });
//            System.out.println("完事");
//        }catch(Exception e){
//            e.printStackTrace();
//        }
    }

    public Map<String, String> getHeader() {
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Authorization", "Basic " + Base64.byteArrayToBase64((account + ":" + password).getBytes()));
        headerMap.put("Content-Type", "application/json");
        return headerMap;
    }

    public static String interfaceUploadClient(String param) throws Exception {

        InterfaceUploadRequest req = new InterfaceUploadRequest();
        List<String> datas = new ArrayList<String>();
        datas.add(param);
        //设置待加密的原始数据集合
        req.setData(datas);
        BhInterfaceCreditApiClient client = new BhInterfaceCreditApiClient();
        //初始化设置RSA公钥
        client.init(BHRSAUtils.readRSAPublicKey("/baihang/rsa_public_key.pem"));
        //执行加密操作
        InterfaceUploadResponse response = client.execute(req);
        if (response.isSuccess) {
            List<String> data = response.getEncryptData();
            return data.get(0);
        }
        throw new Exception();
    }

    /**
     * 解密
     *
     * @throws Exception
     */
    public static void interfaceUploadValidationClient() throws Exception {
        //RSA私钥文件路径（百行提供测试环境私钥文件）
//        String RSA_PRIVATE_KEY = "d:\\rsa_private_key.pem";

        InterfaceUploadValidationRequest req = new InterfaceUploadValidationRequest();
        List<String> datas = new ArrayList<String>();
        String name = "J6kssxkrOSWPOh4XHk5cZEAEKNEQyUQeY3VNNpFHQaBJhp4lxnx+PeHgWt3uSW9A/wZf3jd5rFpdw21C55BSHHob7kU41n00Tfbt4dFy8u6lS16UaFSdNdrvZ6Y8iokVujq54zd96jggbHPK258qlrW8rkvaWp0KIWBgJesp2UQ=";//加密后的密文
//        String pid = "CSdFOGhhZS1eX5NnPAIR6/vh3FzgMBRSvJVcgf4WI8d4zStBjXKUf7UfsjGfcdMjPLkPQ93sD0OqkF5XuMWaCSkt1gHkvQCmxvErBYDfaYKI6rMY4QdJ4BPxau/IStAo+hXNdlD9gGBZpIjEtickDIw1YYdLfqRw4mZdNuMkMXI=";//加密后的密文
//        String mobile= "B5F2ozIoPbXpv65rk7fStPsVmpF0xoB+wpTc++1EvWqoDYZ5epWGmBdtxCElgvdflBcWDzB0oPPM8PclG0p/EPmJcrbivkFHN65HViTvfk2Xxs+sss9IomhmuWiLS5BTpxyTlMsPnSPjmE8so6S16YiiW3ZVble2CijUKPV+Luk=";//加密后的密文
        datas.add(name);
//        datas.add(pid);
//        datas.add(mobile);
        //设置待解密的密文数据集合
        req.setData(datas);
        BhInterfaceCreditApiClient client = new BhInterfaceCreditApiClient();
        //初始化设置RSA私钥
        client.init(BHRSAUtils.readRSAPrivateKey("/baihang/rsa_private_key.pem"));
        //执行解密操作
        InterfaceUploadValidationResponse response = client.execute(req);
        if (response.isSuccess) {
            List<String> data = response.getDecryptData();
            for (int i = 0; i < data.size(); i++) {
                System.out.println(data.get(i));
            }
            System.out.println("decrypt success;decrypt data = " + response.getDecryptData());
        } else {
            System.out.println("decrypt fail;errorMessage = " + response.getErrorMessage());
        }
    }

    public static void main(String[] args) {
//        String startTime = DateUtils.getYesterdayDateStr();
//        System.out.println(startTime);
        try {
//            interfaceUploadValidationClient();
//            interfaceUploadClient();
//            fileUploadClient();
//            System.out.println("fdsfsa");
//            fileUploadValidationClient();
//            convertApplyLoanInfo();
//            convertLoanInfo();
//            convertRepaymentLoanInfo();
//            System.out.println(interfaceUploadClient("15045300259"));
//            Map<String,Object> map = new HashMap<>();
//            RepaymentLoanInfo repaymentLoanInfo = new RepaymentLoanInfo();
//            repaymentLoanInfo.setRealRepayment(new BigDecimal("11.11"));
//            System.out.println(JSON.toJSONString(repaymentLoanInfo));

//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Documents/repaymentLoanInfo11.json"), "utf-8");
//            for(int i=0;i<list.size();i++){
//                try{
//                    RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
////                    repaymentLoanInfo.setPid(interfaceUploadClient(repaymentLoanInfo.getPid()));
////                    repaymentLoanInfo.setName(interfaceUploadClient(repaymentLoanInfo.getName()));
////                    repaymentLoanInfo.setMobile(interfaceUploadClient(repaymentLoanInfo.getMobile()));
//
//                    Map<String,Object> repaymentLoanInfoMap = new HashMap<>();
//                    repaymentLoanInfoMap.put("reqID", repaymentLoanInfo.getReqID());
//                    repaymentLoanInfoMap.put("uploadTs", repaymentLoanInfo.getUploadTs());
//                    repaymentLoanInfoMap.put("opCode", repaymentLoanInfo.getOpCode());
//                    repaymentLoanInfoMap.put("loanId", repaymentLoanInfo.getLoanId());
//                    repaymentLoanInfoMap.put("name", interfaceUploadClient(repaymentLoanInfo.getName()));
//                    repaymentLoanInfoMap.put("mobile", interfaceUploadClient(repaymentLoanInfo.getMobile()));
//                    repaymentLoanInfoMap.put("pid", interfaceUploadClient(repaymentLoanInfo.getPid()));
//                    repaymentLoanInfoMap.put("termNo", repaymentLoanInfo.getTermNo());
//                    repaymentLoanInfoMap.put("termStatus", repaymentLoanInfo.getTermStatus());
//                    repaymentLoanInfoMap.put("targetRepaymentDate", repaymentLoanInfo.getTargetRepaymentDate());
////                if(!"overdue".equals(repaymentLoanInfo.getTermStatus())){
//                    repaymentLoanInfoMap.put("realRepaymentDate", repaymentLoanInfo.getRealRepaymentDate());
////                }
//                    repaymentLoanInfoMap.put("plannedPayment", repaymentLoanInfo.getPlannedPayment());
//                    repaymentLoanInfoMap.put("targetRepayment", repaymentLoanInfo.getTargetRepayment());
//                    repaymentLoanInfoMap.put("realRepayment", repaymentLoanInfo.getRealRepayment());
//                    repaymentLoanInfoMap.put("overdueStatus", repaymentLoanInfo.getOverdueStatus());
//                    repaymentLoanInfoMap.put("statusConfirmAt", repaymentLoanInfo.getStatusConfirmAt());
//                    repaymentLoanInfoMap.put("overdueAmount", repaymentLoanInfo.getOverdueAmount());
//                    repaymentLoanInfoMap.put("remainingAmount", repaymentLoanInfo.getRemainingAmount());
//                    repaymentLoanInfoMap.put("loanStatus", repaymentLoanInfo.getLoanStatus());
////                    String resultStr = iHttpService.postBaiHang(baiHangRepayMentLoanInfoUrl, getHeader(), JSON.toJSONString(repaymentLoanInfoMap));
//                    System.out.println(JSON.toJSONString(repaymentLoanInfoMap));
//
//                }catch(Exception e){
//                    log.error("广达小贷TO百行征信报送非循环贷还款信息异常", e);
//                }
//            }
//            UUID uuid = UUID.randomUUID();
//            System.out.println(uuid.toString().replaceAll("-",""));
//            System.out.println(LocalDateTime.now().format(DateTimeFormatter.ISO_DATE));
//            System.out.println(LocalDateTime.now().plusDays(-1).format(DateTimeFormatter.ISO_DATE));
//            String str = FileUtils.readFileToString(new File("/Users/fengjunkai/Downloads/111.txt"), "utf-8");
//            String str = FileUtils.readFileToString(new File("/Users/fengjunkai/Desktop/20190421/loanInfo_0421"), "utf-8");
//            String str = FileUtils.readFileToString(new File("/Users/fengjunkai/Desktop/20190421/repaymentInfo_0421"), "utf-8");
//            JSONArray jsonArray = JSON.parseArray(str);
//            for(int i=0;i<jsonArray.size();i++){
//                JSONObject jsonObject = jsonArray.getJSONObject(i);
//                FileUtils.write(new File("/Users/fengjunkai/Desktop/20190421/鹰潭市信江广达小额贷款股份有限公司_D2_20190421141422_0002.txt"), JSON.toJSONString(jsonObject)+"\r\n", true);
//                FileUtils.write(new File("/Users/fengjunkai/Desktop/20190421/鹰潭市信江广达小额贷款股份有限公司_D3_20190421141422_0003.txt"), JSON.toJSONString(jsonObject)+"\r\n", true);
//            }

//            String startTime = LocalDateTime.now().plusDays(-1).format(DateTimeFormatter.ISO_DATE);
//            String endTime = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE);
//            for(int i=0;i<100;i++){
//                System.out.println("startTime : "+LocalDateTime.now().plusDays(-(i+1)).format(DateTimeFormatter.ISO_DATE)+", "+"endTime : "+LocalDateTime.now().plusDays(-i).format(DateTimeFormatter.ISO_DATE));
//            }


//            int counter = 0;
//            LocalDateTime erlyDate = LocalDateTime.parse(ERLY_DATE);
//            LocalDateTime endDate = LocalDateTime.parse(END_DATE);
//            while (true){
//                counter++;
//                if(endDate.compareTo(erlyDate.plusDays(counter))>0){
//                    break;
//                }
//                System.out.println("startTime : "+erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE)+", "+"endTime : "+erlyDate.plusDays(counter+1).format(DateTimeFormatter.ISO_DATE));
//            }
//            System.out.println(LocalDateTime.now().plusDays(-1).compareTo(LocalDateTime.now())>=0);
//            System.out.println(LocalDateTime.now().compareTo(LocalDateTime.now()));
//            System.out.println(0>0);
//            System.out.println(LocalDateTime.parse("2017-09-31").format(DateTimeFormatter.ISO_DATE));;
//            String s = LocalDateTime.parse("2017-09-31").format(DateTimeFormatter.ISO_DATE);
//            System.out.println(LocalDateTime.parse("2017-09-29T00:00:00").format(DateTimeFormatter.ISO_DATE));
//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/鹰潭市信江广达小额贷款股份有限公司_D3_20190422110303_0003_new2.txt"), "utf-8");
//            List<RepaymentLoanInfo> repaymentLoanInfos = new Gson().fromJson(JSON.toJSONString(list), new TypeToken<ArrayList<RepaymentLoanInfo>>(){}.getType());
//            Map<String, RepaymentLoanInfo> speedMap = new HashMap<>();
//
//            for(int i=0;i<list.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
////                UUID uuid = UUID.randomUUID();
////                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/reqIdMappingToUuid.txt"), repaymentLoanInfo.getReqID()+":"+uuid.toString().replaceAll("-", "")+"\r\n", true);
////                repaymentLoanInfo.setReqID(uuid.toString().replaceAll("-",""));
////                if(repaymentLoanInfo.getLoanStatus()==3 && "overdue".equalsIgnoreCase(repaymentLoanInfo.getTermStatus())){
////                    System.out.println("跳过第"+i+"个"+"    "+JSON.toJSONString(repaymentLoanInfo));
////                    continue;
////                }
////                loanId+termNo+状态确认时间一样的 把没有实际还款时间的删掉
//                RepaymentLoanInfo repaymentLoanInfoCache = speedMap.get(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getTermNo()+repaymentLoanInfo.getStatusConfirmAt());
//                if(repaymentLoanInfoCache!=null){ //说明里面包含了同样的记录
//                    String realRepaymentDate = repaymentLoanInfoCache.getRealRepaymentDate();
//                    if(StringUtils.isBlank(realRepaymentDate)){
//                        continue;
//                    }else{
//                        speedMap.put(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getTermNo()+repaymentLoanInfo.getStatusConfirmAt(), repaymentLoanInfo);
//                    }
//                }else{
//                    speedMap.put(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getTermNo()+repaymentLoanInfo.getStatusConfirmAt(), repaymentLoanInfo);
//                }
//            }
//
//            speedMap.forEach((k, v)->{
//                RepaymentLoanInfo repaymentLoanInfo = speedMap.get(k);
//                try {
//                    FileUtils.write(new File("/Users/fengjunkai/Desktop/new/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            });
//            System.out.println("完事");
//

//            LocalDateTime localDateTime = LocalDateTime.now();
//            System.out.println(localDateTime);
//            System.out.println(localDateTime.toString().substring(0,19));
//            System.out.println(localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE));
//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004.txt"), "utf-8");
//            Map<String,RepaymentLoanInfo> repaymentLoanInfoMap = new HashMap<>();
//            for(int i=1;i<list.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
//                repaymentLoanInfoMap.put(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getTermNo()+repaymentLoanInfo.getLoanStatus(), repaymentLoanInfo);
//            }
//            List<String> list1 = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/CRY/11111111"), "utf-8");
//            for(int i=0;i<list1.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = repaymentLoanInfoMap.get(list1.get(i));
//                System.out.println(JSON.toJSONString(repaymentLoanInfo));
//
//                repaymentLoanInfo.setLoanStatus(2);
//                repaymentLoanInfo.setOpCode("M");
//                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_tmp1.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//            }
//            for(int i=1;i<list.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
//                repaymentLoanInfo.setOpCode("M");
//                if("967167083".equals(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getLoanStatus())){
//                    repaymentLoanInfo.setRealRepayment(repaymentLoanInfo.getPlannedPayment());
//                    FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_tmp.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//                }else if("967175963".equals(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getLoanStatus())){
//                    repaymentLoanInfo.setRealRepayment(repaymentLoanInfo.getPlannedPayment());
//                    FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_tmp.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//                }else if("967162983".equals(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getLoanStatus())){
//                    repaymentLoanInfo.setRealRepayment(repaymentLoanInfo.getPlannedPayment());
//                    FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_tmp.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//                }else if("967167603".equals(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getLoanStatus())){
//                    repaymentLoanInfo.setRealRepayment(repaymentLoanInfo.getPlannedPayment());
//                    FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_tmp.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//                }else if("967141803".equals(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getLoanStatus())){
//                    repaymentLoanInfo.setRealRepayment(repaymentLoanInfo.getPlannedPayment());
//                    FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_tmp.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//                }
//            }

//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_M_logicerror.log"), "utf-8");
//            List<String> list1 = new ArrayList<>();
//            for(int i=1;i<list.size();i++){
//                JSONObject jsonObject = JSON.parseObject(list.get(i));
//                String reqId = jsonObject.getString("reqID");
//                list1.add(reqId);
//            }
//
//            List<String> list2 = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_tmp1.txt"), "utf-8");
//            Map<String,RepaymentLoanInfo> repaymentLoanInfoMap = new HashMap<>();
//            for(int i=0;i<list2.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list2.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
//                repaymentLoanInfoMap.put(repaymentLoanInfo.getReqID(), repaymentLoanInfo);
//            }
//
////            repaymentLoanInfoMap.forEach((k,v)->{
////                try {
////                    FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_MM.txt"), JSON.toJSONString(v)+"\r\n", true);
////                } catch (IOException e) {
////                    e.printStackTrace();
////                }
////            });
//            for(int i=0;i<list1.size();i++){
//                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_MM.txt"), JSON.toJSONString(repaymentLoanInfoMap.get(list1.get(i)))+"\r\n", true);
//            }

//            List<String> list3 = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_MM.txt"), "utf-8");
//            for(int i=0;i<list3.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list3.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
//                repaymentLoanInfo.setLoanStatus(1);
//                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_M1.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//            }

//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004.txt"), "utf-8");
//            for(int i=0;i<list.size();i++){
//
//            }

//            List<String> list1 = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/22222"), "utf-8");
//            Map<String,String> map = new HashMap<>();
//            for(int i=0;i<list1.size();i++){
//                String str[] = list1.get(i).split(":");
//                map.put(str[0]+str[1]+str[2], str[3]);
//            }
//
//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004.txt"), "utf-8");
//            Map<String,RepaymentLoanInfo> repaymentLoanInfoMap = new HashMap<>();
//            for(int i=1;i<list.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
//                repaymentLoanInfoMap.put(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getLoanStatus()+repaymentLoanInfo.getTermNo()+repaymentLoanInfo.getOverdueStatus(), repaymentLoanInfo);
//            }

//            for(int i=0;i<list.size();i++){
//                if(list.get(i).contains("90987526")){
//                    System.out.println(list.get(i));
//                }
//            }
//
//            map.forEach((k,v)->{
//                RepaymentLoanInfo repaymentLoanInfo = repaymentLoanInfoMap.get(k);
//                repaymentLoanInfo.setRemainingAmount(new BigDecimal(v).setScale(2, BigDecimal.ROUND_HALF_UP));
//                repaymentLoanInfo.setOpCode("M");
//                try {
//                    FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_M2.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            });


//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004.txt"), "utf-8");
//            Map<String,RepaymentLoanInfo> map = new HashMap<>();
//            for(int i=1;i<list.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
//                map.put(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getLoanStatus()+repaymentLoanInfo.getTermNo()+repaymentLoanInfo.getOverdueStatus(), repaymentLoanInfo);
//                map.put(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getLoanStatus()+repaymentLoanInfo.getTermNo(), repaymentLoanInfo);
//                map.put(repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getLoanStatus()+repaymentLoanInfo.getTermNo(), repaymentLoanInfo);
//            }
//            System.out.println(map.size());
//
//            List<String> list1 = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/CRY/20190428/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_20190428"), "utf-8");
//            for(int i=0;i<list1.size();i++){
//                String tmp[] = list1.get(i).split("#");
////                RepaymentLoanInfo repaymentLoanInfo = map.get(tmp[0]+tmp[1]+tmp[2]+tmp[3]);
////                repaymentLoanInfo.setRealRepaymentDate(tmp[4]);
////                repaymentLoanInfo.setTargetRepayment(new BigDecimal(tmp[5]).setScale(2, BigDecimal.ROUND_HALF_UP));
////                repaymentLoanInfo.setRealRepayment(new BigDecimal(6).setScale(2, BigDecimal.ROUND_HALF_UP));
////                repaymentLoanInfo.setOpCode("M");
////                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/20190428/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_M3.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//
////                RepaymentLoanInfo repaymentLoanInfo = map.get(tmp[0]+tmp[1]+tmp[2]);
////                repaymentLoanInfo.setOpCode("M");
////                repaymentLoanInfo.setLoanStatus(1);
////                repaymentLoanInfo.setRemainingAmount(new BigDecimal(tmp[3]).setScale(2, BigDecimal.ROUND_HALF_UP));
////                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/20190428/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_1.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//
//                RepaymentLoanInfo repaymentLoanInfo = map.get(tmp[0]+tmp[1]+tmp[2]);
//                repaymentLoanInfo.setOpCode("M");
//                repaymentLoanInfo.setLoanStatus(1);
//
//                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/20190428/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_2.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//            }
//            String key = "9168549029D1";
//            RepaymentLoanInfo repaymentLoanInfo = map.get(key);
//            repaymentLoanInfo.setRealRepayment(new BigDecimal("2392.39").setScale(2, BigDecimal.ROUND_HALF_UP));
//            repaymentLoanInfo.setOpCode("M");
//            FileUtils.write(new File("/Users/fengjunkai/Desktop/new/CRY/20190430/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_M4.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);


//            List<String> list1 = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/20190509/tmp"), "utf-8");
//            Map<String,String> map = new HashMap<>();
//            for(int i=0;i<list1.size();i++){
//                String tmp = list1.get(i);
//                map.put(tmp, "1");
//            }
//
//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D3_2019050805310101_0008.txt"), "utf-8");
////            for(int i=0;i<list.size();i++){
////                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
////                repaymentLoanInfo.setReqID(UUID.randomUUID().toString().replaceAll("-", ""));
////                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D3_2019050805310101_0004.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
////            }
//            for(int i=0;i<list.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
////                String key = repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getLoanStatus()+repaymentLoanInfo.getOverdueStatus()+repaymentLoanInfo.getTermNo()+"0"+repaymentLoanInfo.getStatusConfirmAt();
////                if(map.containsKey(key) && StringUtils.isBlank(repaymentLoanInfo.getRealRepaymentDate())){
////                    System.out.println("包含key=="+key);
////                    continue;
////                }
//
//                if(repaymentLoanInfo.getLoanStatus()==3 && "overdue".equalsIgnoreCase(repaymentLoanInfo.getTermStatus())){
//                    System.out.println("shanchu"+repaymentLoanInfo.getLoanStatus()+"###"+repaymentLoanInfo.getTermStatus());
//                    continue;
//                }
//
//                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D3_2019050805310101_0009.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//            }
//            System.out.println("完事");


//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D3_2019050805310101_0009.txt"), "utf-8");
//            List<String> tmp = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/20190509/tmp.txt"), "utf-8");
////            Map<String,RepaymentLoanInfo> repaymentLoanInfoMap = new HashMap<>();
//
//
//            Map<String,String> map = new HashMap<>();
//            for(int i=0;i<tmp.size();i++){
//                String tmpargs[] = tmp.get(i).split("###");
//                map.put(tmpargs[0]+tmpargs[1]+tmpargs[2], tmpargs[3]);
//            }
//
//            for(int i=1;i<list.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
//                String key = repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getPlannedPayment()+repaymentLoanInfo.getTermNo();
//                if(map.containsKey(key)){
//                    repaymentLoanInfo.setPlannedPayment(new BigDecimal(map.get(key)).setScale(2, BigDecimal.ROUND_HALF_UP));
//                    repaymentLoanInfo.setOpCode("M");
//                    FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D3_2019050805310101_0009_M.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//                }
//            }

//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D3_2019050805310101_0009.txt"), "utf-8");
//            List<String> tmp = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/20190509/tmp.txt"), "utf-8");
////            Map<String,RepaymentLoanInfo> repaymentLoanInfoMap = new HashMap<>();
//
//
//            Map<String,String> map = new HashMap<>();
//            for(int i=0;i<tmp.size();i++){
//                String tmpargs[] = tmp.get(i).split("###");
//                map.put(tmpargs[0]+tmpargs[1]+tmpargs[2], tmpargs[3]);
//            }
//
//            for(int i=1;i<list.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
//                String key = repaymentLoanInfo.getLoanId()+repaymentLoanInfo.getPlannedPayment()+repaymentLoanInfo.getTermNo();
//                if(map.containsKey(key)){
//                    repaymentLoanInfo.setPlannedPayment(new BigDecimal(map.get(key)).setScale(2, BigDecimal.ROUND_HALF_UP));
////                    repaymentLoanInfo.setOpCode("M");
//                    System.out.println(JSON.toJSONString(repaymentLoanInfo));
//                    FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D3_2019052418260303_0001.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//                }else{
//                    FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D3_2019052418260303_0001.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//                }
//            }
//            System.out.println("wanshi");

//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D3_2019052418260303_0001.txt"), "utf-8");
//            for(int i=0;i<list.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
////                repaymentLoanInfo.setName(interfaceUploadClient(repaymentLoanInfo.getName()));
////                repaymentLoanInfo.setMobile(interfaceUploadClient(repaymentLoanInfo.getMobile()));
////                repaymentLoanInfo.setPid(interfaceUploadClient(repaymentLoanInfo.getPid()));
//                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D3_2019052418260303_0003_M.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//            }
//            System.out.println("wanshi");
//
//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_C1_2019050805310101_0001.txt"), "utf-8");
//            for(int i=1;i<list.size();i++){
//                ApplyLoanInfo applyLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<ApplyLoanInfo>(){}.getType());
////                applyLoanInfo.setName(interfaceUploadClient(applyLoanInfo.getName()));
////                applyLoanInfo.setMobile(interfaceUploadClient(applyLoanInfo.getMobile()));
////                applyLoanInfo.setPid(interfaceUploadClient(applyLoanInfo.getPid()));
//                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_C1_2019052418260303_0001_M.txt"), JSON.toJSONString(applyLoanInfo)+"\r\n", true);
//            }
//            System.out.println("wanshi");


//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Desktop/new/20190529/xinjiangguangda_D3_2019052910580303_0001.txt"), "utf-8");
//            for(int i=0;i<list.size();i++){
//                RepaymentLoanInfo repaymentLoanInfo = new Gson().fromJson(list.get(i), new TypeToken<RepaymentLoanInfo>(){}.getType());
//                repaymentLoanInfo.setReqID(UUID.randomUUID().toString().replaceAll("-", ""));
//                FileUtils.write(new File("/Users/fengjunkai/Desktop/new/20190529/xinjiangguangda_D3_2019052910580303_0002.txt"), JSON.toJSONString(repaymentLoanInfo)+"\r\n", true);
//            }
//            System.out.println(LocalDateTime.now().plusDays(-1).format(DateTimeFormatter.ISO_DATE));
//            System.out.println(LocalDateTime.now().format(DateTimeFormatter.ISO_DATE));
//            System.out.println(LocalDateTime.now().plusDays(-1).format(DateTimeFormatter.ISO_DATE));
//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Downloads/baihang/百行2019-08-09至2019-08-10调用命中数据.txt"), "utf-8");
//            for(int i=0;i<list.size();i++){
//                String uuid = list.get(i);
//                FileUtils.write(new File("/Users/fengjunkai/Downloads/baihang/data.txt"), uuid+"\t"+uuid+"\r\n", "utf-8", true);
//            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //文件方式上报的客户端代码
    public static void fileUploadClient() throws Exception {
        //RSA公钥文件路径（百行提供公钥文件）
//        String RSA_PUBLIC_KEY = "d:\\rsa_public_key.pem";
        //AES密钥（机构自行设置）
        String AES_KEY = "fc4c1cbca5a46840f60";

        FileUploadRequest req = new FileUploadRequest();
        //设置未作压缩加密前的原始数据文件路径
//        req.setDataFile("/Users/fengjunkai/Desktop/new/鹰潭市信江广达小额贷款股份有限公司_C1_201904241037_0002.txt");
//        req.setDataFile("/Users/fengjunkai/Desktop/new/鹰潭市信江广达小额贷款股份有限公司_D2_201904241037_0003.txt");
//        req.setDataFile("/Users/fengjunkai/Desktop/new/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004.txt");
//        req.setDataFile("/Users/fengjunkai/Desktop/new/CRY/鹰潭市信江广达小额贷款股份有限公司_D2_201904241037_0003_M.txt");
//        req.setDataFile("/Users/fengjunkai/Desktop/new/201905060525/鹰潭市信江广达小额贷款股份有限公司_D3_201904241037_0004_M6.txt");
//        req.setDataFile("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_C1_2019050805310101_0001.txt");
//        req.setDataFile("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D2_2019050805310101_0001.txt");
//        req.setDataFile("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D3_2019050805310101_0009.txt");
//        req.setDataFile("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D3_2019050805310101_0009_M.txt");
//        req.setDataFile("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_C1_2019052418260303_0001_M.txt");
//        req.setDataFile("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D2_2019052418260303_0001_M.txt");
//        req.setDataFile("/Users/fengjunkai/Desktop/new/20190509/鹰潭市信江广达小额贷款股份有限公司_D3_2019052418260303_0003_M.txt");
//        req.setDataFile("/Users/fengjunkai/Desktop/new/20190529/xinjiangguangda_C1_2019052910580303_0001.txt");
//        req.setDataFile("/Users/fengjunkai/Desktop/new/20190529/xinjiangguangda_D2_2019052910580303_0001.txt");
        req.setDataFile("/Users/fengjunkai/Desktop/new/20190529/xinjiangguangda_D3_2019052910580303_0002.txt");
        //设置压缩加密后的密文文件输出路径(为空表示与原始数据文件同目录)
        req.setTargetFilePath("/Users/fengjunkai/Desktop/new/20190529");

        BhFileCreditApiClient client = new BhFileCreditApiClient();
        //初始化设置AES密钥和RSA公钥
        client.init(BHRSAUtils.readRSAPublicKey("/baihang/rsa_public_key.pem"), AES_KEY);
        //执行压缩加密操作
        FileUploadResponse response = client.execute(req);
        if (response.isSuccess) {
            System.out.println("zip And encrypt success;fileName = " + response.getEncryptFilePath() + response.getEncryptFileName());
        } else {
            System.out.println("zip And encrypt fail;errorMessage = " + response.getErrorMessage());
        }
    }

    //文件方式上报的客户端本地测试代码
    public static void fileUploadValidationClient() throws Exception {
        //RSA私钥文件路径（百行提供测试环境私钥文件）
//        String RSA_PRIVATE_KEY = "d:\\rsa_private_key.pem";
        FileUploadValidationRequest req = new FileUploadValidationRequest();
        //设置压缩加密后的数据文件路径
        req.setDataFile("/Users/fengjunkai/Desktop/鹰潭市信江广达小额贷款股份有限公司_C1_20190420172012_0001.cry");
//        req.setDataFile("/Users/fengjunkai/Desktop/鹰潭市信江广达小额贷款股份有限公司_D2_20190420172012_0002.cry");
//        req.setDataFile("/Users/fengjunkai/Desktop/鹰潭市信江广达小额贷款股份有限公司_D3_20190420172012_0003.cry");
        //设置解密解压的原始文件输出路径(为空表示与加密数据文件同目录)
        req.setTargetFilePath("/Users/fengjunkai/Documents/send1");

        BhFileCreditApiClient client = new BhFileCreditApiClient();
        //初始化设置RSA私钥
        client.init(BHRSAUtils.readRSAPrivateKey("/baihang/rsa_private_key.pem"));
        //执行解密解压操作
        FileUploadValidationResponse response = client.execute(req);
        if (response.isSuccess) {
            System.out.println("decrypt And unzip success;fileName = " + response.getDecryptFilePath() + response.getDecryptFileName());
        } else {
            System.out.println("decrypt And unzip fail;errorMessage = " + response.getErrorMessage());
        }
    }


    public static void convertRepaymentLoanInfo() {
        try {

            String readAddr = "/Users/fengjunkai/Documents/鹰潭市信江广达小额贷款股份有限公司_D3_201904011543_0003.json";
            String sourceStr = FileUtils.readFileToString(new File(readAddr), "utf-8");
            String writeAddr = "/Users/fengjunkai/Documents/baihang_test_data_file/鹰潭市信江广达小额贷款股份有限公司_D3_20190401_0003.txt";
            JSONObject sourceJson = JSON.parseObject(sourceStr);
            JSONArray recordsJsonArr = sourceJson.getJSONArray("RECORDS");
            FileUtils.write(new File(writeAddr), "#singleLoanRepayInfo" + "\r\n", "utf-8", true);
            for (int i = 0; i < recordsJsonArr.size(); i++) {
                JSONObject recordJson = recordsJsonArr.getJSONObject(i);
                FileUtils.write(new File(writeAddr), JSON.toJSONString(recordJson) + "\r\n", "utf-8", true);
            }

            System.out.println("完事");
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void convertLoanInfo() {
        try {

            String readAddr = "/Users/fengjunkai/Documents/鹰潭市信江广达小额贷款股份有限公司_D2_201904011543_0002.json";
            String sourceStr = FileUtils.readFileToString(new File(readAddr), "utf-8");
            String writeAddr = "/Users/fengjunkai/Documents/baihang_test_data_file/鹰潭市信江广达小额贷款股份有限公司_D2_20190401_0002.txt";
            JSONObject sourceJson = JSON.parseObject(sourceStr);
            JSONArray recordsJsonArr = sourceJson.getJSONArray("RECORDS");
            FileUtils.write(new File(writeAddr), "#singleLoanAccountInfo" + "\r\n", "utf-8", true);
            for (int i = 0; i < recordsJsonArr.size(); i++) {
                JSONObject recordJson = recordsJsonArr.getJSONObject(i);
                FileUtils.write(new File(writeAddr), JSON.toJSONString(recordJson) + "\r\n", "utf-8", true);
            }
            System.out.println("完事");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void convertApplyLoanInfo() {
        try {
            String readAddr = "/Users/fengjunkai/Documents/鹰潭市信江广达小额贷款股份有限公司_C1_201904011543_0001.json";
            String writeAddr = "/Users/fengjunkai/Documents/baihang_test_data_file/鹰潭市信江广达小额贷款股份有限公司_C1_20190401_0001.txt";
            String sourceStr = FileUtils.readFileToString(new File(readAddr), "utf-8");

            JSONObject sourceJson = JSON.parseObject(sourceStr);
            JSONArray recordsJsonArr = sourceJson.getJSONArray("RECORDS");

            FileUtils.write(new File(writeAddr), "#loanApplyInfo" + "\r\n", "utf-8", true);
            for (int i = 0; i < recordsJsonArr.size(); i++) {
                JSONObject recordJson = recordsJsonArr.getJSONObject(i);
                FileUtils.write(new File(writeAddr), JSON.toJSONString(recordJson) + "\r\n", "utf-8", true);
            }
            System.out.println("完事");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    @Async
    public void baihangData(String readName, String writeName){
        try{
//            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Downloads/baihang/"+readName+".txt"), "utf-8");
            List<String> list = FileUtils.readLines(new File("/home/quant_group/risk-datasource/data/baihang/"+readName+".txt"), "utf-8");
            for(int i=0;i<list.size();i++){
                String uuid = list.get(i);
                SdkUser userFullInfoByUuid = iUserCenterService.getUserFullInfoByUuid(uuid);
                String responseInHBase = thirdpartyApiMonitorService.loadInHBaseAndCheckTimeOut(RequestUrlType.BaiHangPersionalCreditReport, uuid, 1000);
                String reportId = "";
                String reportTime = "";
                String pid = "";
                String name = Objects.nonNull(userFullInfoByUuid)?userFullInfoByUuid.getName():"";
                if(StringUtils.isNotBlank(responseInHBase)){
                    JSONObject jsonObject = JSONObject.parseObject(responseInHBase);
                    reportId = jsonObject.getJSONObject("reportHeader").getString("reportId");
                    reportTime = jsonObject.getJSONObject("reportHeader").getString("reportTime");
                    pid = jsonObject.getJSONObject("personalProfile").getString("pid");
//                    name = jsonObject.getJSONObject("personalProfile").getString("name");
                }
//                FileUtils.write(new File("/Users/fengjunkai/Downloads/baihang/"+writeName+".txt"), uuid+"\t"+reportId+"\t"+reportTime+"\t"+name+"\t"+pid+"\r\n", "utf-8", true);
                FileUtils.write(new File("/home/quant_group/risk-datasource/data/baihang/"+writeName+".txt"), uuid+"\t"+reportId+"\t"+reportTime+"\t"+name+"\t"+pid+"\r\n", "utf-8", true);
            }
        }catch(Exception e){
            e.printStackTrace();
        }
    }


    //                    Map<String,Object> repaymentLoanInfoMap = new HashMap<>();
//                    repaymentLoanInfoMap.put("reqID", repaymentLoanInfo.getReqID());
//                    repaymentLoanInfoMap.put("uploadTs", repaymentLoanInfo.getUploadTs());
//                    repaymentLoanInfoMap.put("loanId", repaymentLoanInfo.getLoanId());
//                    repaymentLoanInfoMap.put("opCode", repaymentLoanInfo.getOpCode());
//                    repaymentLoanInfoMap.put("name", interfaceUploadClient(repaymentLoanInfo.getName()));
//                    repaymentLoanInfoMap.put("mobile", interfaceUploadClient(repaymentLoanInfo.getMobile()));
//                    repaymentLoanInfoMap.put("pid", interfaceUploadClient(repaymentLoanInfo.getPid()));
//                    repaymentLoanInfoMap.put("termNo", repaymentLoanInfo.getTermNo());
//                    repaymentLoanInfoMap.put("targetRepaymentDate", repaymentLoanInfo.getTargetRepaymentDate());
//                    repaymentLoanInfoMap.put("termStatus", repaymentLoanInfo.getTermStatus());
//                    repaymentLoanInfoMap.put("realRepaymentDate", repaymentLoanInfo.getRealRepaymentDate());
//                    repaymentLoanInfoMap.put("plannedPayment", repaymentLoanInfo.getPlannedPayment());
//                    repaymentLoanInfoMap.put("targetRepayment", repaymentLoanInfo.getTargetRepayment());
//                    repaymentLoanInfoMap.put("overdueStatus", repaymentLoanInfo.getOverdueStatus());
//                    repaymentLoanInfoMap.put("statusConfirmAt", repaymentLoanInfo.getStatusConfirmAt());
//                    repaymentLoanInfoMap.put("overdueAmount", repaymentLoanInfo.getOverdueAmount());
//                    repaymentLoanInfoMap.put("realRepayment", repaymentLoanInfo.getRealRepayment());
//                    repaymentLoanInfoMap.put("remainingAmount", repaymentLoanInfo.getRemainingAmount());
//                    repaymentLoanInfoMap.put("loanStatus", repaymentLoanInfo.getLoanStatus());

}
