package cn.quantgroup.report.service.baihang;

import cn.quantgroup.report.service.CommonSuperService;
import cn.quantgroup.report.config.aop.DistributedLock;
import cn.quantgroup.report.config.aop.Monitor;
import cn.quantgroup.report.config.aop.MonitorType;
import cn.quantgroup.report.constant.TransactionCodeEnum;
import cn.quantgroup.report.enums.RequestUrlType;
import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.AbstractBaseService;
import cn.quantgroup.report.service.baihang.client.BhInterfaceCreditApiClient;
import cn.quantgroup.report.service.baihang.request.InterfaceUploadRequest;
import cn.quantgroup.report.service.baihang.response.InterfaceUploadResponse;
import cn.quantgroup.report.service.baihang.util.BHRSAUtils;
import cn.quantgroup.report.service.baihang.util.Base64;
import cn.quantgroup.report.service.http.IHttpService;
import cn.quantgroup.report.service.thirdpartymonitor.ThirdpartyApiMonitorService;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 百行征信查询用户征信报告
 *
 * @Author fengjunkai
 * @Date 2019-03-29 11:26
 */
@Deprecated
@Slf4j
@Service
public class BaiHangZhengXinService  extends AbstractBaseService implements CommonSuperService {

    @Autowired
    private ThirdpartyApiMonitorService thirdpartyApiMonitorService;


    @Autowired
    private IHttpService iHttpService;

    @Value("${baihang.zhudai.applyloan.url}")
    private String baiHangApplyLoanInfoUrl;

    @Value("${baihang.zhudai.loaninfo.url}")
    private String baiHangLoanInfoUrl;

    @Value("${baihang.zhudai.repaymentloaninfo.url}")
    private String baiHangRepayMentLoanInfoUrl;

    @Value("${baihang.zhudai.account.name}")
    private String account;
    @Value("${baihang.zhudai.password}")
    private String password;

    @Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    @DistributedLock
    public GlobalResponse baiHangZxQuery(String transactionId, String uuid, String name, String idCard, String mobile, String orderNo, boolean isReadCache){
        log.info("开始查询百行征信报告, transactionId: {} , uuid: {} , name: {} , idCard: {} , mobile: {} , orderNo: {} ",
                transactionId, uuid, name, idCard, mobile, orderNo);

        RequestUrlType requestUrlType = RequestUrlType.BaiHangCreditReport;

        Integer cacheTime = isReadCache? cacheConfigService.getTestCacheTime(requestUrlType.name()):cacheConfigService.getCacheTime(requestUrlType.name());

        if(isReadCache){

            String responseInHBase = thirdpartyApiMonitorService.loadInHBaseAndCheckTimeOut(requestUrlType, uuid, cacheTime);
            if(StringUtils.isNotBlank(responseInHBase)){
                log.info("百行征信hbase查询到结果, transactionId: {} , urlType : {}, uuid: {} , name: {} , idNo: {} , phoneNo: {} , isReadCache: {} , cacheTime: {} ",
                        transactionId, requestUrlType, uuid, name, idCard, mobile, isReadCache, cacheTime);
                return GlobalResponse.builder(transactionId, JSON.parseObject(responseInHBase)).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.HitInHbase);
            }else{
                log.info("百行征信hbase未查询到结果, transactionId: {} , urlType : {}, uuid: {} , name: {} , idNo: {} , phoneNo: {} , isReadCache: {} , cacheTime: {} ",
                        transactionId, requestUrlType, uuid, name, idCard, mobile, isReadCache, cacheTime);
                return GlobalResponse.builder(transactionId, null).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.Fail);
            }

        }else{

            if(cacheTime>0){
                String responseInHBase = thirdpartyApiMonitorService.loadInHBaseAndCheckTimeOut(requestUrlType, uuid, cacheTime);
                if (responseInHBase != null) {
                    log.info("百行征信从hbase拿到数据, transactionId : {} urlType : {} , uuid: {}", transactionId, requestUrlType, uuid);
                    if(StringUtils.isBlank(responseInHBase)) {
                        return GlobalResponse.builder(transactionId, null).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.HitInHbase);
                    } else {
                        return GlobalResponse.builder(transactionId, JSON.parseObject(responseInHBase)).addUuid(uuid).addTransactionResult(requestUrlType, TransactionCodeEnum.HitInHbase);
                    }
                }
            }

        }

        String isbilling = "1";
        TransactionCodeEnum transCode = null;
        Stopwatch stopwatch = Stopwatch.createStarted();
        String code = null;
        String msg = null;
        long elapsed = 0;
        boolean charge = false;


        try{

            Map<String,String> applyLoanInfoReqMap = new HashMap<>();
            applyLoanInfoReqMap.put("name", interfaceUploadClient(name));
            applyLoanInfoReqMap.put("pid", interfaceUploadClient(idCard));
            applyLoanInfoReqMap.put("mobile", interfaceUploadClient(mobile));
            applyLoanInfoReqMap.put("queryReason", "1");
            applyLoanInfoReqMap.put("guaranteeType", "1");
            applyLoanInfoReqMap.put("loanPurpose", "1");
            applyLoanInfoReqMap.put("customType", "99");
            applyLoanInfoReqMap.put("applyAmount", "-1");
            applyLoanInfoReqMap.put("loanId", orderNo);

            String resultStr = iHttpService.post(baiHangApplyLoanInfoUrl, getHeader(), applyLoanInfoReqMap);
            System.out.println(resultStr);


        }catch(Exception e){
            log.error("百行征信查询征信报告异常, transactionid: {} , uuid: {} , name: {} , idCard: {} , mobile: {} , orderNo: {} ",
                    transactionId, uuid, name, idCard, mobile, orderNo, e);
        }finally {
            thirdpartyApiMonitorService.create(uuid, requestUrlType, isbilling, msg, (int)elapsed, code);
        }

        log.info("查询百行征信报告结束, transactionId: {} , uuid: {} , name: {} , idCard: {} , mobile: {} , orderNo: {} ,result: {} ,耗时: {} ",
                transactionId, uuid, name, idCard, mobile, orderNo, "", stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        return null;
    }

    public static String interfaceUploadClient(String param) throws Exception{

        InterfaceUploadRequest req = new InterfaceUploadRequest();
        List<String> datas = new ArrayList<String>();
        datas.add(param);
        //设置待加密的原始数据集合
        req.setData(datas);
        BhInterfaceCreditApiClient client = new BhInterfaceCreditApiClient();
        //初始化设置RSA公钥
        client.init(BHRSAUtils.readRSAPublicKey("/baihang/rsa_public_key.pem"));
        //执行加密操作
        InterfaceUploadResponse response = client.execute(req);
        if(response.isSuccess){
            List<String> data = response.getEncryptData();
            return data.get(0);
        }
        throw new Exception();
    }

    public Map<String,String> getHeader(){
        Map<String,String> headerMap = new HashMap<>();
        headerMap.put("Authorization", "Basic "+ Base64.byteArrayToBase64((account+":"+password).getBytes()));
        return headerMap;
    }

}
