package cn.quantgroup.report.job;

import cn.quantgroup.report.constant.BaiHangHistoryConstant;
import cn.quantgroup.report.service.baihang.constant.Constant;
import com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;


/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 量化派助贷模式(非循环贷) -
 *      (贷款申请/放款/还款(逾期)三类实时批量数据)-To百行报送<br>
 *     每日凌晨5点报送 <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.10.25 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Component
public class LoanApplicationManifestHistoryTask {

    private static final Logger log = LoggerFactory.getLogger(LoanApplicationManifestHistoryTask.class);

    @Autowired
    private RedisTemplate<String,String> redisTemplate;


    @Autowired
    private JdbcTemplate xyqbHistoryJdbcTemplate;

    private static AtomicBoolean SYN_Stop = new AtomicBoolean(false);

    @Async
    @Scheduled(cron = "0 17 16 * * ?")//2019.11.14 15:25
    public void startHistoryDateCopy(){
        if(increment()){
            redisTemplate.expire(Constant.XYQB_HISTORY_DAI_REPORT_LOCK_KEY, 10, TimeUnit.SECONDS);

            //将xyqb_i_loan_application_manifest_history表的数据，同步到xyqb_i_loan_a_m_history_bak
            Stopwatch stopwatch = Stopwatch.createStarted();
            //yyyy-MM-dd
            //String startnyr = LocalDateTime.now().plusDays(-1).format(DateTimeFormatter.ISO_DATE);
            //String endnyr = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE);

            log.info("量化派-同步表xyqb_i_loan_application_manifest_history数据开始, newTime: {} ", LocalDateTime.now());

            syn_history_by_CreatedAt();

            syn_plan_by_CreatedAt();

            //syn_historyAndplan_by_id();

            log.info("量化派-同步表xyqb_i_loan_application_manifest_history数据结束, endTime: {}, 耗时: {} ", LocalDateTime.now(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
    }


    public Boolean increment(){
        Long increment = redisTemplate.opsForValue().increment(Constant.XYQB_HISTORY_DAI_REPORT_LOCK_KEY, 1);
        return increment <= 1;
    }


    public void syn_history_by_CreatedAt(){
        LocalDateTime erlyDate = LocalDateTime.parse("2016-08-23T00:00:00");//2016-08-23T16:29:10
        LocalDateTime endDate = LocalDateTime.parse("2019-11-01T00:00:00");//2019-11-11 12:32:08
        int counter = 0;
        while (true) {
            Stopwatch startwatch = Stopwatch.createStarted();

            if (SYN_Stop.get()) {
                log.error("同步xyqb_i_loan_application_manifest_history数据查询STOP, D3_Stop: {} , endTime: {} ", SYN_Stop.get(), erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE));
                break;
            }
            counter++;
            if (erlyDate.plusDays(counter).compareTo(endDate) > 0) {
                break;
            }

            String starTime = erlyDate.plusDays(counter - 1).format(DateTimeFormatter.ISO_DATE);
            String endTime = erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE);
            try {
                String tmp_sql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_HISTORY;
                tmp_sql = tmp_sql.replace("##STARTTIME##",starTime);
                tmp_sql = tmp_sql.replace("##ENDTIME##",endTime);

                int upCount = xyqbHistoryJdbcTemplate.update(tmp_sql);
                log.info("同步xyqb_i_loan_application_manifest_history数据结束,startTime: {} , 耗时:{} , updateCount: {} ", starTime, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms", upCount);

            }catch (Exception e){
                log.error("同步xyqb_i_loan_application_manifest_history数据异常, startTime: {} , endTime: {} , counter: {} ", starTime, endTime,counter, e);
            }
        }
    }

    public void syn_plan_by_CreatedAt(){
        LocalDateTime erlyDate = LocalDateTime.parse("2016-08-23T00:00:00");//2016-08-23T16:29:10
        LocalDateTime endDate = LocalDateTime.parse("2019-11-01T00:00:00");//2019-11-11 12:32:08
        int counter = 0;
        while (true) {
            Stopwatch startwatch = Stopwatch.createStarted();

            if (SYN_Stop.get()) {
                log.error("同步xyqb_i_repayment_plan数据查询STOP, D3_Stop: {} , endTime: {} ", SYN_Stop.get(), erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE));
                break;
            }
            counter++;
            if (erlyDate.plusDays(counter).compareTo(endDate) > 0) {
                break;
            }

            String starTime = erlyDate.plusDays(counter - 1).format(DateTimeFormatter.ISO_DATE);
            String endTime = erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE);
            try {
                String tmp_sql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_PLAN;
                tmp_sql = tmp_sql.replace("##STARTTIME##",starTime);
                tmp_sql = tmp_sql.replace("##ENDTIME##",endTime);

                int upCount = xyqbHistoryJdbcTemplate.update(tmp_sql);
                log.info("同步xyqb_i_repayment_plan数据结束,startTime: {} , 耗时:{} , updateCount: {} ", starTime, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms", upCount);

            }catch (Exception e){
                log.error("同步xyqb_i_repayment_plan数据异常, startTime: {} , endTime: {} , counter: {} ", starTime, endTime,counter, e);
            }
        }
    }


    private boolean syn_history_by_id(long bakMaxId){
        String count_sql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_HISTORY_SYN_COUNT;
        count_sql = count_sql.replace("##BAKMAXID##",""+bakMaxId);

        Integer count = xyqbHistoryJdbcTemplate.queryForObject(count_sql,Integer.class);
        if(count==null){
            log.error("表xyqb_i_loan_application_manifest_history需要同步的count为null.");
            return false;
        }

        String inset_sql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_HISTORY_SYN_DATA;
        inset_sql = inset_sql.replace("##STARTID##",""+bakMaxId);

        if(count.intValue() <= BaiHangHistoryConstant.MAX_COMMIT_COUT){
            Stopwatch startwatch = Stopwatch.createStarted();
            int update = xyqbHistoryJdbcTemplate.update(inset_sql);
            log.info("增量同步xyqb_i_loan_application_manifest_history表结束, bakMaxId: {} , count: {} , 插入条数: {} , 耗时: {} ", bakMaxId, count, update, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms");
            return true;
        }else{

            int page = count.intValue() / BaiHangHistoryConstant.MAX_COMMIT_COUT;
            int mode = count.intValue() % BaiHangHistoryConstant.MAX_COMMIT_COUT;
            if(mode!=0){
                page = page+1;
            }

            int totalUpdate = 0;
            for (int p=0 ; p < page; p++){
                Stopwatch startwatch = Stopwatch.createStarted();
                int limit1 = p * BaiHangHistoryConstant.MAX_COMMIT_COUT;
                int limit2 = (p+1) * BaiHangHistoryConstant.MAX_COMMIT_COUT;
                if( limit2 > count.intValue()){
                    limit2 = count.intValue();
                }
                String tmpInsertSql = inset_sql + (" ORDER BY b.id ASC LIMIT "+limit1+", "+limit2+" ;");

                int update = xyqbHistoryJdbcTemplate.update(tmpInsertSql);

                totalUpdate+=update;
                log.info("增量同步xyqb_i_loan_application_manifest_history表页数page["+p+"], limit1: {} , limit2: {} , 插入条数: {} ", limit1, limit2, update, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms");
            }
            log.info("增量同步xyqb_i_loan_application_manifest_history表结束, bakMaxId: {} , count: {} , 总插入条数: {} , page: {} , mode: {} ", bakMaxId, count, totalUpdate, page, mode);


            if(totalUpdate==count){
                return true;
            }else{
                return false;
            }
        }
    }


    private boolean syn_plan_by_id(long bakMaxId){
        String count_sql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_PLAN_SYN_COUNT;
        count_sql = count_sql.replace("##BAKMAXID##",""+bakMaxId);

        Integer count = xyqbHistoryJdbcTemplate.queryForObject(count_sql,Integer.class);
        if(count==null){
            log.error("表xyqb_i_repayment_plan需要同步的count为null.");
            return false;
        }

        String inset_sql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_PLAN_SYN_DATA;
        inset_sql = inset_sql.replace("##STARTID##",""+bakMaxId);

        if(count.intValue() <= BaiHangHistoryConstant.MAX_COMMIT_COUT){
            Stopwatch startwatch = Stopwatch.createStarted();
            int update = xyqbHistoryJdbcTemplate.update(inset_sql);
            log.info("增量同步xyqb_i_repayment_plan表结束, bakMaxId: {} , count: {} , 插入条数: {} , 耗时: {} ", bakMaxId, count, update, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms");
            return true;
        }else{

            int page = count.intValue() / BaiHangHistoryConstant.MAX_COMMIT_COUT;
            int mode = count.intValue() % BaiHangHistoryConstant.MAX_COMMIT_COUT;
            if(mode!=0){
                page = page+1;
            }

            int totalUpdate = 0;
            for (int p=0 ; p < page; p++){
                Stopwatch startwatch = Stopwatch.createStarted();
                int limit1 = p * BaiHangHistoryConstant.MAX_COMMIT_COUT;
                int limit2 = (p+1) * BaiHangHistoryConstant.MAX_COMMIT_COUT;
                if( limit2 > count.intValue()){
                    limit2 = count.intValue();
                }
                String tmpInsertSql = inset_sql + (" ORDER BY b.id ASC LIMIT "+limit1+", "+limit2+" ;");

                int update = xyqbHistoryJdbcTemplate.update(tmpInsertSql);

                totalUpdate+=update;
                log.info("增量同步xyqb_i_repayment_plan表页数page["+p+"], limit1: {} , limit2: {} , 插入条数: {} ", limit1, limit2, update, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms");
            }
            log.info("增量同步xyqb_i_repayment_plan表结束, bakMaxId: {} , count: {} , 总插入条数: {} , page: {} , mode: {} ", bakMaxId, count, totalUpdate, page, mode);


            if(totalUpdate==count){
                return true;
            }else{
                return false;
            }
        }
    }

    public boolean syn_historyAndplan_by_id(){
        Stopwatch startwatch = Stopwatch.createStarted();
        try {
            String tmp_sql = BaiHangHistoryConstant.SQL_COMMONE_TEMPLATE_HISTORY_BAK_MAX_ID;
            Long bakMaxId = xyqbHistoryJdbcTemplate.queryForObject(tmp_sql,Long.class);
            if(bakMaxId!=null && bakMaxId.longValue() >= 0L){

                //-------------------------------
               boolean table_history = syn_history_by_id(bakMaxId.longValue());
               if(table_history){

                   boolean table_plan = syn_plan_by_id(bakMaxId.longValue());
                   if(table_plan){
                       log.info("增量同步history&plan表数据结束, nowTime: {} ", LocalDateTime.now(), startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms");
                       return true;
                   }else{
                       log.error("增量同步[xyqb_i_repayment_plan_bak]表数据失败,请尽快处理! nowTime: {} , bakMaxId: {} ",LocalDateTime.now(), bakMaxId);
                   }

               }else{
                   log.error("增量同步[xyqb_i_loan_a_m_history_bak]表数据失败,请尽快处理! nowTime: {} , bakMaxId: {} ",LocalDateTime.now(), bakMaxId);
               }
               //-------------------------------

            }else {
                log.error("增量同步xyqb_i_repayment_plan数据-历史id为空,停止同步! nowTime: {} , bakMaxId: {} ",LocalDateTime.now(), bakMaxId);
            }
        }catch (Exception e){
            log.error("增量同步history&plan表数据异常, nowTime: {} ", LocalDateTime.now(), e);
        }

        return false;
    }

}
