package cn.quantgroup.report.utils;


import org.apache.commons.lang.StringUtils;

public class StringUtil {

    private static final char UNDERLINE = '_';

    public static String shortPrintLog(String log, int length){
        if(StringUtils.isBlank(log)){
            return log;
        }
        return log.substring(0, Math.min(log.length(), length));
    }

    public static String shortPrintLog(String log){
        return shortPrintLog(log, 500);
    }

    /**
     * 描述:  下划线 转 驼峰   <br/>
     * 参数: [param]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.18  <br/>
     */
    public static String underlineToCamel(String param){
        if (param==null||"".equals(param.trim())){
            return "";
        }
        int len=param.length();
        StringBuilder sb=new StringBuilder(len);
        for (int i = 0; i < len; i++) {
            char c = Character.toLowerCase(param.charAt(i));
            if (c == UNDERLINE){
                if (++i<len){
                    sb.append(Character.toUpperCase(param.charAt(i)));
                }
            }else{
                sb.append(c);
            }
        }
        return sb.toString();
    }

    /**
     * 描述:   下划线转 首字母大写的缩写  <br/>
     * 参数: [param]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.18  <br/>
     */
    public static String underlineToFirstChar(String param){
        if (param==null||"".equals(param.trim())){
            return "";
        }
        if(param.indexOf(String.valueOf(UNDERLINE))==-1){
            return param;
        }
        StringBuffer buff = new StringBuffer();
        String[] tmps = param.split(String.valueOf(UNDERLINE));
        for(int i=0;i<tmps.length;i++){
            if(tmps[i].length()>0){
                buff.append(tmps[i].substring(0,1).toUpperCase());
            }
        };
        return buff.toString();
    }


    /**
     * 描述:  下划线转 首字母大写的缩写（木槿科技返回字段）   <br/>
     * 参数: [param]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.18  <br/>
     */
    public static final String muJinunderlineToFirstChar(String param){
        if("idRiskList".equals(param)){
            return "IRL";
        }else if("phoneRiskList".equals(param)){
            return "PRL";
        }else{
            return  underlineToFirstChar(param);
        }
    }

    public static double getLenOfStr(String s) {
        double valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        //一个汉字或日韩文长度为1,英文字符长度为0.5
        for (int i = 0; i < s.length(); i++) {
            String temp = s.substring(i,i + 1);
            if (temp.matches(chinese)) {
                valueLength += 1;
            } else {
                valueLength += 0.5;
            }
        }
        return Math.ceil(valueLength);
    }

}
