package cn.quantgroup.report.config.datasource.tidbrisk;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: tidb中call_record日志表 <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.12.30 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Import(TidbRiskDatasourceProperties.class)
@Configuration
@Slf4j
@MapperScan(basePackages = TidbRiskDataSourceConfig.PACKAGE, sqlSessionFactoryRef = "tidbRiskSqlSessionFactory")
public class TidbRiskDataSourceConfig {

  static final String PACKAGE = "cn.quantgroup.report.mapper.tidbrisk";

  //@Value("${tidb.risk_datasource.mapper-locations}")
  private String mapperLocations="classpath:cn/quantgroup/report/mapper/tidbrisk/*.xml";//resources *.xml

  //@Value("${tidb.risk_datasource.type-aliases-package}")
  private String typeAliasesPackage="cn.quantgroup.report.domain.tidbrisk";//实体pojo

  @Value("${config-location}")
  private String configLocation;


  @Autowired
  private TidbRiskDatasourceProperties tidbRiskDatasourceProperties;

  @Bean(name = "tidbRiskDataSource")
  public DataSource tidbRiskDataSource() {
    HikariConfig config = new HikariConfig();
    log.info("tidb.risk_datasource数据库地址:{}",tidbRiskDatasourceProperties.getTidbRiskDatasourceJdbcUrl());
    config.setJdbcUrl(tidbRiskDatasourceProperties.getTidbRiskDatasourceJdbcUrl());
    config.setPassword(tidbRiskDatasourceProperties.getTidbRiskDatasourcePassword());
    config.setUsername(tidbRiskDatasourceProperties.getTidbRiskDatasourceUsername());
    config.setMaximumPoolSize(tidbRiskDatasourceProperties.getMaxPoolSize());
    config.setMinimumIdle(tidbRiskDatasourceProperties.getMinPoolSize());
    config.addDataSourceProperty("cachePrepStmts", "true");
    config.addDataSourceProperty("prepStmtCacheSize", "250");
    config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
    return new HikariDataSource(config);
  }

  @Bean(name = "tidbRiskTransactionManager")
  public DataSourceTransactionManager tidbRiskTransactionManager(@Qualifier("tidbRiskDataSource") DataSource dataSource) {
    return new DataSourceTransactionManager(dataSource);
  }

  @Bean(name = "tidbRiskSqlSessionFactory")
  public SqlSessionFactory tidbRiskSqlSessionFactory(@Qualifier("tidbRiskDataSource") DataSource tidbRiskDataSource) throws Exception {
    final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
    sessionFactory.setDataSource(tidbRiskDataSource);
    sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
      .getResources(mapperLocations));
    sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
    sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver()
      .getResource(configLocation));
    return sessionFactory.getObject();
  }

  @Bean(name = "tidbRiskSqlSessionTemplate")
  public SqlSessionTemplate tidbRiskSqlSessionTemplate(@Qualifier("tidbRiskSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
    return new SqlSessionTemplate(sqlSessionFactory);
  }

  @Bean(name = "tidbRiskJdbcTemplate")
  public JdbcTemplate tidbRiskJdbcTemplate(@Qualifier("tidbRiskDataSource") DataSource dataSource) {
    return new JdbcTemplate(dataSource);
  }

}
