package cn.quantgroup.report.interceptor;

import cn.quantgroup.report.service.thirdpartymonitor.HBaseConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HBaseHandlerInterceptorAdapter extends HandlerInterceptorAdapter {
  public static final String READ_FROM_HBASE_FIRST = "readFromHBaseFirst";

  public boolean preHandle(HttpServletRequest arg0, HttpServletResponse arg1, Object arg2) throws Exception {
    String readFromHBaseFirst = arg0.getParameter(READ_FROM_HBASE_FIRST);
    if (readFromHBaseFirst != null && StringUtils.equalsIgnoreCase("false", readFromHBaseFirst)) {
      HBaseConfig.disableReadHBaseFirst();
    }
    return true;
  }

  /**
   * 在controller执行之后的DispatcherServlet之后执行
   */
  public void postHandle(HttpServletRequest arg0, HttpServletResponse arg1, Object arg2, ModelAndView arg3)
    throws Exception {
  }

  /**
   * 在页面渲染完成返回给客户端之前执行
   */
  public void afterCompletion(HttpServletRequest arg0, HttpServletResponse arg1, Object arg2, Exception arg3)
    throws Exception {
    HBaseConfig.enableReadHBaseFirst();
  }

}
