package cn.quantgroup.report.service.interceptor;

import cn.quantgroup.report.utils.ConverterCacheUtils;
import com.alibaba.fastjson.JSONObject;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

import java.io.IOException;

public class HeaderInterceptor implements Interceptor {
  private JSONObject defaultParamMap;

  public HeaderInterceptor(Object object) {
    defaultParamMap = ConverterCacheUtils.convertedFromObject(object);
  }

  @Override
  public Response intercept(Chain chain) throws IOException {
    Request oldRequest = chain.request();
    if (defaultParamMap.isEmpty()) {
      return chain.proceed(oldRequest);
    }
    // 添加新的参数
    HttpUrl.Builder authorizedUrlBuilder = oldRequest.url()
      .newBuilder()
      .scheme(oldRequest.url().scheme())
      .host(oldRequest.url().host());

    Request.Builder newBuilder = oldRequest.newBuilder()
      .method(oldRequest.method(), oldRequest.body())
      .headers(oldRequest.headers());
    defaultParamMap.forEach((k, v) -> {
      newBuilder.header(k, v.toString());
    });
    // 新的请求
    Request newRequest = newBuilder.url(authorizedUrlBuilder.build())
      .build();

    return chain.proceed(newRequest);
  }
}