CREATE TABLE `intelli_credit_request_event` (
  `id`               BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `loan_id`          BIGINT              NOT NULL,
  `time_created`     DATETIME,
  `http_code`        INT(11),
  `response_message` VARCHAR(512),
  `mills`            INT(11),
  PRIMARY KEY (`id`),
  KEY `index__loan_id_and_http_code` (`loan_id`, `http_code`)
);
CREATE TABLE `intelli_credit_loan_issue` (
  `id`                   BIGINT(20) UNSIGNED NOT NULL            PRIMARY KEY              AUTO_INCREMENT,
  `name`                 VARCHAR(512),
  `pid`                  VARCHAR(512),
  `mobile`               VARCHAR(512),
  `loan_type`            VARCHAR(512),
  `account_open_date`    BIGINT              NOT NULL                                     DEFAULT 0,
  `apply_date`           BIGINT              NOT NULL                                     DEFAULT 0,
  `issue_date`           BIGINT              NOT NULL                                     DEFAULT 0,
  `loan_amount`          DECIMAL(10, 2)      NOT NULL                                     DEFAULT 0,
  `loan_id`              BIGINT              NOT NULL,
  `total_term`           INT(11),
  `first_repayment_date` BIGINT,
  `term_period`          INT(11),
  `plan_count`           INT(11),
  `status`               TINYINT             NOT NULL                                     DEFAULT 0,
  `device`               TEXT,
  `time_created`         DATETIME,
  UNIQUE KEY `unique_index__loan_id` (`loan_id`)
);

CREATE TABLE `intelli_credit_loan_trace` (
  `id`                    BIGINT(20) UNSIGNED NOT NULL            PRIMARY KEY              AUTO_INCREMENT,
  `loan_id`               BIGINT              NOT NULL,
  `repayment_plan_id`     BIGINT              NOT NULL,
  `term_no`               INT(11),
  `term_status`           VARCHAR(1),
  `target_repayment_date` BIGINT              NOT NULL                                     DEFAULT 0,
  `real_repayment_date`   BIGINT              NOT NULL                                     DEFAULT 0,
  `target_repayment`      DECIMAL(10, 2)      NOT NULL                                     DEFAULT 0,
  `real_repayment`        DECIMAL(10, 2)      NOT NULL                                     DEFAULT 0,
  `status_confirm_at`     BIGINT              NOT NULL                                     DEFAULT 0,
  `overdue_status`        VARCHAR(1),
  `status`                TINYINT             NOT NULL                                     DEFAULT 0,
  UNIQUE KEY `unique_index__loan_id_and_term_no` (`loan_id`, `term_no`),
  KEY `index__status_and_repayment_plan_id` (`status`, `repayment_plan_id`)
);