package cn.quantgroup.report.controller.external;

import cn.quantgroup.report.service.repair.RepairService;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.concurrent.TimeUnit;

/**
 * @author jian.zheng
 * @date 2021/3/2 - 18:43
 **/
@Slf4j
@RestController
@RequestMapping("/manualtool/zhudainew")
public class RepairController {


    @Autowired
    RepairService repairService;
    /**
     * 修复数据
     * pageNo 从0开始
     */
    @RequestMapping("/repair")
    public String mainLoanInfoSend(int startPage){
        try{
            repairService.doRepair(startPage);
            return "数据开始补报";
        }catch(Exception e){
            log.error("数据补报出现异常", e);
            return "数据补报出现异常";
        }
    }

}
