package cn.quantgroup.report.service.usersdk;

import cn.quantgroup.report.domain.sdk.SdkUser;
import cn.quantgroup.report.domain.xyqbuser.User;
import cn.quantgroup.report.domain.xyqbuser.UserDetail;

public interface IUserCenterService {
	
	/**
	 * 根据手机号查用户
	 * @param phoneNo
	 * @return
	 */
	public SdkUser getSdkUserByPhoneNo(String phoneNo);
	/**
	 * 根据uuid查用户
	 * @param uuid
	 * @return
	 */
	public SdkUser getSdkUserByUuid(String uuid);

    public User getSdkUserByUserId(String userId);

    public UserDetail getSdkUserDetailByUserId(Long userId);

    public Long getUserIdByIdentityNumberAndName(String identityNumber, String name);
    public Long getUserIdByIdentityNumber(String identityNumber);

    public String getUuidByIdentityNumber(String identityNumber);
    public String getUuidByPhoneNumber(String phoneNumber);

    public SdkUser getUserFullInfoByUuid(String uuid);

}
