/**
 * 
 */
package cn.quantgroup.report.config.aop;

import com.google.common.base.Joiner;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;

/**
 * 对数据源请求加锁，不包含transactionId（第一个入参）,  如：method(transactionId, a, b), 锁 key 为 qry_lock_a_b
 */
@Aspect
@Component
public class DistributedLockAspect {


	private static final Logger LOGGER = LoggerFactory.getLogger(DistributedLockAspect.class);

	private static final String USER_LOCK = "qry_lock_";

	@Autowired
	private RedisTemplate redisTemplate;

    @Pointcut("@annotation(cn.quantgroup.report.config.aop.DistributedLock)")
    private void userQryPointCut() {
    }

    @Around("userQryPointCut()")
    public Object process(ProceedingJoinPoint point) throws Throwable {
    	String key = null;
    	Object proceed = null;
    	try{
			String methodName = point.getSignature().getName();
			Object[] args = point.getArgs();
			if(args.length <= 1){
				LOGGER.info("切面获取参数问题, method: {}, args: {}", methodName, args);
				proceed = point.proceed();
				return proceed;
			}
			//不包含transactionID的其他参数
			Object[] newarr= Arrays.copyOfRange(args, 1, args.length);
			key = Joiner.on("_").useForNull("!").join(newarr);
			key = new StringBuffer().append(USER_LOCK).append(methodName).append("_").append(key).toString();
			boolean flag = true;
			int count = 1;
			while(!setIfAbsent(key, "1", 3, TimeUnit.SECONDS)){
				if(flag) {
					LOGGER.info("查询命中锁, key: {}, args: {}", key, args);
					flag =false;
				}
	    		Thread.sleep(100);
				if(count>30){
					redisTemplate.delete(key);
				}
				count++;

	    	}
	    	proceed = point.proceed();
    	}catch(Exception e){
    		proceed = point.proceed();
    	}finally{
    		if(key != null) {
				redisTemplate.delete(key);
			}
    	}
    	return proceed;
    }

	public boolean setIfAbsent(String key,String value,long time, TimeUnit timeUnit) {
		try{
			Boolean setIfAbsent = redisTemplate.opsForValue().setIfAbsent(key, value);
			if(setIfAbsent)
				redisTemplate.expire(key, time, timeUnit);
			return setIfAbsent;
		}catch(Exception e){
			LOGGER.error("REDIS原子性操作异常!",e);
		}
		return true;
	}
    
}
