package cn.quantgroup.report.service.baihang.util;

import cn.quantgroup.report.service.baihang.response.FileUploadResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Random;


public class TuoMinUtils {



    private static char getRandomChar() {
        String str = "";
        int hightPos; //
        int lowPos;
        Random random = new Random();
        hightPos = (176 + Math.abs(random.nextInt(39)));
        lowPos = (161 + Math.abs(random.nextInt(93)));
        byte[] b = new byte[2];
        b[0] = (Integer.valueOf(hightPos)).byteValue();
        b[1] = (Integer.valueOf(lowPos)).byteValue();
        try {
            str = new String(b, "GBK");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.out.println("错误");
        }
        return str.charAt(0);
    }

    private static String getRandomNum(int length) {
        StringBuffer buff = new StringBuffer();
        Random random = new Random();
        for (int i=0;i<length;i++){
            // 返回一个0~(指定数-1)之间的随机值
            int ran = random.nextInt(10);
            buff.append(ran);
        }
        return buff.toString();
    }

    public static String random_name(String name) {
        /*姓名脱敏
        保证为汉字，如张三丰脱敏为张无忌、张艺兴，均符合要求。
        避免使用张某、赵某等，容易出现编码校验失败问题。*/
        return name.substring(0,1)+getRandomChar()+getRandomChar();
    }


    public static String random_idcard(String idcard) {
        /*身份证脱敏
        需满足以下条件：
        1.身份证前两位数字（即省份代码）需为以下34个数字之一：11,12,13,14,15,21,22,23,31,32,33,34,35,36,37,41,42,43,44,45,46,50,51,52,53,54,61,62,63,64,65,71,81,82
        2.身份证中的年月日需为现实中存在的日期
        如360822198305022623脱敏：*/
        return idcard.substring(0,2) + getRandomNum(4) + idcard.substring(6,14) + getRandomNum(4);
    }

    public static String random_mobile(String mobile) {
        return mobile.substring(0,3) + getRandomNum(4) + mobile.substring(7,11);
    }



    public static void main(String[] args) {
        //System.out.println(random_name("郝彦辉"));

       // System.out.println(random_idcard("622726198911100236"));

       // System.out.println(random_mobile("18010105506"));

        String readAddr = "E:\\桌面_工作\\数据备份\\201911061315贷款申请关联用户.json";
        String writeAddr = "E:\\桌面_工作\\数据备份\\201911061315用户脱敏.txt";
        try {
            long log_stUtc = System.currentTimeMillis();
            String sourceStr = FileUtils.readFileToString(new File(readAddr), "utf-8");
            JSONObject sourceJson = JSON.parseObject(sourceStr);
            JSONArray recordsJsonArr = sourceJson.getJSONArray("RECORDS");
            System.out.println("总条数:"+recordsJsonArr.size());
            for (int i = 0; i < recordsJsonArr.size(); i++) {
                System.out.println("第:"+i);
                JSONObject jsonObj = recordsJsonArr.getJSONObject(i);
                try {
                    String name = jsonObj.getString("name");
                    String pid = jsonObj.getString("pid");
                    String mobile = jsonObj.getString("mobile");

                    StringBuffer out = new StringBuffer();
                    out.append(pid);
                    out.append("=");
                    out.append(random_idcard(pid));
                    out.append(",");
                    out.append(random_mobile(mobile));
                    out.append(",");
                    out.append(random_name(name));
                    out.append("\n");

                    FileUtils.write(new File(writeAddr), out , "utf-8", true);
                }catch (Exception e){
                    System.err.println("Error 第:"+i+",pid="+jsonObj.getString("pid"));
                }
            }
            System.out.println("脱敏结束， 耗时: "+((System.currentTimeMillis()-log_stUtc)/1000)+".s");
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

}
