package cn.quantgroup.report.utils.http;

import cn.quantgroup.report.error.QGException;
import cn.quantgroup.report.error.QGExceptionType;
import cn.quantgroup.report.response.RiskHttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.*;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.*;
import java.util.zip.GZIPOutputStream;

/**
 * Created by suh on 2017/12/18.
 */
@Slf4j
public class HttpRequestUtil {
    private static PoolingHttpClientConnectionManager connMgr;
    private static RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(10000).build();
    private static CloseableHttpClient httpClient=null;
    private final static Object syncLock = new Object();

    /** 针对中诚信手机号实名验证 调用频繁 Read timed out问题 */
    private static RequestConfig requestConfig2 = RequestConfig.custom().setConnectTimeout(6000).setSocketTimeout(15000).build();
    private static CloseableHttpClient httpClient2 = null;



    static {
        try {
            //添加对https的支持，该sslContext没有加载客户端证书
            // 如果需要加载客户端证书，请使用如下sslContext,其中KEYSTORE_FILE和KEYSTORE_PASSWORD分别是你的证书路径和证书密码
            //KeyStore keyStore  =  KeyStore.getInstance(KeyStore.getDefaultType()
            //FileInputStream instream =   new FileInputStream(new File(KEYSTORE_FILE));
            //keyStore.load(instream, KEYSTORE_PASSWORD.toCharArray());
            //SSLContext sslContext = SSLContexts.custom().loadKeyMaterial(keyStore,KEYSTORE_PASSWORD.toCharArray())
            // .loadTrustMaterial(null, new TrustSelfSignedStrategy())
            //.build();
            SSLContext sslContext = SSLContexts.custom()
                    .loadTrustMaterial(null, new TrustSelfSignedStrategy())
                    .build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext,SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            Registry<ConnectionSocketFactory> socketFactoryRegistry = RegistryBuilder.<ConnectionSocketFactory>create()
                    .register("https", sslsf)
                    .register("http", PlainConnectionSocketFactory.getSocketFactory())
                    .build();
            connMgr = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            connMgr.setMaxTotal(50);
            connMgr.setDefaultMaxPerRoute(25);
        }catch (Exception e){
            log.warn("httpUtils init get exception:",e);
        }
    }

    public static CloseableHttpClient getHttpClient(){
        if(httpClient == null){
            synchronized (syncLock){
                if(httpClient == null){
                    httpClient =HttpClients.custom().setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
                }
            }
        }
        return httpClient;
    }

    public static CloseableHttpClient getHttpClient2(){
        if(httpClient2 == null){
            synchronized (syncLock){
                if(httpClient2 == null){
                    httpClient2 =HttpClients.custom().setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig2).build();
                }
            }
        }
        return httpClient2;
    }

    /**
     * 发送 GET 请求（HTTP），不带输入数据
     *
     * @param url
     * @return
     */
    public static RiskHttpResponse doGet(String url) {
        return doGet(url, new HashMap<String, Object>());
    }
    /**
     * 发送 GET 请求（HTTP），K-V形式
     *
     * @param url
     * @param params
     * @return
     */
    public static RiskHttpResponse doGet(String url, Map<String, Object> params) {
        String apiUrl = url;
        StringBuffer param = new StringBuffer();
        int i = 0;
        for (String key : params.keySet()) {
            if (i == 0)
                param.append("?");
            else
                param.append("&");
            param.append(key).append("=").append(params.get(key));
            i++;
        }
        apiUrl += param;
        //CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();

        //modify 2019.09.18
        //httpClient = getHttpClient();
        long startUtc = System.currentTimeMillis();
        httpClient2 = getHttpClient();
        HttpGet httpGet = new HttpGet(apiUrl);
        try {
            HttpResponse response = httpClient2.execute(httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            JSONObject jsonObject = JSONObject.parseObject(EntityUtils.toString(entity));
            EntityUtils.consume(entity);
            return new RiskHttpResponse(jsonObject,statusCode);
        } catch (Exception e){
            long endtUtc = System.currentTimeMillis();
            log.error("apiUrl: "+apiUrl+"请求失败, cost: "+(endtUtc-startUtc)+".ms ", e);
//            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_FAIL,e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url:"+apiUrl);
        }finally {
            httpGet.releaseConnection();
        }
    }

    /**
     * 发送 POST 请求（HTTP），不带输入数据
     *
     * @param apiUrl
     * @return
     */
    public static RiskHttpResponse doPost(String apiUrl) {
        return doPost(apiUrl, new HashMap<String, Object>());
    }

    /**
     * 发送 POST 请求（HTTP），K-V形式
     *
     * @param apiUrl API接口URL
     * @param params 参数map
     * @return
     */
    public static RiskHttpResponse doPost(String apiUrl, Map<String, Object> params) {
        //CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
        httpClient = getHttpClient();
        HttpPost httpPost = new HttpPost(apiUrl);
        try {
            List<NameValuePair> pairList = new ArrayList<>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                NameValuePair pair = new BasicNameValuePair(entry.getKey(), entry
                        .getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            HttpResponse response = httpClient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            JSONObject jsonObject = JSONObject.parseObject(EntityUtils.toString(entity));
            EntityUtils.consume(entity);
            return new RiskHttpResponse(jsonObject,statusCode);
        } catch (IOException e) {
          log.error("apiUrl: "+apiUrl+"请求失败", e);
//          throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_FAIL,e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url:"+apiUrl);
        } finally {
            httpPost.releaseConnection();
        }
    }

    /**
     * 发送 POST 请求（HTTP），JSON形式
     *
     * @param apiUrl
     * @param json   json对象
     * @return
     */
    public static RiskHttpResponse doPost(String apiUrl, JSONObject json) {
        httpClient = getHttpClient();
        // CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
        HttpPost httpPost = new HttpPost(apiUrl);
        try {
            httpPost.setConfig(requestConfig);
            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");//解决中文乱码问题
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity(stringEntity);
            HttpResponse response = httpClient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            JSONObject jsonObject = JSONObject.parseObject(EntityUtils.toString(entity));
            EntityUtils.consume(entity);
            return new RiskHttpResponse(jsonObject,statusCode);
        } catch (IOException e) {
            log.error("apiUrl: "+apiUrl+"请求失败", e);
//            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_FAIL,e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url:"+apiUrl);
        } finally {
            httpPost.releaseConnection();
        }
    }

    public static RiskHttpResponse doGzipHttp(String url, JSONObject jsonObject) {
        httpClient = getHttpClient();
        //CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();

        HttpPost httpPost = new HttpPost(url);

        httpPost.setHeader("Content-Type", "text/plain");
        httpPost.setHeader("Content-Encoding", "gzip");

        try {
            String message = JSON.toJSONString(jsonObject);

            ByteArrayOutputStream originalContent = new ByteArrayOutputStream();

            originalContent.write(message.getBytes(Charset.forName("UTF-8")));

            ByteArrayOutputStream baos = new ByteArrayOutputStream();

            GZIPOutputStream gzipOut = new GZIPOutputStream(baos);

            originalContent.writeTo(gzipOut);

            gzipOut.finish();

            httpPost.setEntity(new ByteArrayEntity(baos.toByteArray()));

            HttpResponse response = httpClient.execute(httpPost);

            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            JSONObject object = JSONObject.parseObject(EntityUtils.toString(entity));
            EntityUtils.consume(entity);
            return new RiskHttpResponse(object, statusCode);
        } catch (Exception e) {
            log.error("apiUrl: "+url+"请求失败", e);
//            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_FAIL,e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url:"+url);
        } finally {
            httpPost.releaseConnection();
        }

    }
    public static RiskHttpResponse doGzipPost(String url,JSONObject jsonObject) {
        try {
            URL parsedUrl = new URL(url);
            HttpURLConnection connection = (HttpURLConnection) parsedUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.addRequestProperty("Content-Type", "text/plain");
            connection.addRequestProperty("Content-Encoding","gzip");
            connection.setDoOutput(true);
            String bodyStr = JSON.toJSONString(jsonObject);
            byte[] body = bodyStr.getBytes("UTF-8");
            if (body != null) {
                DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                GZIPOutputStream gzip = new GZIPOutputStream(out);
                gzip.write(body);
                gzip.finish();
                gzip.close();
            }
            connection.connect();
            RiskHttpResponse response = new RiskHttpResponse();
            int responseCode = connection.getResponseCode();
            response.setCode(responseCode);
            if (responseCode != HttpURLConnection.HTTP_OK) {
                String responseData = getContent(connection.getErrorStream());
                response.setJsonObject(JSONObject.parseObject(responseData));
            } else {
                String responseData = getContent(connection.getInputStream());
                response.setJsonObject(JSONObject.parseObject(responseData));
            }
            return response;
        } catch (Exception e) {
            log.error("apiUrl: "+url+"请求失败", e);
//            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_FAIL,e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url:"+url);
        }
    }

    private static String getContent(InputStream in) {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(in, "utf-8"));
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (br != null)
                    br.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    /**
     * 发送 SSL POST 请求（HTTPS），K-V形式
     *
     * @param apiUrl API接口URL
     * @param params 参数map
     * @return
     */
    public static String doPostSSL(String apiUrl, Map<String, Object> params) {
        httpClient = getHttpClient();
        // CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        String httpStr = null;

        try {
            httpPost.setConfig(requestConfig);
            List<NameValuePair> pairList = new ArrayList<NameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                NameValuePair pair = new BasicNameValuePair(entry.getKey(), entry
                        .getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("utf-8")));
            response = httpClient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                return null;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return null;
            }
            httpStr = EntityUtils.toString(entity, "utf-8");
        } catch (Exception e) {
            log.error("apiUrl: "+apiUrl+"请求失败", e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url:"+apiUrl);
        } finally {
            if (response != null) {
                try {
                    EntityUtils.consume(response.getEntity());
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }


    /**
     * 发送 SSL POST 请求（HTTPS），K-V形式
     *
     * @param apiUrl API接口URL
     * @param params 参数map
     * @return
     */
    public static String doPostSSL(String apiUrl, Map<String, String> headers, Map<String, String> params) {
        httpClient = getHttpClient();
        // CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        String httpStr = null;

        try {
            headers.forEach(httpPost::addHeader);
            httpPost.setConfig(requestConfig);
            StringBuilder sb = new StringBuilder("{");
            params.forEach((a, b) -> {
                sb.append("\"" + a + "\"" + ":\"" + b + "\",");
            });
            String body = sb.substring(0, sb.length() - 1) + "}";
            httpPost.setEntity(new StringEntity(body));
            response = httpClient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
//            if (statusCode != HttpStatus.SC_OK) {
//                return null;
//            }
            HttpEntity entity = response.getEntity();
//            if (entity == null) {
//                return null;
//            }
            httpStr = EntityUtils.toString(entity, "utf-8");
        } catch (Exception e) {
            log.error("apiUrl: "+apiUrl+"请求失败", e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url:"+apiUrl);
        } finally {
            if (response != null) {
                try {
                    EntityUtils.consume(response.getEntity());
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /**
     * 发送 SSL POST 请求（HTTPS），JSON形式
     *
     * @param apiUrl API接口URL
     * @param json   JSON对象
     * @return
     */
    public static String doPostSSL(String apiUrl, JSONObject json) {
        httpClient = getHttpClient();
        // CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory(createSSLConnSocketFactory()).setConnectionManager(connMgr).setDefaultRequestConfig(requestConfig).build();
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        String httpStr = null;

        try {
            httpPost.setConfig(requestConfig);
            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");//解决中文乱码问题
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity(stringEntity);
            response = httpClient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                return null;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return null;
            }
            httpStr = EntityUtils.toString(entity, "utf-8");
        } catch (Exception e) {
            log.error("apiUrl: "+apiUrl+"请求失败", e);
//            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_FAIL,e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url:"+apiUrl);
        } finally {
            if (response != null) {
                try {
                    EntityUtils.consume(response.getEntity());
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /**
     * 创建SSL安全连接
     *
     * @return
     */
    private static SSLConnectionSocketFactory createSSLConnSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy() {

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier() {

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }

                @Override
                public void verify(String host, SSLSocket ssl) throws IOException {
                }

                @Override
                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                @Override
                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }
            });
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return sslsf;
    }

    /**
     * 描述: FaceID风控服务-多头API post请求调用  <br/>
     * 参数: [apiUrl, textMap]  <br/>
     * 返回值: java.util.Map<java.lang.String,java.lang.String>  <br/>
     *    responseCode：http的返回code； content：返回的结果 <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.11  <br/>
     */
    public static Map<String,String> doRiskInfoVerifyPost(String apiUrl, Map<String, String> textMap, String log_urlType) {
        Map<String,String> resultMap = new HashMap<String,String>();
        HttpURLConnection conn = null;
        String BOUNDARY = "-----------12345654321-------------";
        try {
            // 设置请求参数
            URL url = new URL(apiUrl);
            conn = (HttpURLConnection) url.openConnection();
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("User-Agent","Mozilla/5.0 (Windows; U; Windows NT 6.1; zh-CN; rv:1.9.2.6)");
            conn.setRequestProperty("Content-Type","multipart/form-data; boundary=" + BOUNDARY);
            conn.setRequestProperty("Charset", "UTF-8");
            OutputStream out = new DataOutputStream(conn.getOutputStream());
            // 对File 和 String 集合进行判空
            if (textMap != null) {
                StringBuffer strBuf = new StringBuffer();
                Iterator iter = textMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry) iter.next();
                    String inputName = (String) entry.getKey();
                    String inputValue = (String) entry.getValue();
                    if (inputValue == null) {
                        continue;
                    }
                    strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\""+ inputName + "\"\r\n\r\n");
                    strBuf.append(inputValue);
                }
                out.write(strBuf.toString().getBytes("UTF-8"));
            }
            byte[] endData = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
            out.write(endData);
            out.flush();
            out.close();

            int responseCode = conn.getResponseCode();
            String res = "";
            if (responseCode == 200) {
                // 读取正确返回信息
                StringBuffer strBuf = new StringBuffer();
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    strBuf.append(line).append("\n");
                }
                res = strBuf.toString();
                reader.close();
                reader = null;
            } else {
                // 读取错误返回信息
                StringBuffer error = new StringBuffer();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                String line1 = null;
                while ((line1 = bufferedReader.readLine()) != null) {
                    error.append(line1).append("\n");
                }
                res = error.toString();
                bufferedReader.close();
                bufferedReader = null;
            }
            //log.info("responseCode:"+responseCode+",msg="+res);
            resultMap.put("responseCode",""+responseCode);
            resultMap.put("content",res);
        } catch (Exception e) {
            log.error("httpRequest urlType="+log_urlType+", apiUrl: "+apiUrl+"发送POST请求失败", e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, log_urlType+":"+e.toString());
        } finally {
            // 关闭流
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return resultMap;
    }

    /**
     * 描述: 木槿科技借贷风险名单查询 get请求 <br/>
     * 参数: [inUrl] <br/>
     * 返回值: java.lang.String <br/>
     * 创建人: yanhui.Hao <br/>
     * 创建时间: 2019.09.17 <br/>
     */
    public static String muJinReadByGet(String apiUrl,String log_urlType) {
        StringBuffer sbf = new StringBuffer();
        String strRead = null;
        // 模拟浏览器
        String userAgent = "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/29.0.1547.66 Safari/537.36";
        HttpURLConnection connection = null;
        try {
            // 连接URL地址
            URL url = new URL(apiUrl);
            // 根据拼凑的URL，打开连接，URL.openConnection函数会根据URL的类型,返回不同的URLConnection子类的对象，这里URL是一个http，因此实际返回的是HttpURLConnection
            connection = (HttpURLConnection) url.openConnection();
            // 设置连接访问方法及超时参数
            connection.setRequestMethod("GET");
            connection.setReadTimeout(30000);
            connection.setConnectTimeout(30000);
            connection.setRequestProperty("User-agent", userAgent);
            // 进行连接，但是实际上get request要在下一句的connection.getInputStream()函数中才会真正发到 服务器
            connection.connect();
            // 取得输入流，并使用Reader读取
            InputStream is = connection.getInputStream();
            // 读取数据编码处理
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((strRead = reader.readLine()) != null) {
                sbf.append(strRead);
            }
            reader.close();
         }catch (IOException e) {
            log.error("httpRequest urlType="+log_urlType+", apiUrl: "+apiUrl+"发送GET请求失败", e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, log_urlType+":"+e.toString());
        } finally {
            // 关闭流
            if (connection != null) {
                // 断开连接
                connection.disconnect();
                connection=null;
            }
        }
        return sbf.toString();
    }

    /**
     * 描述:   SSLContext方式的  融慧量化派定制化模型 get请求  <br/>
     * 参数: [inUrl:请求地址; jsonParam:参数; log_urlType:请求的业务模块,方便排查问题]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.20  <br/>
     */
    public static String remoteCall(String apiUrl, String jsonParam,String log_urlType) {
        if(log_urlType==null){
            log_urlType = "";
        }
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            // 信任所有
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslCSF = new SSLConnectionSocketFactory(sslContext,SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            httpClient = HttpClients.custom().setSSLSocketFactory(sslCSF).build();
            HttpPost post = new HttpPost(apiUrl);
            StringEntity s = new StringEntity(jsonParam, "UTF-8");
            s.setContentType("application/json");
            s.setContentEncoding("UTF-8");
            post.setEntity(s);
            response = httpClient.execute(post);
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                // 获取响应实体
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    return EntityUtils.toString(entity, "UTF-8");
                }
            }else{
                HttpEntity entity = response.getEntity();
                String errorMsg = "";
                if (entity != null) {
                    errorMsg = EntityUtils.toString(entity, "UTF-8");
                }
                log.warn("httpRequest urlType="+log_urlType+", apiUrl: {} , httpStatus: {} , errorMsg: {} ", apiUrl, response.getStatusLine().getStatusCode(),errorMsg);
            }
        } catch (Exception e) {
            log.error("httpRequest urlType="+log_urlType+", apiUrl: "+apiUrl+"发送GET请求失败", e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, log_urlType+":"+e.toString());
        } finally {
            try {
                if (null != httpClient) {
                    httpClient.close();
                }
                if (null != response) {
                    response.close();
                }
            } catch (IOException e) {
                log.error("httpRequest urlType="+log_urlType+", apiUrl: "+apiUrl+"关闭连接异常", e);
                e.printStackTrace();
            }
        }
        return null;
    }


    /**
     * 描述: 发送 POST 请求（HTTP），JSON形式 <br/>
     * 备注: 和RiskHttpResponse doPost(String apiUrl, JSONObject json)方法一样，只是新增了urlType，完了方便日志排查
     * 参数: [apiUrl, json, log_urlType]  <br/>
     * 返回值: RiskHttpResponse  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.29  <br/>
     */
    public static RiskHttpResponse doPost(String apiUrl, JSONObject json,String log_urlType) {
        httpClient = getHttpClient();
        // CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).build();
        HttpPost httpPost = new HttpPost(apiUrl);
        try {
            httpPost.setConfig(requestConfig);
            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");//解决中文乱码问题
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity(stringEntity);
            HttpResponse response = httpClient.execute(httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            JSONObject jsonObject = JSONObject.parseObject(EntityUtils.toString(entity));
            EntityUtils.consume(entity);
            return new RiskHttpResponse(jsonObject,statusCode);
        } catch (IOException e) {
            log.error("httpRequest urlType="+log_urlType+", apiUrl: "+apiUrl+"请求失败", e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, log_urlType+":"+e.toString());
        } finally {
            httpPost.releaseConnection();
        }
    }


    public static String mySelfDoGet(String url, Map<String, Object> params) {
        String apiUrl = url;
        StringBuffer param = new StringBuffer();
        int i = 0;
        for (String key : params.keySet()) {
            if (i == 0)
                param.append("?");
            else
                param.append("&");
            param.append(key).append("=").append(params.get(key));
            i++;
        }
        apiUrl += param;
        long startUtc = System.currentTimeMillis();
        httpClient2 = getHttpClient();
        HttpGet httpGet = new HttpGet(apiUrl);
        try {
            HttpResponse response = httpClient2.execute(httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String context = EntityUtils.toString(entity,"utf-8");
            EntityUtils.consume(entity);

            return context;
        } catch (Exception e){
            long endtUtc = System.currentTimeMillis();
            log.error("apiUrl: "+apiUrl+"百行征信手动报送请求失败, cost: "+(endtUtc-startUtc)+".ms ", e);
        }finally {
            httpGet.releaseConnection();
        }
        return null;
    }

    /**
     * 描述: 中互金 POST Content-Type:application/json;Charset=utf-8 <br/>
     * 参数: [apiUrl, jsonObject, log_urlType]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.10.14  <br/>
     */
    public static String doPostOfZhongHuJin(String apiUrl,JSONObject jsonObject,String log_urlType) {
        String response = "";
        try {
            String bodyStr = JSON.toJSONString(jsonObject);
            byte[] body = bodyStr.getBytes("UTF-8");
            java.net.URL parsedUrl = new java.net.URL(apiUrl);
            java.net.HttpURLConnection conn = (java.net.HttpURLConnection) parsedUrl.openConnection();

            conn.setConnectTimeout(5000);
            conn.setReadTimeout(10000);
            conn.setUseCaches(false);

            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Connection", "keep-alive");
            conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            conn.setRequestProperty("Content-Length", String.valueOf(body.length));
            OutputStream outStream = conn.getOutputStream();
            outStream.write(body);
            outStream.flush();
            outStream.close();

            if(conn.getResponseCode() == 200){
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream) conn.getInputStream(), "UTF-8"));
                response = in.readLine();
                in.close();
            }
            conn.disconnect();
            return response;
        } catch (Exception e) {
            log.error("httpRequest urlType="+log_urlType+", apiUrl: "+apiUrl+"请求失败", e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString()+";url="+apiUrl);
        }
    }

    public static String doPostTool(String apiUrl, Map<String, Object> params) {
        String result = "";
        httpClient = getHttpClient();
        HttpPost httpPost = new HttpPost(apiUrl);
        try {
            List<NameValuePair> pairList = new ArrayList<>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                NameValuePair pair = new BasicNameValuePair(entry.getKey(), entry
                        .getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity(new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            HttpResponse response = httpClient.execute(httpPost);

            //int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();

            result = EntityUtils.toString(entity);

            EntityUtils.consume(entity);

        } catch (IOException e) {
            log.error("doPostTool请求apiUrl: " + apiUrl + "请求失败", e);
            throw new QGException(QGExceptionType.COMMON_THIRD_PART_CALL_EXCEPTION, e.toString() + ";url:" + apiUrl);
        } finally {
            httpPost.releaseConnection();
        }
        return result;
    }



}
