package cn.quantgroup.report.job;

import cn.quantgroup.report.response.RiskHttpResponse;
import cn.quantgroup.report.service.baihang.BaiHangZhuDaiService;
import cn.quantgroup.report.utils.dingtalk.DingTalk;
import cn.quantgroup.report.utils.http.HttpRequestUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Stopwatch;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;



/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 一些繁琐的日正常工作task<br>
 * 作者：yanhui.Hao <br>
 * 时间：2020.03.11 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Component
public class RoutineWorkTask {

    private static final Logger log = LoggerFactory.getLogger(RoutineWorkTask.class);

    @Autowired
    private RedisTemplate<String,String> redisTemplate;

    @Autowired
    private DingTalk dingTalk;

    /** 百行报送工程RoutineWorkTask锁key */
    public static final String ROUTINE_WORK_BH_LOCK_KEY_1 = "ROUTINE_WORK_BH_LOCK_KEY_1";
    public static final String ROUTINE_WORK_BH_LOCK_KEY_2 = "ROUTINE_WORK_BH_LOCK_KEY_2";


    public static final String ZXLM_A1_INTERFACE_SEND = "ZXLM_A1_INTERFACE_SEND";
    public static final String ZXLM_D2_INTERFACE_SEND = "ZXLM_D2_INTERFACE_SEND";
    public static final String ZXLM_D3_INTERFACE_SEND = "ZXLM_D3_INTERFACE_SEND";


    @Async
    @Scheduled(cron = "0 0 17 * * ?")
    public void downloadLog() {
        if (increment(ROUTINE_WORK_BH_LOCK_KEY_1)) {
            redisTemplate.expire(ROUTINE_WORK_BH_LOCK_KEY_1, 10, TimeUnit.SECONDS);

            Stopwatch stopwatch = Stopwatch.createStarted();
            //yyyy-MM-dd
            String newDatenyr = LocalDateTime.now().plusDays(-1).format(DateTimeFormatter.ISO_DATE);
            newDatenyr = newDatenyr.replace("-", "");

            //指定只有172.21.10.8服务器
            String downloadUrl = "http://172.21.10.8:9021/manualtool/send/baihang?key=b5140fb2-2c85-4b5a-abcf-3e97528014db";

            Map<String, Object> body = new HashMap<>();
            body.put("p1", "L0hNMklnTjNPenA1aDdqSHpreld1UT09");
            body.put("p2", "UTg1UFN4SjN3TThuVXFIVEFUUFR0QT09");
            body.put("p3", "Mm12NTBKU1JkVFE3MjlCK3RnZTNRdz09");
            body.put("p4", "MmJJMzNUQVRMSXQ4V3VDbUswZGNlUT09");
            body.put("p5", newDatenyr);
            body.put("secretKey", "UY1I5dHb3iq/DtEAm1f3yu7emYzlSvpFNPkxpOMSegqYJ08M2drTtNiqLyaxjbERWR0yS5CHPKpHwGjTXWHP3DEEDfXX4LhRtmiN1LIpZPdl87YWpDJ1qg07EN671JcY406oPbh7KsHFO0I0B32Hee1iZanKL4tzqmgF4dvsUNs=");

            body.put("isSend", "false");//不自动报送
            body.put("sendIncludeType", "D2,D3");//不不自动报送，该参数没有用
            body.put("isProduct", "true");
            body.put("errorCode", "D3_035,");//以后发现其他错误code，可以追加

            log.info("下载（众信利民助贷）百行反馈日志开始, newTime: {} , newDatenyr: {} ", LocalDateTime.now(), newDatenyr);
            try {
                Stopwatch stopwatch1 = Stopwatch.createStarted();
                RiskHttpResponse riskHttpResponse = HttpRequestUtil.doPost(downloadUrl, body);
                //manualToolService.sendBaiHangData
                log.info("处理结束, result: {} , 耗时: {} ", JSONObject.toJSONString(riskHttpResponse), stopwatch1.stop().elapsed(TimeUnit.MILLISECONDS));

                int statusCode = riskHttpResponse.getCode();
                JSONObject jsonObject = riskHttpResponse.getJsonObject();
                if (statusCode == 200 && jsonObject != null) {
                    String success = jsonObject.getString("success");
                    String alarm = jsonObject.getString("alarm");

                    if (StringUtils.isNotEmpty(success)) {
                        if (StringUtils.isNotEmpty(alarm)) {
                            dingTalk.talk("Info", "下载&处理" + newDatenyr + "（众信利民助贷）百行反馈日志结束", success);

                            dingTalk.talk_ToUser("下载（众信利民助贷）百行反馈主日志文件不存在", "下载" + newDatenyr + "反馈主日志文件不存在，反馈日志主文件不存在,请注意确认！");

                            log.info("下载（众信利民助贷）百行反馈日志结束, newDatenyr: {}, 耗时: {} ", newDatenyr, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                            return;
                        } else {
                            dingTalk.talk("Info", "下载&处理" + newDatenyr + "（众信利民助贷）百行反馈日志结束", success + "————10分钟后将会自动重新报送，若有问题请及时停止！");

                            String json_sq_A1 = jsonObject.getString("json_sq_A1");
                            if(StringUtils.isNotEmpty(json_sq_A1) && "true".equals(json_sq_A1)){
                                setRedisValStr(ZXLM_A1_INTERFACE_SEND);
                            }

                            String json_fk_D2 = jsonObject.getString("json_fk_D2");
                            if(StringUtils.isNotEmpty(json_fk_D2) && "true".equals(json_fk_D2)){
                                setRedisValStr(ZXLM_D2_INTERFACE_SEND);
                            }

                            String json_hk_D3 = jsonObject.getString("json_hk_D3");
                            if(StringUtils.isNotEmpty(json_hk_D3) && "true".equals(json_hk_D3)){
                                setRedisValStr(ZXLM_D3_INTERFACE_SEND);
                            }

                            log.info("下载（众信利民助贷）百行反馈日志结束, newDatenyr: {}, 耗时: {} ", newDatenyr, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
                            return;
                        }
                    }
                }
            } catch (Exception e) {
                log.error("下载（众信利民助贷）百行反馈日志异常, newDatenyr: {} ", newDatenyr, e);
                dingTalk.talk("Error", "报送服务内部异常", e);
                dingTalk.talk_ToUser("数据报送异常", "报送服务内部异常,请尽快手动处理!");
            }


            dingTalk.talk_ToUser("下载（众信利民助贷）百行反馈日志未知异常", "下载" + newDatenyr + "反馈日志失败，请尽快手动处理！");
            log.info("下载（众信利民助贷）百行反馈日志结束, newDatenyr: {}, 耗时: {} ", newDatenyr, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));

        }
    }


    @Async
    @Scheduled(cron = "0 15 17 * * ?")
    public void sendBaoSong() {
        if (increment(ROUTINE_WORK_BH_LOCK_KEY_2)) {
            redisTemplate.expire(ROUTINE_WORK_BH_LOCK_KEY_2, 10, TimeUnit.SECONDS);

            Stopwatch stopwatch = Stopwatch.createStarted();
            //yyyy-MM-dd
            String newDatenyr = LocalDateTime.now().plusDays(-1).format(DateTimeFormatter.ISO_DATE);
            newDatenyr = newDatenyr.replace("-", "");

            //指定只有172.21.10.8服务器   172.21.10.8:9021
            String send_A1_url = "http://172.21.10.8:9021/zhudai/re_send/manual/buquan/mainApplySend?key=b5140fb2-2c85-4b5a-abcf-3e97528014db";
            String send_D2_url = "http://172.21.10.8:9021/zhudai/re_send/manual/buquan/mainLoanInfoSend?key=b5140fb2-2c85-4b5a-abcf-3e97528014db";
            String send_D3_url = "http://172.21.10.8:9021/zhudai/re_send/manual/buquan/mainRepaymentLoanInfo?key=b5140fb2-2c85-4b5a-abcf-3e97528014db";

            log.info("众信利民助贷-百行重新报送开始, newTime: {} , newDatenyr: {} ", LocalDateTime.now(), newDatenyr);

            if(getRedisValStr(ZXLM_A1_INTERFACE_SEND)){
                try {
                    redisTemplate.delete(ZXLM_A1_INTERFACE_SEND);

                    String result = HttpRequestUtil.doPostTool(send_A1_url, new HashMap<>());
                    log.info("众信利民助贷-百行重新报送A1结束, newTime: {} , newDatenyr: {} , result: {} ", LocalDateTime.now(), newDatenyr, result);

                    dingTalk.talk("Info", "众信利民助贷-重新报送 A1 结束", "("+newDatenyr+")"+result);

                    Thread.sleep(10*1000);//10秒

                }catch (Exception e){
                    log.info("（众信利民助贷）重新报送A1异常, newTime: {} , newDatenyr: {} ", LocalDateTime.now(), newDatenyr, e);
                    dingTalk.talk_ToUser("众信利民助贷-重新报送 A1 异常", "("+newDatenyr+") A1报送异常,请尽快查看处理!");
                }
            }

            if(getRedisValStr(ZXLM_D2_INTERFACE_SEND)){
                try {
                    redisTemplate.delete(ZXLM_D2_INTERFACE_SEND);

                    String result = HttpRequestUtil.doPostTool(send_D2_url, new HashMap<>());
                    log.info("众信利民助贷-百行重新报送D2结束, newTime: {} , newDatenyr: {} , result: {} ", LocalDateTime.now(), newDatenyr, result);

                    dingTalk.talk("Info", "众信利民助贷-重新报送 D2 结束", "("+newDatenyr+")"+result);

                    Thread.sleep(10*1000);//10秒

                }catch (Exception e){
                    log.info("（众信利民助贷）重新报送D2异常, newTime: {} , newDatenyr: {} ", LocalDateTime.now(), newDatenyr, e);
                    dingTalk.talk_ToUser("众信利民助贷-重新报送 D2 异常", "("+newDatenyr+") D2报送异常,请尽快查看处理!");
                }
            }

            if(getRedisValStr(ZXLM_D3_INTERFACE_SEND)){
                try {
                    redisTemplate.delete(ZXLM_D3_INTERFACE_SEND);

                    String result = HttpRequestUtil.doPostTool(send_D3_url, new HashMap<>());
                    log.info("众信利民助贷-百行重新报送D3结束, newTime: {} , newDatenyr: {} , result: {} ", LocalDateTime.now(), newDatenyr, result);

                    dingTalk.talk("Info", "众信利民助贷-重新报送 D2 结束", "("+newDatenyr+")"+result);

                    Thread.sleep(10*1000);//10秒

                }catch (Exception e){
                    log.info("（众信利民助贷）重新报送D3异常, newTime: {} , newDatenyr: {} ", LocalDateTime.now(), newDatenyr, e);
                    dingTalk.talk_ToUser("众信利民助贷-重新报送 D3 异常", "("+newDatenyr+") D3报送异常,请尽快查看处理!");
                }
            }

            log.info("众信利民助贷-百行重新报送结束, newDatenyr: {}, 耗时: {} ", newDatenyr, stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
    }




    private Boolean increment(String key){
        Long increment = redisTemplate.opsForValue().increment(key, 1);
        return increment <= 1;
    }

    private void setRedisValStr(String key){
        try {
            redisTemplate.opsForValue().set(key, "true", 15, TimeUnit.MINUTES);
        }catch (Exception e){
            log.error("Redis中set值异常, key: {} ", key, e);
        }
    }

    private boolean getRedisValStr(String key){
        String value = null;
        try {
            value = redisTemplate.opsForValue().get(key);
        }catch (Exception e){
            log.error("Redis中get值异常, key: {} ", key, e);
        }

        if(StringUtils.isNotEmpty(value) && "true".equals(value)){
            return true;
        }else{
            return false;
        }
    }




}
