package cn.quantgroup.report.service.manualTool;


import cn.quantgroup.report.ApplicationContextHolder;
import cn.quantgroup.report.config.aop.DistributedLock;
import cn.quantgroup.report.config.aop.Monitor;
import cn.quantgroup.report.config.aop.MonitorType;
import cn.quantgroup.report.domain.baihang.*;
import cn.quantgroup.report.mapper.baihang.LoanInfoMapper;
import cn.quantgroup.report.mapper.master.RepaymentLoanInfoDbMapper;
import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.CommonSuperService;
import cn.quantgroup.report.utils.IdUtils;
import cn.quantgroup.report.utils.ReadOrWriteTxt;
import cn.quantgroup.report.utils.commonutil.AesCrypto;
import cn.quantgroup.report.utils.commonutil.Base64;
import cn.quantgroup.report.utils.commonutil.MD5Util;
import cn.quantgroup.report.utils.commonutil.RSAEncrypt;
import cn.quantgroup.report.utils.http.HttpRequestUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * -----------------------------------------------------------------------------<br>
 * 描述: <br>
 * 作者: Administrator <br>
 * 时间: 2019.09.24 10:34 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Slf4j
@Service
public class ManualToolService implements CommonSuperService {

    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    @Autowired
    private RepaymentLoanInfoDbMapper repaymentLoanInfoDbMapper;

    @Autowired
    private LoanInfoMapper loanInfoMapper;

    //@Autowired
    //private PinTaiCreditScoreService pinTaiCreditScoreService;


    private ShellUtils executeCommand = null;
    private static final String P1_48MD5_01 = "120a97b4b73c440413933351a2db2512fc7698f157b5c60d";
    private static final String P1_48MD5_02 = "85b61d877f6ce41c4cc72413f6766ae6876405f06b607b02";
    private static final String P2_48MD5 = "d4893490905d534e6fc1512ba6619d14df8c312362589342";
    private static final String P3_48MD5 = "57971a003213360c6fa09f4b257d5eb5441ba97a5450aa63";

    private static String RSA_PRIVATEKEY = null;

    static {
        RSA_PRIVATEKEY = readRSAPrivateKey("/manualTool/rsa_private_key.pem");
    }


    @Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    @DistributedLock
    public GlobalResponse sendBaiHangData(String p1, String p2, String p3, String p4, String p5, String secretKey, String isSend,String errorCode) {
        StringBuffer resultMsg = new StringBuffer();
        log.info("ManualToolService.sendBaiHangData Start>>>>>>");
        String base_path = "/home/quant_group/risk-datasource/data";
        String base_url = "http://172.20.1.92:9020/ex/re_send";

        if (StringUtils.isBlank(RSA_PRIVATEKEY)) {
            return new GlobalResponse("1012", "参数错误");
        }
        if (StringUtils.isBlank(secretKey)) {
            return new GlobalResponse("1012", "参数错误");
        }
        if (StringUtils.isAnyBlank(p1, p2, p3)) {
            return new GlobalResponse("1012", "参数错误");
        }

        try {
            String aes_key = RSAEncrypt.decrypt(secretKey, RSA_PRIVATEKEY);//"!QAZ@WSX3edc4rfv"
            //p1:host, p2:name, p3:pass, p4:forword, p5:date, p6:根路径
            //p1,p2,p3 做AES和base64加密
            //p1为127.0.0.1时p4必须是ip，且和172.20.1.92的MDd一致校验
            p1 = AesCrypto.decrypt(Base64.decode(p1.trim()), aes_key).trim();
            if (!(MD5Util.verify48Md5(p1, P1_48MD5_01) || MD5Util.verify48Md5(p1, P1_48MD5_02))) {
                return new GlobalResponse("1012", "参数错误");
            }
            p2 = AesCrypto.decrypt(Base64.decode(p2.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(p2, P2_48MD5)) {
                return new GlobalResponse("1012", "参数错误");
            }
            p3 = AesCrypto.decrypt(Base64.decode(p3.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(p3, P3_48MD5)) {
                return new GlobalResponse("1012", "参数错误");
            }
            //不是127.0.0.1时,p4不能为空
            if (MD5Util.verify48Md5(p1, P1_48MD5_01)) {
                if (StringUtils.isBlank(p4)) {
                    return new GlobalResponse("1012", "参数错误");
                } else {
                    p4 = AesCrypto.decrypt(Base64.decode(p4.trim()), aes_key).trim();
                }
            }
        } catch (Exception e) {
            log.error("参数解析错误.");
            return new GlobalResponse("1012", "参数错误");
        }

        if (StringUtils.isEmpty(p5)) {
            p5 = sdf.format(System.currentTimeMillis());
        }
        boolean httpSend = false;
        if (StringUtils.isNotEmpty(isSend) && "true".equals(isSend)) {
            httpSend = true;
        }

        if (StringUtils.isEmpty(errorCode)) {
            /*"errorCode":"D2_009"
            "errorCode":"D3_035"
            "errorCode":"D3_036"
            "errorCode":"D3_041"
            "errorCode":"G_001"*/
            errorCode = "D3_035";
        }

        //还款信息D3,opCode:A>>>M,多条信息就回车存多行,中间不用逗号
        String json_hk_D3 = "";
        //放款信息D2,多条信息就回车存多行,中间不用逗号
        String json_fk_D2 = "";

        try {
            if (initShellConnect(executeCommand, p1, p2, p3)) {
                //获取远程日志中reqID
                String jsaonResult = getReqIdByRemoteLog(executeCommand, p4, p5, base_path);
                if (StringUtils.isNotBlank(jsaonResult)) {
                    List<String> reqIDList = new ArrayList<>();
                    List<String> loanIdList = new ArrayList<String>();

                    JSONArray jsonArray = JSONArray.parseArray(jsaonResult);
                    resultMsg.append("getReqIdByRemoteLog size=" + (jsonArray!=null ? jsonArray.size() : "null") );
                    resultMsg.append("|");
                    for (int i = 0; i < jsonArray.size(); i++) {
                        JSONObject jsonObj = jsonArray.getJSONObject(i);
                        boolean flag = false;
                        try{
                            JSONArray errorDetailArry = jsonObj.getJSONArray("errorDetail");
                            if(errorDetailArry!=null && errorDetailArry.size()>0){
                                JSONObject error = errorDetailArry.getJSONObject(0);
                                if(error.get("errorCode")!=null && errorCode.contains(error.getString("errorCode"))){ //D3_035,D3_036
                                    flag = true;
                                    reqIDList.add(jsonObj.getString("reqID"));
                                }
                            }
                        }catch (Exception e){
                            log.error("deal with reqIdByRemoteLog error!",e);
                        }finally {
                            if(!flag){
                                resultMsg.append("\n##OTHER ERRORCODE:" + jsonObj.toJSONString()+"##");
                                log.info("ManualToolService OTHER ERRORCODE:" + jsonObj.toJSONString());
                            }
                        }
                    }
                    resultMsg.append("\n|reqIDList size=" + reqIDList.size() );

                    if (reqIDList.size() > 0) {//还款
                        String[] recordIdArray = reqIDList.toArray(new String[reqIDList.size()]);
                        log.info("RepaymentLoanInfoDbMapper getReqIdByRemoteLog reqID to D3:" + JSON.toJSONString(recordIdArray));
                        List<RepaymentLoanInfoVo> repaymentLoanInfoList = repaymentLoanInfoDbMapper.findByRecordId(recordIdArray);

                        for (RepaymentLoanInfoVo bean : repaymentLoanInfoList) {
                            bean.setOpCode("M");
                            if (bean.getOverdueStatus() == null) {
                                bean.setOverdueStatus("");
                            }
                            loanIdList.add(bean.getLoanId());
                        }
                        resultMsg.append("|");
                        resultMsg.append("D3 List size=" + repaymentLoanInfoList.size());
                        json_hk_D3 = JSONArray.toJSONString(repaymentLoanInfoList);
                        json_hk_D3 = json_hk_D3.replace("[", "");
                        json_hk_D3 = json_hk_D3.replace("]", "");
                        json_hk_D3 = json_hk_D3.replace("},", "}\n");
                    }


                    if (loanIdList.size() > 0) {
                        List<LoanInfoVo> loanInfoVoList = new ArrayList<LoanInfoVo>();
                        String[] orderNoArray = loanIdList.toArray(new String[loanIdList.size()]);
                        List<String> loanApplicationHistoryIdList = loanInfoMapper.findHistoryIdByOrderNo(orderNoArray);

                        for (String historyId : loanApplicationHistoryIdList) {
                            LoanInfoVo infoVo = loanInfoMapper.findLoanInfoVoByHistoryId(historyId);
                            loanInfoVoList.add(infoVo);
                        }
                        resultMsg.append("|");
                        resultMsg.append("D2 List size=" + loanInfoVoList.size());
                        if (loanInfoVoList.size() > 0) {
                            json_fk_D2 = JSONArray.toJSONString(loanInfoVoList);
                            json_fk_D2 = json_fk_D2.replace("[", "");
                            json_fk_D2 = json_fk_D2.replace("]", "");
                            json_fk_D2 = json_fk_D2.replace("},", "}\n");
                        }
                    }


                    if (StringUtils.isNotBlank(json_fk_D2)) {
                        //ReadOrWriteTxt.writeTxt(base_path+"/baihang/D2/data.txt",json_fk_D2);
                        String cmd_res = writeJsonFileOnRemote(executeCommand, base_path + "/baihang/D2/data.txt", json_fk_D2);
                        log.info("RepaymentLoanInfoDbMapper.sendBaiHangData writ remote file ...baihang/D2/data.txt END,r:" + cmd_res);
                        resultMsg.append("|");
                        resultMsg.append("write D2 end.");
                        if (httpSend) {
                            Map<String, Object> params = new HashMap<String, Object>();
                            params.put("key", "b5140fb2-2c85-4b5a-abcf-3e97528014db");
                            String http_res = HttpRequestUtil.mySelfDoGet(base_url + "/mainLoanInfoSend", params);
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData http request D2>>>mainLoanInfoSend END,r:" + http_res);
                            resultMsg.append("|");
                            resultMsg.append(http_res);
                        }
                    }else{
                        resultMsg.append("|");
                        resultMsg.append("放款D2 json_fk_D2 isEmpty.");
                    }
                    if (StringUtils.isNotBlank(json_hk_D3)) {
                        //ReadOrWriteTxt.writeTxt(base_path+"/baihang/D3/data.txt",json_hk_D3);
                        String cmd_res = writeJsonFileOnRemote(executeCommand, base_path + "/baihang/D3/data.txt", json_hk_D3);
                        log.info("RepaymentLoanInfoDbMapper.sendBaiHangData writ remote file ...baihang/D3/data.txt END,r:" + cmd_res);
                        resultMsg.append("|");
                        resultMsg.append("write D3 end.");
                        if (httpSend) {
                            Map<String, Object> params = new HashMap<String, Object>();
                            params.put("key", "b5140fb2-2c85-4b5a-abcf-3e97528014db");
                            String http_res = HttpRequestUtil.mySelfDoGet(base_url + "/mainRepaymentLoanInfo", params);
                            log.info("RepaymentLoanInfoDbMapper.sendBaiHangData http request D3>>>mainRepaymentLoanInfo END,r:" + http_res);
                            resultMsg.append("|");
                            resultMsg.append(http_res);
                        }

                    }else {
                        resultMsg.append("|");
                        resultMsg.append("还款D3 json_hk_D3 isEmpty.");
                    }
                    //退出登录
                    List<String> cmdList = new ArrayList<String>();
                    cmdList.add("echo '++CMD LAST++' \n\r");
                    cmdList.add("exit \n\r");
                    cmdList.add("exit \n\r");
                    executeCommand.execute(cmdList, false);

                    return GlobalResponse.generate(resultMsg);
                } else {
                    log.info("RepaymentLoanInfoDbMapper.getReqIdByRemoteLog redult isEmpty.");
                    return GlobalResponse.generate("百行征信手动报送,获取日志为空");
                }
            }
        } catch (Exception e) {
            log.error("ManualToolService.sendBaiHangData Error,", e);
            return new GlobalResponse("1001", "百行征信手动报送异常," + e.getMessage());
        } finally {
            if (executeCommand != null) {
                executeCommand.ioclose();
                executeCommand.closeChannelShell();
                executeCommand = null;
            }
            try {
                ShellUtils.LOCK.unlock();
            } catch (IllegalMonitorStateException e) {
                log.warn("锁已释放,无需重复释放." + e);
            }
        }
        log.info("ManualToolService.sendBaiHangData All END<<<<<<");
        return new GlobalResponse("1000", "百行征信手动报送失败");
    }

    /**
     * 描述: 初始化 ShellUtils  <br/>
     * 参数: [p1:host, p2:name, p3:pass]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.25  <br/>
     */
    private boolean initShellConnect(ShellUtils executeCommand, String p1, String p2, String p3) {
        try {
            ShellUtils.LOCK.lock();
            if (executeCommand == null) {
                executeCommand = new ShellUtils(p1, p2, p3);
                if (executeCommand.login()) {
                    executeCommand.initChannel(ShellUtils.CHANNEL_TYPE_SHELL);
                    this.executeCommand = executeCommand;
                    return true;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("ManualToolService.initShellConnect Error," + e.getMessage());
        } finally {
            ShellUtils.LOCK.unlock();
        }
        return false;
    }

    /**
     * 描述: 获取远程服务器的日志信息  <br/>
     * 参数: [p4:forword, p5:date, p6:根路径]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.25  <br/>
     */
    private String getReqIdByRemoteLog(ShellUtils executeCommand, String p4, String p5, String p6) {
        String result = null;
        try {
            ShellUtils.LOCK.lock();
            if (executeCommand != null) {
                log.info(".......>>>>start deal with cmd:1 outputStream execute Start.......");
                List<String> cmdList = new ArrayList<>();
                cmdList.add("ssh " + p4 + " \n\r");
                cmdList.add("/sbin/ifconfig  |grep \"inet addr\" \n\r");
                cmdList.add("cd " + p6 + " \n\r");
                cmdList.add("sh download_baihang_error_log.sh " + Integer.parseInt(p5) + " \n\r");
                executeCommand.execute(cmdList, true);
                //打印执行结果
                executeCommand.outCmdResult();
                log.info(".......>>>>start deal with cmd:1 inputStream getResult End.......");
                ShellUtils.LOCK.unlock();

                ShellUtils.LOCK.lock();
                cmdList = new ArrayList<>();
                log.info(".......>>>>start deal with cmd:2 outputStream execute Start.......");
                cmdList.add("cd " + p6 + "/" + p5 + " \n\r");
                cmdList.add("cat *_logicerror.log \n\r");
                executeCommand.execute(cmdList, true);
                //获取reqID结果
                result = executeCommand.getResult();
                log.info(".......>>>>start deal with cmd:2 inputStream getResult End.......result:\n" + result);
                ShellUtils.LOCK.unlock();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                ShellUtils.LOCK.unlock();
            } catch (IllegalMonitorStateException e) {
                log.warn("锁已释放,无需重复释放." + e);
            }
        }
        return result;
    }


    /**
     * 描述: 往远程服务器写文件 <br/>
     * 参数: [p4:forword, p5:date, p6:根路径]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.25  <br/>
     */
    private String writeJsonFileOnRemote(ShellUtils executeCommand, String filePath, String context) {
        String result = null;
        try {
            ShellUtils.LOCK.lock();
            if (executeCommand != null) {
                log.info(".......>>>>start deal with cmd:3 outputStream execute Start.......");
                List<String> cmdList = new ArrayList<>();
                String path = filePath.substring(0, filePath.lastIndexOf("/"));
                cmdList.add("cd " + path + " \n\r");
                cmdList.add("pwd \n\r");
                cmdList.add("printf '" + context + "' >./data.txt \n\r");
                cmdList.add("cat data.txt |wc -l \n\r");
                executeCommand.execute(cmdList, true);
                //打印执行结果
                executeCommand.outCmdResult();
                log.info(".......>>>>start deal with cmd:3 inputStream getResult End.......");
                result = "写入成功:" + filePath;
                ShellUtils.LOCK.unlock();
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                ShellUtils.LOCK.unlock();
            } catch (IllegalMonitorStateException e) {
                log.warn("锁已释放,无需重复释放." + e);
            }
        }
        return result;
    }

    /**
     * 描述: 读取私钥 <br/>
     * 参数: [fileName]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.26  <br/>
     */
    private static String readRSAPrivateKey(String fileName) {
        InputStream isr = ManualToolService.class.getResourceAsStream(fileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(isr));
        StringBuilder builder = new StringBuilder();
        try {
            boolean inKey = false;
            for (String line = br.readLine(); line != null; line = br.readLine()) {
                line = line.trim();
                if (!inKey) {
                    if (line.contains("BEGIN PRIVATE KEY")) {
                        inKey = true;
                    }
                    continue;
                } else {
                    if (line.contains("END PRIVATE KEY")) {
                        inKey = false;
                        break;
                    }
                    builder.append(line);
                }
            }
            br.close();
            isr.close();
        } catch (IOException e) {
            e.printStackTrace();
            log.error("读取:" + fileName + "异常", e);
        }
        return builder.toString();
    }



    @Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    @DistributedLock
    public GlobalResponse buildLoanInfoD2(String jsonFile) {
        StringBuffer resultMsg = new StringBuffer();
        if(StringUtils.isEmpty(jsonFile)){
            return new GlobalResponse("1000", "百行征信手动报送失败");
        }
        //jsonFile = "C:\\Users\\Administrator\\Desktop\\百行历史数据报送实时放款数据D2(历史百行征信报送).json";
        String context = ReadOrWriteTxt.readTxt(jsonFile);

        JSONObject jSONObject = JSON.parseObject(context);
        JSONArray jsonArray = jSONObject.getJSONArray("RECORDS");
        for (int i = 0; i < jsonArray.size() ; i++) {
            JSONObject object = jsonArray.getJSONObject(i);
            Object reqID = object.get("reqID");
            if(reqID!=null){
                List<String> list = loanInfoMapper.findTargetRepaymentDayList(reqID.toString());
                if(list!=null && list.size()>0){
                    String[] strArry = list.toArray(new String[list.size()]);
                    object.put("targetRepayDateList",strArry);
                }else{
                    object.put("targetRepayDateList",new String[0]);
                }
            }
        }

        String json_fk_D2 = JSONArray.toJSONString(jsonArray);
        //json_fk_D2 = json_fk_D2.replace("[", "");
        //json_fk_D2 = json_fk_D2.replace("]", "");
        json_fk_D2 = json_fk_D2.replace("},", "}\n");


        String writeName = jsonFile.substring(0,jsonFile.lastIndexOf("\\"))+"\\d2.txt";
        ReadOrWriteTxt.writeTxt(writeName,json_fk_D2);
        System.out.print("放款信息 D2 写入文件OK:"+writeName);
        return new GlobalResponse("0", "放款信息 D2 写入文件OK:"+writeName);
    }


    @Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    @DistributedLock
    public GlobalResponse testPTCreditScoreV1(String filePath,String p3,String secretKey) {
        StringBuffer resultMsg = new StringBuffer();
        if (StringUtils.isAnyBlank(RSA_PRIVATEKEY,filePath,p3,secretKey)) {
            return new GlobalResponse("1012", "参数错误");
        }
        try {
            String aes_key = RSAEncrypt.decrypt(secretKey, RSA_PRIVATEKEY);//"!QAZ@WSX3edc4rfv"
            String tmp = AesCrypto.decrypt(Base64.decode(p3.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(tmp, P3_48MD5)) {
                return new GlobalResponse("1012", "参数错误");
            }
        } catch (Exception e) {
            log.error("参数解析错误.");
            return new GlobalResponse("1012", "参数错误");
        }
        long start = System.currentTimeMillis();
        List<String> contextList = ReadOrWriteTxt.readTxtList(filePath);
        StringBuffer resultBuff = new StringBuffer();
        if(contextList!=null && contextList.size()>0){
            for(int i =0; i<contextList.size(); i++){
                long startUtc = System.currentTimeMillis();
                String context = contextList.get(i);
                String value = "";
                try{
                    //唯一ID|name|id_no|phone
                    String[] strArry = context.split("[|]");
                    String transactionId = IdUtils.getUuid();
                    CommonSuperService superService = ApplicationContextHolder.getBean("pinTaiCreditScoreService");
                    Object resultObject = superService.getClass().getMethod("pinTaiCreditScoreV1Query", String.class, String.class, String.class, String.class, String.class, boolean.class)
                            .invoke(superService, transactionId, strArry[0], strArry[1],strArry[2],strArry[3], false);
                    GlobalResponse globalResponse = (GlobalResponse) resultObject;
                   //// GlobalResponse globalResponse = pinTaiCreditScoreService.pinTaiCreditScoreV1Query(transactionId, strArry[0], strArry[1], strArry[2], strArry[3], false);
                    Object object = globalResponse.getBody();

                    if(object!=null){
                        JSONObject jsonObject = ((JSONObject) object).getJSONObject("content");
                        if(jsonObject!=null && jsonObject.containsKey("S2070101")){
                            value = jsonObject.getString("S2070101");
                        }
                    }
                    resultBuff.append(context.replace("|","\t"));
                    resultBuff.append("\t");
                    resultBuff.append(value);
                    resultBuff.append("\n");

                    Thread.sleep(1000);

                }catch (Exception e){
                    log.error("品钛高德分查询异常,context="+context,e);
                }
                log.info("查询"+i+":value="+value+",cost="+(System.currentTimeMillis()-startUtc));
            }
        }
        String writeName = filePath.substring(0,filePath.lastIndexOf("\\"))+"\\result.txt";
        ReadOrWriteTxt.writeTxt(writeName,resultBuff.toString());
        log.info("品钛高德分测试数据写入文件OK, total cost="+(System.currentTimeMillis()-start)+", writeName="+writeName);

        return GlobalResponse.generate("品钛高德分测试数据写入文件OK, total cost="+(System.currentTimeMillis()-start)+", writeName="+writeName);
    }


    //@Monitor({MonitorType.EXCEPTION, MonitorType.FEE, MonitorType.HIT, MonitorType.RESULT})
    //@DistributedLock
    public boolean checkSecretKey(String p3,String secretKey) {
        StringBuffer resultMsg = new StringBuffer();
        if (StringUtils.isAnyBlank(RSA_PRIVATEKEY,p3,secretKey)) {
            return false;
        }
        try {
            String aes_key = RSAEncrypt.decrypt(secretKey, RSA_PRIVATEKEY);//"!QAZ@WSX3edc4rfv"
            String tmp = AesCrypto.decrypt(Base64.decode(p3.trim()), aes_key).trim();
            if (!MD5Util.verify48Md5(tmp, P3_48MD5)) {
                return false;
            }
        } catch (Exception e) {
            log.error("参数解析错误.");
            return false;
        }
        return true;
    }


    public GlobalResponse dealWithExcelData(String filePath,String type) {
        if(StringUtils.isAnyBlank(filePath,type)){
            return new GlobalResponse("1000", "百行征信手动报送失败");
        }
        List<Object> jsonArray = new ArrayList<Object>();

        List<String> lineList = ReadOrWriteTxt.readTxtList(filePath);

        String[] titleKeys = lineList.get(0).split("\t");

        StringBuffer jsonStr = new StringBuffer();
        DateFormat df_uploadTs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        for (int i = 1; i < lineList.size() ; i++) {
            String[] datas = lineList.get(i).split("\t");
            JSONObject json = new JSONObject();

            for (int k=0; k<titleKeys.length; k++){
                json.put(titleKeys[k].trim(), (datas[k]!=null ? datas[k].toString().trim() :null));
            }

            if("A1".equals(type)){
                //ApplyLoanInfoZhuDai bean = new Gson().fromJson(json.toJSONString(), new TypeToken<ApplyLoanInfoZhuDai>(){}.getType());
                ApplyLoanInfoZhuDai bean = JSONObject.toJavaObject(json, ApplyLoanInfoZhuDai.class);
                String uploadTs = df_uploadTs.format(new Date());
                bean.setUploadTs(uploadTs.replace(" ","T"));

                jsonArray.add(bean);

                jsonStr.append(JSON.toJSONString(bean));
                jsonStr.append("\n");

            }else if("D2".equals(type)){
                //LoanInfoZhuDaiVo bean = new Gson().fromJson(json.toJSONString(), new TypeToken<LoanInfoZhuDaiVo>(){}.getType());
                //FinTechAgencyBusinessZhuDai finTechAgencyBusiness = new Gson().fromJson(json.toJSONString(), new TypeToken<FinTechAgencyBusinessZhuDai>(){}.getType());
                //bean.setFinTechAgencyBusiness(finTechAgencyBusiness);

                LoanInfoZhuDai bean = JSONObject.toJavaObject(json, LoanInfoZhuDai.class);
                String uploadTs = df_uploadTs.format(new Date());
                bean.setUploadTs(uploadTs.replace(" ","T"));

                jsonArray.add(bean);

                jsonStr.append(JSON.toJSONString(bean));
                jsonStr.append("\n");

            }else if("D3".equals(type)){
                //RepaymentInfoZhuDai bean = new Gson().fromJson(json.toJSONString(), new TypeToken<RepaymentInfoZhuDai>(){}.getType());
                RepaymentInfoZhuDai bean = JSONObject.toJavaObject(json, RepaymentInfoZhuDai.class);
                String uploadTs = df_uploadTs.format(new Date());
                bean.setUploadTs(uploadTs.replace(" ","T"));
                jsonArray.add(bean);

                jsonStr.append(JSON.toJSONString(bean));
                jsonStr.append("\n");

            }else{
                log.error("其他类型type:"+type);
                jsonArray.add(json);

                jsonStr.append(JSON.toJSONString(json));
                jsonStr.append("\n");
            }
        }

        //String jsonStr = JSONArray.toJSONString(jsonArray);

        String writeName = filePath.substring(0,filePath.lastIndexOf("\\"));
        writeName = writeName + "\\build\\";
        writeName = writeName + filePath.substring(filePath.lastIndexOf("\\")+1, filePath.length());
        ReadOrWriteTxt.writeTxt(writeName,jsonStr.toString());
        log.info("处理后数据入文件OK:"+writeName);
        return new GlobalResponse("0", "处理后数据入文件OK:"+writeName);
    }




    public static void main11(String[] args) {
       /* for (int i=0; i<12; i++){
            String id = UUID.randomUUID().toString().replaceAll("-", "");
            System.out.println(id);
        }*/


       //修改D3中的reqID
       /*DateFormat df_uploadTs = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
       int rr = 1009823900;
        List<String> lineList = ReadOrWriteTxt.readTxtList("C:\\Users\\Administrator\\Desktop\\测试\\文件测试\\build\\tmp3.txt");
        for(int i=0;i<lineList.size();i++){
            RepaymentInfoZhuDai repaymentLoanInfo = new Gson().fromJson(lineList.get(i), new TypeToken<RepaymentInfoZhuDai>(){}.getType());
            //String id = UUID.randomUUID().toString().replaceAll("-", "");
            rr++;
            String uploadTs = df_uploadTs.format(new Date());
            repaymentLoanInfo.setReqID(rr+"");
            //repaymentLoanInfo.setUploadTs(uploadTs.replace(" ","T"));
            System.out.println(JSON.toJSONString(repaymentLoanInfo));
        }
        System.err.println(rr);*/


        //将D2中FinTechAgencyBusinessZhuDai变成树形结构
       /* List<String> lineD2List = ReadOrWriteTxt.readTxtList("C:\\Users\\Administrator\\Desktop\\测试\\文件测试\\build\\tmp2.txt");
        for(int i=0;i<lineD2List.size();i++){
            LoanInfoZhuDaiVo loanInfo = JSONObject.parseObject(lineD2List.get(i), LoanInfoZhuDaiVo.class);
            FinTechAgencyBusinessZhuDai finTechAgencyBusiness = JSONObject.parseObject(lineD2List.get(i), FinTechAgencyBusinessZhuDai.class);
            loanInfo.setFinTechAgencyBusiness(finTechAgencyBusiness);
            System.out.println(JSON.toJSONString(loanInfo));
        }
        System.err.println("build D2 finTechAgencyBusiness end.");*/


       //-----------------------------------------------
        //A1
       //String[] err_inp_reqIDs = {"..."};
        String[] err_inp_reqIDs = {"..."};

       Map<String,String> err_inp_reqIDMap = new HashMap<>(err_inp_reqIDs.length);
       for (String tmp1 :err_inp_reqIDs){
           err_inp_reqIDMap.put(tmp1,"err_inp");
       }
       System.out.println("err_inp_reqIDMap大小:"+err_inp_reqIDMap.size());

        //A1
        //String[] err_log_reqIDs = {"986af677071e4f0aa8763688e02e6e81","c305c77631d34ad78db6a2fdae01520e"};
        String[] err_log_reqIDs = {"..."};



        Map<String,String> err_log_reqIDMap = new HashMap<>(err_log_reqIDs.length);
        for (String tmp2 : err_log_reqIDs){
            err_log_reqIDMap.put(tmp2,"err_log");
        }
        System.out.println("err_log_reqIDMap大小:"+err_log_reqIDMap.size());
        //-------------------------


       //List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\lhp_A1_20170209_20191025_TEST_01.txt");
        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\lhp_D2_20170209_20191025_TEST_01.txt");

       System.out.println("lineList:"+lineList.size());

       StringBuffer inp_buff = new StringBuffer();
       StringBuffer log_buff = new StringBuffer();

        for(int i=0;i<lineList.size();i++){
            int flag = 0;
            //ApplyLoanInfoZhuDai applyInfo_A1 = JSONObject.parseObject(lineList.get(i), ApplyLoanInfoZhuDai.class);
            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            JSONObject jsonObj= JSONObject.parseObject(str);

            if(err_inp_reqIDMap.containsKey(jsonObj.getString("reqID"))){
                inp_buff.append(jsonObj.toJSONString());
                inp_buff.append("\n");

                flag++;
            }
            if(err_log_reqIDMap.containsKey(jsonObj.getString("reqID"))){
                log_buff.append(jsonObj.toJSONString());
                log_buff.append("\n");

                flag++;
            }

            if(flag>=2){
                System.err.println("发现两个错误类别都存在:"+jsonObj.getString("reqID"));
            }

            /*LoanInfoZhuDaiVo loanInfo = JSONObject.parseObject(lineList.get(i), LoanInfoZhuDaiVo.class);
            FinTechAgencyBusinessZhuDai finTechAgencyBusiness = JSONObject.parseObject(lineD2List.get(i), FinTechAgencyBusinessZhuDai.class);
            loanInfo.setFinTechAgencyBusiness(finTechAgencyBusiness);
            System.out.println(JSON.toJSONString(loanInfo));*/
        }
        System.err.println("build data finTechAgencyBusiness end.");


//        System.out.println("----------inputerror.log data------");
//        System.out.println(inp_buff.toString());
//        System.out.println("\n");
//
//        System.out.println("----------logicerror.log data------");
//        System.out.println(log_buff.toString());*/
//
//        /*String fileName = "D:\\用户目录\\Downloads\\D2_M.txt";
//        try {
//            FileUtils.write(new File(fileName), "----------inputerror.log data------"+"\r\n", "UTF-8", true);
//            FileUtils.write(new File(fileName), inp_buff.toString()+"\r\n", "UTF-8", true);
//
//            FileUtils.write(new File(fileName), "----------logicerror.log data------"+"\r\n", "UTF-8", true);
//            FileUtils.write(new File(fileName), log_buff.toString()+"\r\n", "UTF-8", true);
//
//        } catch (IOException e) {
//            e.printStackTrace();
//            System.err.println(e);
//        }
//        System.err.println("write file end.");


    }

    public static void writeLog(String msg) {
        System.out.println(msg);
        try {
            String fileName = "D:\\JavaTeam\\D3_build\\out_log.txt";
            FileUtils.write(new File(fileName), msg+"\r\n", "UTF-8", true);
        } catch (IOException e) {
            e.printStackTrace();
            System.err.println("writeLog Error."+e);
        }
    }

    public static void buildA1() {
        //A1
        String[] err_inp_reqIDs = {"..."};
        //D2
        //String[] err_inp_reqIDs = {"..."};
        Map<String,String> err_inp_reqIDMap = new HashMap<>(err_inp_reqIDs.length);
        for (String tmp1 :err_inp_reqIDs){
            err_inp_reqIDMap.put(tmp1,"err_inp");
        }
        System.out.println("err_inp_reqIDMap大小:"+err_inp_reqIDMap.size());

        //A1
        String[] err_log_reqIDs = {"986af677071e4f0aa8763688e02e6e81","c305c77631d34ad78db6a2fdae01520e"};
        //D2
        //String[] err_log_reqIDs = {"..."};
        Map<String,String> err_log_reqIDMap = new HashMap<>(err_log_reqIDs.length);
        for (String tmp2 : err_log_reqIDs){
            err_log_reqIDMap.put(tmp2,"err_log");
        }
        System.out.println("err_log_reqIDMap大小:"+err_log_reqIDMap.size());
        //---------------------------------------------------------------


        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\生产数据\\lhp_A1_20170209_20191025_01.txt");
        System.out.println("lineList:"+lineList.size());
        String fileName = "D:\\用户目录\\Downloads\\生产数据\\new_lhp_A1_20170209_20191025_01.txt";


        for(int i=0;i<lineList.size();i++){
            int flag = 0;
            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            JSONObject jsonObj= JSONObject.parseObject(str);
            String id = jsonObj.getString("reqID");

            if(err_inp_reqIDMap.containsKey(id)){
                jsonObj.put("emailAddress",null);
                writeLog(id+" Set emailAddress null.");
                flag++;
            }

            if(err_log_reqIDMap.containsKey(id)){
                err_log_reqIDMap.remove(id);
                writeLog(id+" Set remove.");
                flag++;

                if(flag>=2){
                    writeLog("发现两个错误类别都存在:"+id);
                }

                continue;
            }

            try {

                FileUtils.write(new File(fileName), jsonObj.toJSONString()+"\r\n", "UTF-8", true);
            } catch (IOException e) {
                System.err.println("build data,"+e);
            }

        }
        System.err.println("build data finTechAgencyBusiness end.");
    }

    public static void buildD2_inputerror() {
        List<String> ok_data_json = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\A1D2_M\\build_D2_01_M.txt");
        Map<String,String> ok_data_Map = new HashMap<>(ok_data_json.size());
        for(int i=0; i<ok_data_json.size(); i++){
            JSONObject jsonObj= JSONObject.parseObject(ok_data_json.get(i));
            JSONObject business = jsonObj.getJSONObject("finTechAgencyBusiness");
            ok_data_Map.put(business.getString("orderID"),jsonObj.toJSONString());
        }


        //D2
        String[] err_inp_reqIDs = {"..."};
        Map<String,String> err_inp_reqIDMap = new HashMap<>(err_inp_reqIDs.length);
        for (String tmp1 :err_inp_reqIDs){
            err_inp_reqIDMap.put(tmp1,"err_inp");
        }
        System.out.println("err_inp_reqIDMap大小:"+err_inp_reqIDMap.size());


        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\生产数据\\lhp_D2_20170209_20191025_01.txt");
        System.out.println("lineList:"+lineList.size());
        String fileName = "D:\\用户目录\\Downloads\\生产数据\\new_lhp_D2_20170209_20191025_01.txt";

        for(int i=0;i<lineList.size();i++){
            String w_str = "";

            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            JSONObject jsonObj= JSONObject.parseObject(str);
            String reqId = jsonObj.getString("reqID");
            JSONObject business = jsonObj.getJSONObject("finTechAgencyBusiness");



            if(err_inp_reqIDMap.containsKey(reqId)){

                String orderID = business.getString("orderID");
                w_str = ok_data_Map.get(orderID);
                writeLog("reqId="+reqId+" Find, orderID find "+(StringUtils.isNotBlank(w_str))+":"+w_str);
            }else{
                business.remove("institutionalFundingPartnerLoanID");//资金合作方贷款/授信账户编号
                business.remove("preCreditLimit");//预授信额度
                jsonObj.put("finTechAgencyBusiness",business);
                w_str = jsonObj.toJSONString();
            }

            try {
                FileUtils.write(new File(fileName), w_str+"\r\n", "UTF-8", true);
            } catch (IOException e) {
                System.err.println("build data,"+e);
            }

        }
        System.err.println("build data finTechAgencyBusiness end.");
    }


    public static void buildD2_logicerror() {
        //D2
        String[] err_log_reqIDs = {"492ccc1de1114529bf67c63dd766ed3c"};
        Map<String,String> err_log_reqIDMap = new HashMap<>(err_log_reqIDs.length);
        for (String tmp1 : err_log_reqIDs){
            err_log_reqIDMap.put(tmp1,"err_log_reqIDs");
        }
        System.out.println("err_log_reqIDMap大小:"+err_log_reqIDMap.size());

        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\lhp_D2_20170209_20191025_TEST_01.txt");
        System.out.println("lineList:"+lineList.size());

        String fileName = "D:\\用户目录\\Downloads\\D2_TEST_logicerror_data.txt";

        for(int i=0;i<lineList.size();i++){
            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            JSONObject jsonObj= JSONObject.parseObject(str);
            String reqId = jsonObj.getString("reqID");

            if(err_log_reqIDMap.containsKey(reqId)){
                try {
                    FileUtils.write(new File(fileName), jsonObj.toJSONString()+"\r\n", "UTF-8", true);
                } catch (IOException e) {
                    System.err.println("build data,"+e);
                }
            }
        }
        System.err.println("build data finTechAgencyBusiness end.");
    }



    public static void buildD3_logicerror() {

        //"D3_041", 贷款账户编号loanId+还款期数termNo+还款状态确认时间statusConfirmAt+业务发生机构代码在还款记录中唯一。
        List<String> logicerrorList = ReadOrWriteTxt.readTxtList("D:\\JavaTeam\\D3_build\\d3_041_errData.txt");
        Map<String,String> err_log_loanIdMap = new HashMap<>(logicerrorList.size());
        for (String strs : logicerrorList){
            String[] tmpArr = strs.split("[|]");
            //err_log_loanIdMap.put(tmpArr[1], strs);
            err_log_loanIdMap.put(tmpArr[1]+","+tmpArr[2]+","+tmpArr[3], strs);
        }
        System.out.println("err_log_loanIdMap 大小:"+err_log_loanIdMap.size());


        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\JavaTeam\\D3_build\\D3_04.txt");
        System.out.println("lineList:"+lineList.size());
        String fileName = "D:\\JavaTeam\\D3_build\\new_D3_04.txt";

        int totalCount = 0,removeCount=0;
        for(int i=0;i<lineList.size();i++){
            System.out.println("START:"+i);

            String str = lineList.get(i);
            if(str.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }

            RepaymentInfoZhuDai repaymentLoanInfo = new Gson().fromJson(str, new TypeToken<RepaymentInfoZhuDai>(){}.getType());
            String loanId = repaymentLoanInfo.getLoanId();

            /*if(err_log_loanIdMap.containsKey(loanId)){
                //2|100011189|9|2019-02-22T00:00:00|
                String[] errMsgArr = err_log_loanIdMap.get(loanId).split("[|]");
                if(repaymentLoanInfo.getTermNo()==Integer.parseInt(errMsgArr[2]) && repaymentLoanInfo.getStatusConfirmAt().equals(errMsgArr[3])){
                    if(repaymentLoanInfo.getRealRepayment()==null || repaymentLoanInfo.getRealRepayment().intValue()==0){
                        if(repaymentLoanInfo.getRealRepaymentDate()==null || repaymentLoanInfo.getRealRepaymentDate().equals("")){
                            writeLog(JSON.toJSONString(repaymentLoanInfo));
                            removeCount++;
                            continue;
                        }
                    }
                }
            }*/

            String key = loanId+","+repaymentLoanInfo.getTermNo()+","+repaymentLoanInfo.getStatusConfirmAt();
            if (err_log_loanIdMap.containsKey(key)) {
                //100011189,9,2019-02-22T00:00:00
                if (repaymentLoanInfo.getRealRepayment() == null || repaymentLoanInfo.getRealRepayment().intValue() == 0) {
                    if (repaymentLoanInfo.getRealRepaymentDate() == null || repaymentLoanInfo.getRealRepaymentDate().equals("")) {
                        writeLog(JSON.toJSONString(repaymentLoanInfo));
                        removeCount++;
                        continue;
                    }
                }
            }


            try {
                FileUtils.write(new File(fileName), JSON.toJSONString(repaymentLoanInfo)+"\r\n", "UTF-8", true);
            } catch (IOException e) {
                System.err.println("build D3 data,"+e);
            }
            totalCount++;
        }
        System.out.println("build D3 end, lineList="+lineList.size()+",totalCount="+totalCount+",removeCount="+removeCount+", 合="+(totalCount+removeCount));
    }



    public static void buildA1_uploadTs(String newJsonFile, String oldJsonFile) {

        newJsonFile = "D:\\用户目录\\Downloads\\生产数据\\new_lhp_A1_20170209_20191025_01.txt";
        String fileName = "D:\\用户目录\\Downloads\\生产数据\\new201911181620_lhp_A1_20170209_20191025_01.txt";

        List<String> newJsonList = ReadOrWriteTxt.readTxtList(newJsonFile);
        System.out.println("newJsonList大小:"+newJsonList.size());

        for(int i=0; i< newJsonList.size(); i++){
            System.out.println("Start:"+i);
            String strJson = newJsonList.get(i);
            if(strJson.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            ApplyLoanInfoZhuDai applyInfo = new Gson().fromJson(strJson, new TypeToken<ApplyLoanInfoZhuDai>(){}.getType());
            if(applyInfo.getApplyDate()!=null){
                applyInfo.setUploadTs(applyInfo.getApplyDate());//applyDate
            }
            applyInfo.setOpCode("M");

            try {
                FileUtils.write(new File(fileName), JSON.toJSONString(applyInfo)+"\r\n", "UTF-8", true);
            } catch (IOException e) {
                System.err.println("build data,"+e);
            }
        }
        System.err.println("build data buildA1_uploadTs end.");
    }


    public static void buildD2_uploadTs(String newJsonFile, String oldJsonFile) {
        newJsonFile = "D:\\用户目录\\Downloads\\生产数据\\uploadTs_M_201911181718\\new_lhp_D2_20170209_20191025_01.txt";
        String fileName = "D:\\用户目录\\Downloads\\生产数据\\uploadTs_M_201911181718\\new201911181720_D2_20170209_20191025_01.txt";

        List<String> newJsonList = ReadOrWriteTxt.readTxtList(newJsonFile);
        System.out.println("newJsonList大小:"+newJsonList.size());

        for(int i=0; i< newJsonList.size(); i++){
            System.out.println("Start:"+i);
            String strJson = newJsonList.get(i);
            if(strJson.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            LoanInfoZhuDai loanInfozd_tmp = new Gson().fromJson(strJson, new TypeToken<LoanInfoZhuDai>(){}.getType());

            if(loanInfozd_tmp.getApplyDate()!=null){
                loanInfozd_tmp.setUploadTs(loanInfozd_tmp.getIssueDate()); //issueDate
            }
            loanInfozd_tmp.setOpCode("M");

            try {
                FileUtils.write(new File(fileName), JSON.toJSONString(loanInfozd_tmp)+"\r\n", "UTF-8", true);
            } catch (IOException e) {
                System.err.println("build data,"+e);
            }
        }
        System.err.println("build data buildD2_uploadTs end.");
    }


    public static void buildD3_uploadTs(String newJsonFile, String oldJsonFile) {
        newJsonFile = "D:\\用户目录\\Downloads\\生产数据\\uploadTs_M_201911181718\\bak1\\new_D3_01.txt";
        String fileName = "D:\\用户目录\\Downloads\\生产数据\\uploadTs_M_201911181718\\new201911181720_D3_01.txt";

        List<String> newJsonList = ReadOrWriteTxt.readTxtList(newJsonFile);
        System.out.println("newJsonList大小:"+newJsonList.size());

        Map<String,String> new_uploadTs_Map = new HashMap<>(newJsonList.size());
        for(int i=0; i< newJsonList.size(); i++){
            System.out.println("Start:"+i);
            String strJson = newJsonList.get(i);
            if(strJson.length() < 30 ){//#applyInfo   #singleLoanAccountInfo
                continue;
            }
            RepaymentInfoZhuDai repaymentLoanInfo = new Gson().fromJson(strJson, new TypeToken<RepaymentInfoZhuDai>(){}.getType());



            if("normal".equals(repaymentLoanInfo.getTermStatus().trim()) ){
                repaymentLoanInfo.setUploadTs(repaymentLoanInfo.getRealRepaymentDate());//realRepaymentDate
            }else {
                //overdue
                repaymentLoanInfo.setUploadTs(repaymentLoanInfo.getStatusConfirmAt());//statusConfirmAt
            }
            repaymentLoanInfo.setOpCode("M");

            try {
                FileUtils.write(new File(fileName), JSON.toJSONString(repaymentLoanInfo)+"\r\n", "UTF-8", true);
            } catch (IOException e) {
                System.err.println("build data,"+e);
            }
        }
        System.err.println("build data buildD3_uploadTs end.");
    }





        public static void main(String[] args) {
//        List<String> lineList = ReadOrWriteTxt.readTxtList("D:\\用户目录\\Downloads\\D2_M_01.txt");
//        System.out.println("lineList:"+lineList.size());
//        StringBuffer buff = new StringBuffer();
//        for(int i=0;i<lineList.size();i++){
//            String str = lineList.get(i);
//            JSONObject jsonObj= JSONObject.parseObject(str);
//            JSONObject business = jsonObj.getJSONObject("finTechAgencyBusiness");
//            //orderID
//            //relationID
//            buff.append("'"+business.getString("relationID")+"',");
//        }
//        System.out.println(buff.toString());

            /*String resMsgTemp = "申请A1报送: 查询 %d条(联合贷%d条), 报送成功 %d条; ";
            System.out.println(String.format(resMsgTemp, 10, 2, 10));*/


            //buildD2_inputerror();

           // buildD2_logicerror();

           // buildD3_logicerror();



           // private static final String P1_48MD5_01 = "92db79819d81523604a8ee5da9142167f38766bb2cd32f0c";//127.
           // private static final String P1_48MD5_02 = "56e766114e1f81171319ee8998101c34518c06ae60a4981f";//172.
           // private static final String P2_48MD5 = "d4893490905d534e6fc1512ba6619d14df8c312362589342";
           // private static final String P3_48MD5 = "57971a003213360c6fa09f4b257d5eb5441ba97a5450aa63";

           // System.out.println(MD5Util.get48Md5("172.20.1.92"));
           // System.out.println(MD5Util.verify48Md5("root2","d4893490905d534e6fc1512ba6619d14df8c312362589342"));


            //buildA1_uploadTs(null,null);
            //buildD2_uploadTs(null,null);
            buildD3_uploadTs(null,null);

        }
}
