package cn.quantgroup.report.fastjson;

import cn.quantgroup.report.utils.MaskedUtils;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.google.common.base.Joiner;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CustomValueFilter implements ValueFilter {
  private final Set<String> Masked_KEYS;

  public CustomValueFilter(Set<String> masked_KEYS) {
    Masked_KEYS = masked_KEYS;
  }

  @Override
  public Object process(Object o, String s, Object o1) {
    if (Masked_KEYS == null || o1 == null || StringUtils.isBlank(s) || !Masked_KEYS.contains(s)) {
      return o1;
    }
    if (o1 instanceof String[]) {
      List<String> maskedStrings = Arrays.stream(((String[]) o1)).map(string -> MaskedUtils.buildMaskedCommonString(string)).collect(Collectors.toList());
      return Joiner.on(",").join(maskedStrings);
    }
    return MaskedUtils.buildMaskedCommonString(o1 instanceof String ? ((String) o1) : o1.toString());
  }
}