package cn.quantgroup.report.utils.commonutil;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class MD5Util {

    private static ThreadLocal<MessageDigest> messageDigestHolder = new ThreadLocal();

    static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public MD5Util() {
    }

    public static String getMd5(String plainText) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte b[] = md.digest();

            int i;

            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < b.length; offset++) {
                i = b[offset];
                if (i < 0)
                    i += 256;
                if (i < 16)
                    buf.append("0");
                buf.append(Integer.toHexString(i));
            }
            // 32位加密
            return buf.toString();
            // 16位的加密
            // return buf.toString().substring(8, 24);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }

    }

    public static String getMD5Format(String data) {
        try {
            MessageDigest e = (MessageDigest) messageDigestHolder.get();
            if (e == null) {
                e = MessageDigest.getInstance("MD5");
                messageDigestHolder.set(e);
            }

            e.update(data.getBytes());
            byte[] b = e.digest();
            String digestHexStr = "";

            for (int i = 0; i < 16; ++i) {
                digestHexStr = digestHexStr + byteHEX(b[i]);
            }

            return digestHexStr;
        } catch (Exception var5) {
            System.out.println(var5);
            return null;
        }
    }

    public static String getMD5Format(byte[] data) {
        try {
            MessageDigest e = (MessageDigest) messageDigestHolder.get();
            if (e == null) {
                e = MessageDigest.getInstance("MD5");
                messageDigestHolder.set(e);
            }

            e.update(data);
            byte[] b = e.digest();
            String digestHexStr = "";

            for (int i = 0; i < 16; ++i) {
                digestHexStr = digestHexStr + byteHEX(b[i]);
            }

            return digestHexStr;
        } catch (Exception var5) {
            return null;
        }
    }

    private static String byteHEX(byte ib) {
        char[] ob = new char[]{hexDigits[ib >>> 4 & 15], hexDigits[ib & 15]};
        String s = new String(ob);
        return s;
    }

    static {
        try {
            MessageDigest e = MessageDigest.getInstance("MD5");
            messageDigestHolder.set(e);
        } catch (NoSuchAlgorithmException var1) {
            System.out.println(var1);
        }
    }

    /**
     * 描述:  md5.digest   <br/>
     * 参数: [msg]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.20  <br/>
     */
    public static String getMD5Digest(String msg) {
        try {
            MessageDigest md5 = (MessageDigest) messageDigestHolder.get();
            if (md5 == null) {
                md5 = MessageDigest.getInstance("MD5");
                messageDigestHolder.set(md5);
            }
            byte[] byteArray=null;
            byteArray=msg.getBytes();
            byte[] md5Bytes=md5.digest(byteArray);
            StringBuffer hexValue=new StringBuffer();
            for(int i=0; i < md5Bytes.length; i++) {
                int val=((int)md5Bytes[i]) & 0xff;
                if(val < 16)
                    hexValue.append("0");
                hexValue.append(Integer.toHexString(val));
            }
            return hexValue.toString();
        } catch (Exception var5) {
            System.out.println(var5);
            return null;
        }
    }

    /**
     * 描述: 生成含有16位随机盐的MD5加密串  <br/>
     * 参数: [msg]  <br/>
     * 返回值: java.lang.String  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.26  <br/>
     */
    public static String get48Md5(String msg) {
        Random r = new Random();
        StringBuilder sb = new StringBuilder(16);
        sb.append(r.nextInt(99999999)).append(r.nextInt(99999999));
        int len = sb.length();
        if (len < 16) {
            for (int i = 0; i < 16 - len; i++) {
                sb.append("0");
            }
        }
        String salt = sb.toString();
        msg = getMd5(msg + salt);
        char[] cs = new char[48];
        for (int i = 0; i < 48; i += 3) {
            cs[i] = msg.charAt(i / 3 * 2);
            char c = salt.charAt(i / 3);
            cs[i + 1] = c;
            cs[i + 2] = msg.charAt(i / 3 * 2 + 1);
        }
        return new String(cs);
    }


    /**
     * 描述:  校验48位str48Md5是否正确   <br/>
     * 参数: [msg, str48Md5]  <br/>
     * 返回值: boolean  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.26  <br/>
     */
    public static boolean verify48Md5(String msg, String str48Md5) {
        char[] cs1 = new char[32];
        char[] cs2 = new char[16];
        for (int i = 0; i < 48; i += 3) {
            cs1[i / 3 * 2] = str48Md5.charAt(i);
            cs1[i / 3 * 2 + 1] = str48Md5.charAt(i + 2);
            cs2[i / 3] = str48Md5.charAt(i + 1);
        }
        String salt = new String(cs2);
        return getMd5(msg + salt).equals(new String(cs1));
    }

}
