package cn.quantgroup.report.cmpt;

import cn.quantgroup.report.constant.KeyConstant;
import cn.quantgroup.report.enums.RequestUrlType;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * Created by Alan on6/14.
 */
@Slf4j
@Component
public class MonitorCmpt {
    private static ThreadPoolExecutor pool = new ThreadPoolExecutor(5, 50, 200,
            TimeUnit.MILLISECONDS, new LinkedBlockingQueue<>(500), new ThreadPoolExecutor.DiscardPolicy());

    private static String[] notAlarm = {
            /*RequestUrlType.BaiRongSpecialList_c.name(),
            RequestUrlType.QianHaiQueryBlackList.name(),
            RequestUrlType.TongDunHitRuleDetail.name(),
            RequestUrlType.JDBlacklist.name(),
            RequestUrlType.CreditXFraud.name(),
            RequestUrlType.ShuMeiOverdue.name(),
            RequestUrlType.HaoAnBlackList.name(),
            RequestUrlType.BaiDuBlackList.name(),
            RequestUrlType.TianXingHuiBlackList.name(),
            RequestUrlType.FaHaiJudicial.name(),*/
    };

    private static List<String> URL_NOT_ALARM = Arrays.asList(notAlarm);

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (pool != null) pool.shutdown();
        }));
    }

    @Autowired
    private RedisTemplate<String,String> redisTemplate;

    @Autowired
    private CommonAlarmCmpt commonAlarmCmpt;

    /**
     * 命中率统计
     * @param urlType
     * @param flag 0：查询失败，1，查询命中
     */
    public void statisticHitRate(String urlType, int flag){
        pool.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String dayKey = KeyConstant.HIT_RATE + KeyConstant.ONE_DAY + urlType + ":" + flag;
                    String heapKey = KeyConstant.HIT_RATE + KeyConstant.HEAP + urlType + ":" + 0;
                    redisTemplate.opsForValue().increment(dayKey, 1);
                    //黑名单不告警
                    if(URL_NOT_ALARM.contains(urlType)){
                        return;
                    }
                    if (flag == 1) {
                        redisTemplate.delete(heapKey);
                        return;
                    }
                    Long heapCount = redisTemplate.opsForValue().increment(heapKey, 1);
                    log.info("三方数据源: {} , 连续未命中次数 : {} ",urlType,heapCount);
                    if (heapCount >= 15 && (heapCount - 15) % 10 == 0) {
                        String alarmLevel = "Warn";
                        if (heapCount == 85 || heapCount == 165) {
                            alarmLevel = "Emergency";
                        }
                        commonAlarmCmpt.alarm(alarmLevel, "三方数据源告警", "数据源【" + urlType + "】查询连续" + heapCount + "次未命中");
                    }
                }catch (Exception e){
                    log.error("三方数据源统计查询命中率异常, urlType: {} ",urlType ,e);
                }
            }
        });
    }

}
