package cn.quantgroup.report.domain.baihang;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 还款用户信息
 *
 * @Author fengjunkai
 * @Date 2019-03-26 15:13
 */
@Data
public class RepaymentLoanInfoVo implements Serializable {

    private static final long serialVersionUID = 8722959335665582382L;

    private String reqID; //记录唯一标示
    private String recordId;
    private String opCode;  //操作CODE  a-增加  m-修改
    private String uploadTs;  //记录生成时间  ISO 8601
    private String loanId;  //贷款ID
    private String name;
    private String pid;
    private String mobile;
    private int termNo; //当前还款期数
    private String termStatus; //本期还款状态
    private String targetRepaymentDate;  //本期应还款日  YYYY-MM-DD
    private String realRepaymentDate; //实际还款日期ISO 8601
    private BigDecimal plannedPayment; //本期计划应还款金额
    private BigDecimal targetRepayment; //本期剩余应还款金额
    private BigDecimal realRepayment; // 本次还款金额
    private String overdueStatus; //当前逾期天数
    private String statusConfirmAt;//本期还款状态确认时间
    private BigDecimal overdueAmount; //当前逾期总金额
    private BigDecimal remainingAmount;  //贷款余额
    private int loanStatus; //本笔贷款状态

    private Long id;
    private Integer enable;
    private String createdAt;
    private String updatedAt;


}
