package cn.quantgroup.report.utils.commonutil;

import cn.quantgroup.report.error.QGExceptionType;
import cn.quantgroup.report.error.QGPreconditions;
import org.apache.commons.lang3.StringUtils;

/**
 * 三要素/uuid 参数空校验
 *
 * @Author fengjunkai
 * @Date 2019-06-13 17:06
 */
public class ParammeterCheckUtils {

    public static void checkParams(String transactionId, String uuid, String phone, String idCard, String name){

        QGPreconditions.checkArgument(StringUtils.isNotBlank(phone), QGExceptionType.COMMON_STRING_PARAM_IS_ALL_NULL, "phone");
        QGPreconditions.checkArgument(StringUtils.isNotBlank(idCard), QGExceptionType.COMMON_STRING_PARAM_IS_ALL_NULL, "idCard");
        QGPreconditions.checkArgument(StringUtils.isNotBlank(name), QGExceptionType.COMMON_STRING_PARAM_IS_ALL_NULL, "name");
        QGPreconditions.checkArgument(StringUtils.isNotBlank(uuid), QGExceptionType.COMMON_STRING_PARAM_IS_ALL_NULL, "uuid");

    }

}
