package cn.quantgroup.report.domain.baihang;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 放款用户信息,用于手动报送 <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.09.25 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Data
public class LoanInfoVo implements Serializable {

    private static final long serialVersionUID = 7293591774673907983L;

    private Integer reqID;  //记录唯一ID
    //private String recordId;
    private String opCode;  //操作代码A-增加  M-修改
    private String uploadTs; //记录生成时间    ISO 8601格式  LocalDateTime生成
    private String name; //姓名
    private String pid;  //身份证好
    private String mobile; //手机号
    private String loanId; //贷款编号
    private int guaranteeType; //贷款担保类型
    private int loanPurpose; //借款用途
    private String applyDate;// 贷款申请时间
    private String accountOpenDate;  //账户开立时间
    private String issueDate; //贷款放款时间
    private String dueDate;  //贷款到期日期  YYYY-MM-DD
    private BigDecimal loanAmount; //贷款金额
    private int totalTerm; //还款总期数
    private String targetRepayDateType;  //账单日类型
    private String termPeriod;//每期还款周期
    private String firstRepaymentDate; //首次应还款日期  YYYY-MM-DD
    private String gracePeriod; //宽限日
    //private String targetRepayDateList; //账单日列表



}
