package cn.quantgroup.report.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 校验身份证信息
 *
 * @author renfeng
 * @date: 2016年9月27日 下午5:38:07
 * @version v1.0
 */
public class CheckIdCard {

	public static void main(String[] args) {
		String IDStr = "422204710412473";
//		String IDStr = "440301197812121292";
		String result = trans15bitTo18bit(IDStr);
		System.out.print("您的18位身份证号是：" + result);

		System.out.println(CheckIdCard.IDCardValidate(IDStr));
	}

	/**
	 * 功能：身份证的有效验证
	 * 
	 * @param IDStr
	 *            身份证号
	 * @return 有效：返回"" 无效：返回String信息
	 * @throws ParseException
	 */
	@SuppressWarnings("rawtypes")
	public static String IDCardValidate(String IDStr) {
		try{
			String errorInfo = "";// 记录错误信息
			String[] ValCodeArr = { "1", "0", "x", "9", "8", "7", "6", "5", "4", "3", "2" };
			String[] Wi = { "7", "9", "10", "5", "8", "4", "2", "1", "6", "3", "7", "9", "10", "5", "8", "4", "2" };
			String Ai = "";
			//号码的长度 15位或18位 
			if (IDStr.length() != 15 && IDStr.length() != 18) {
				errorInfo = "身份证号码长度应该为15位或18位。";
				return errorInfo;
			}
	
			//数字 除最后以为都为数字 
			if (IDStr.length() == 18) {
				Ai = IDStr.substring(0, 17);
			} else if (IDStr.length() == 15) {
				Ai = IDStr.substring(0, 6) + "19" + IDStr.substring(6, 15);
			}
			if (isNumeric(Ai) == false) {
				errorInfo = "身份证15位号码都应为数字 ; 18位号码除最后一位外，都应为数字。";
				return errorInfo;
			}
			//出生年月是否有效
			String strYear = Ai.substring(6, 10);// 年份
			String strMonth = Ai.substring(10, 12);// 月份
			String strDay = Ai.substring(12, 14);// 月份
			if (isDataFormat(strYear + "-" + strMonth + "-" + strDay) == false) {
				errorInfo = "身份证生日无效。";
				return errorInfo;
			}
			GregorianCalendar gc = new GregorianCalendar();
			SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd");
			if ((gc.get(Calendar.YEAR) - Integer.parseInt(strYear)) > 150
					|| (gc.getTime().getTime() - s.parse(strYear + "-" + strMonth + "-" + strDay).getTime()) < 0) {
				errorInfo = "身份证生日不在有效范围。";
				return errorInfo;
			}
			if (Integer.parseInt(strMonth) > 12 || Integer.parseInt(strMonth) == 0) {
				errorInfo = "身份证月份无效";
				return errorInfo;
			}
			if (Integer.parseInt(strDay) > 31 || Integer.parseInt(strDay) == 0) {
				errorInfo = "身份证日期无效";
				return errorInfo;
			}
	
			//地区码时候有效 
			Hashtable h = GetAreaCode();
			if (h.get(Ai.substring(0, 2)) == null) {
				errorInfo = "身份证地区编码错误。";
				return errorInfo;
			}
			//判断最后一位的值
			int TotalmulAiWi = 0;
			for (int i = 0; i < 17; i++) {
				TotalmulAiWi = TotalmulAiWi + Integer.parseInt(String.valueOf(Ai.charAt(i))) * Integer.parseInt(Wi[i]);
			}
			int modValue = TotalmulAiWi % 11;
			String strVerifyCode = ValCodeArr[modValue];
			Ai = Ai + strVerifyCode;
	
			if (IDStr.length() == 18) {
				if (Ai.equalsIgnoreCase(IDStr) == false) {
					errorInfo = "身份证无效，不是合法的身份证号码";
					return errorInfo;
				}
			} 
		}catch(Exception e){
			e.printStackTrace();
			return "";
		}
		return "";
	}

	/**
	 * 功能：设置地区编码
	 * 
	 * @return Hashtable 对象
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	private static Hashtable GetAreaCode() {
		Hashtable hashtable = new Hashtable();
		hashtable.put("11", "北京");
		hashtable.put("12", "天津");
		hashtable.put("13", "河北");
		hashtable.put("14", "山西");
		hashtable.put("15", "内蒙古");
		hashtable.put("21", "辽宁");
		hashtable.put("22", "吉林");
		hashtable.put("23", "黑龙江");
		hashtable.put("31", "上海");
		hashtable.put("32", "江苏");
		hashtable.put("33", "浙江");
		hashtable.put("34", "安徽");
		hashtable.put("35", "福建");
		hashtable.put("36", "江西");
		hashtable.put("37", "山东");
		hashtable.put("41", "河南");
		hashtable.put("42", "湖北");
		hashtable.put("43", "湖南");
		hashtable.put("44", "广东");
		hashtable.put("45", "广西");
		hashtable.put("46", "海南");
		hashtable.put("50", "重庆");
		hashtable.put("51", "四川");
		hashtable.put("52", "贵州");
		hashtable.put("53", "云南");
		hashtable.put("54", "西藏");
		hashtable.put("61", "陕西");
		hashtable.put("62", "甘肃");
		hashtable.put("63", "青海");
		hashtable.put("64", "宁夏");
		hashtable.put("65", "新疆");
		hashtable.put("71", "台湾");
		hashtable.put("81", "香港");
		hashtable.put("82", "澳门");
		hashtable.put("91", "国外");
		return hashtable;
	}

	/**
	 * 验证日期字符串是否是YYYY-MM-DD格式
	 * 
	 * @param str
	 * @return
	 */
	public static boolean isDataFormat(String str) {
		boolean flag = false;
		// regxStr="[1-9][0-9]{3}-[0-1][0-2]-((0[1-9])|([12][0-9])|(3[01]))";
		String regxStr = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$";
		Pattern pattern1 = Pattern.compile(regxStr);
		Matcher isNo = pattern1.matcher(str);
		if (isNo.matches()) {
			flag = true;
		}
		return flag;
	}

	public static String trans15bitTo18bit(String IDStr){
		String[] input = IDStr.split("");
		String[] result = new String[18];
		for(int i=0;i<input.length;i++){
			if(i<=5){
				result[i] = input[i];
			}else{
				result[i+2] = input[i];
			}
		}
		//年份最后两位小于17,年份为20XX，否则为19XX
		if(Integer.valueOf(input[6])<=1&&Integer.valueOf(input[7])<=7){
			result[6]="2";
			result[7]="0";
		}else{
			result[6]="1";
			result[7]="9";
		}
		//计算最后一位
		String[] xs = {"7","9","10","5","8","4","2","1","6","3","7","9","10","5","8","4","2"};
		//前十七位乘以系数[7,9,10,5,8,4,2,1,6,3,7,9,10,5,8,4,2],
		int sum = 0;
		for(int i=0;i<17;i++){
			sum+= Integer.valueOf(result[i]) * Integer.valueOf(xs[i]);
		}
		//对11求余，的余数 0 - 10
		int rod = sum % 11;
		//所得余数映射到对应数字即可
		if(rod==0){ result[17] = "1";
		}else if(rod==1){ result[17] = "0";
		}else if(rod==2){ result[17] = "X";
		}else if(rod==3){ result[17] = "9";
		}else if(rod==4){ result[17] = "8";
		}else if(rod==5){ result[17] = "7";
		}else if(rod==6){ result[17] = "6";
		}else if(rod==7){ result[17] = "5";
		}else if(rod==8){ result[17] = "4";
		}else if(rod==9){ result[17] = "3";
		}else if(rod==10){ result[17] = "2";}
		StringBuilder builder = new StringBuilder();
		for(String c : result){
			builder.append(c);
		}
		return builder.toString();
	}

	/**
	 * 功能：判断字符串是否为数字
	 * 
	 * @param str
	 * @return
	 */
	private static boolean isNumeric(String str) {
		Pattern pattern = Pattern.compile("[0-9]*");
		Matcher isNum = pattern.matcher(str);
		if (isNum.matches()) {
			return true;
		} else {
			return false;
		}
	}

}
