package cn.quantgroup.report.service.baihang;

import cn.hutool.core.io.IoUtil;
import cn.hutool.json.JSONUtil;
import cn.quantgroup.report.domain.baihang.ApplyLoanInfoZhuDai;
import cn.quantgroup.report.mapper.master.ApplyLoanInfoZhuDaiMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

@Slf4j
@Service
public class BaiHangDataDisposeService {

    private static final String HOST_PATH = "/home/quant_group/reportFile/";

    @Autowired
    private BaiHangFileReportService baiHangFileReportService;
    @Autowired
    public ApplyLoanInfoZhuDaiMapper applyLoanInfoZhuDaiMapper;

    @Async
    public void fixA1RefuseDataCauseByBatchSave(String plainTextFileName,Boolean saveDb){
        BufferedReader bis = null;
        String dataStr = null;
        List<ApplyLoanInfoZhuDai> zhuDaiLogList = null;
        ApplyLoanInfoZhuDai record = null;
        AtomicInteger atomicInteger = new AtomicInteger();
        try {
            bis = new BufferedReader(new FileReader(HOST_PATH + plainTextFileName));
            while(null != (dataStr = bis.readLine())) {
                if (StringUtils.isNotBlank(dataStr) && !baiHangFileReportService.hasBaiHangFileHeadMark(dataStr)) {
                    ApplyLoanInfoZhuDai applyLoanInfoZhuDai = JSONUtil.toBean(dataStr, ApplyLoanInfoZhuDai.class);
                    zhuDaiLogList = applyLoanInfoZhuDaiMapper.findByApplyId(applyLoanInfoZhuDai.getApplyId());
                    if (CollectionUtils.isEmpty(zhuDaiLogList)) {
                        atomicInteger.getAndIncrement();
                        if (saveDb) {
                            record = new ApplyLoanInfoZhuDai();
                            BeanUtils.copyProperties(applyLoanInfoZhuDai, record);
                            record.setRecordId(UUID.randomUUID().toString().replaceAll("-", ""));
                            applyLoanInfoZhuDaiMapper.saveApplyLoanInfoZhuDaiLog(record);
                        }
                    }
                }
            }
            log.error("fixA1RefuseDataCauseByBatchSave处理数据结束,处理总量={}",atomicInteger.get());
        } catch (Exception e) {
            log.error("fixA1RefuseDataCauseByBatchSave处理数据异常",e.getMessage());
        } finally {
            IoUtil.close(bis);
            dataStr = null;
        }
    }

}
