package cn.quantgroup.report.utils.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.util.*;

/**
 * @Author fengjunkai
 * @Date 2019-06-10 16:29
 */
public class JSONUtils {

    public static void getBeforeFeatures(Object featureObject, Map<String, Object> resultMap) {
        JSONObject featureJson = (JSONObject) featureObject;
        Iterator<Map.Entry<String, Object>> iterator = featureJson.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> objectEntry = iterator.next();
            String key = objectEntry.getKey();
            Object value = objectEntry.getValue();
            if (value instanceof JSONObject) {
                getBeforeFeatures(value, resultMap);
            } else if (value instanceof JSONArray) {
                resultMap.put(key, value);
            } else {
                resultMap.put(key, value);
            }
        }
    }

    public static void getFeature(Object featureObject, Map<String, Object> resultMap, Map<String, Object> keyMap, String prefix) {
        JSONObject featuresJson = (JSONObject) featureObject;
        Iterator<Map.Entry<String, Object>> iterator = featuresJson.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entryMap = iterator.next();
            String key = entryMap.getKey();
            Object value = entryMap.getValue();
            if (value instanceof JSONArray) {
                resultMap.put(prefix + key, value);
                keyMap.put(prefix + key, key);
            } else if (value instanceof JSONObject) {
                JSONObject jsonObject1 = featuresJson.getJSONObject(key);
                Iterator<Map.Entry<String, Object>> iterator1 = jsonObject1.entrySet().iterator();
                while (iterator1.hasNext()) {
                    Map.Entry<String, Object> entryMap1 = iterator1.next();
                    String key1 = entryMap1.getKey();
                    Object value1 = entryMap1.getValue();
                    if (value1 instanceof JSONArray) {
                        resultMap.put(prefix + key + "_" + key1, value1);
                        keyMap.put(prefix + key + "_" + key1, key1);
                    } else if (value1 instanceof JSONObject) {
                        JSONObject jsonObject2 = jsonObject1.getJSONObject(key1);
                        Iterator<Map.Entry<String, Object>> iterator2 = jsonObject2.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry<String, Object> entryMap2 = iterator2.next();
                            String key2 = entryMap2.getKey();
                            Object value2 = entryMap2.getValue();
                            if (value2 instanceof JSONArray) {
                                resultMap.put(prefix + key + "_" + key1 + "_" + key2, value2);
                                keyMap.put(prefix + key + "_" + key1 + "_" + key2, key2);
                            } else if (value2 instanceof JSONObject) {
                                JSONObject jsonObject3 = jsonObject2.getJSONObject(key2);
                                Iterator<Map.Entry<String, Object>> iterator3 = jsonObject3.entrySet().iterator();
                                while (iterator3.hasNext()) {
                                    Map.Entry<String, Object> entryMap3 = iterator3.next();
                                    String key3 = entryMap3.getKey();
                                    Object value3 = entryMap3.getValue();
                                    if (value3 instanceof JSONArray) {
                                        resultMap.put(prefix + key + "_" + key1 + "_" + key2 + "_" + key3, value3);
                                        keyMap.put(prefix + key + "_" + key1 + "_" + key2 + "_" + key3, key3);
                                    } else if (value3 instanceof JSONObject) {
                                        System.out.println("===============================未知=======================");
                                    } else {
                                        resultMap.put(prefix + key + "_" + key1 + "_" + key2 + "_" + key3, value3);
                                        keyMap.put(prefix + key + "_" + key1 + "_" + key2 + "_" + key3, key3);
                                    }
                                }
                            } else {
                                resultMap.put(prefix + key + "_" + key1 + "_" + key2, value2);
                                keyMap.put(prefix + key + "_" + key1 + "_" + key2, key2);
                            }
                        }
                    } else {
                        resultMap.put(prefix + key + "_" + key1, value1);
                        keyMap.put(prefix + key + "_" + key1, key1);
                    }
                }
            } else {
                resultMap.put(prefix + key, value);
                keyMap.put(prefix + key, key);
            }
        }
    }


    /**
     * 描述:  将一个有多层结构的json对象平铺展开，遇到数组不平铺 <br/>
     * （为空避免二级以下key重复，所有用parent.Children1.Children2.....）  <br/>
     * 参数: [parentKey, objJson, resultMap]  <br/>
     * 返回值: void  <br/>
     * 创建人: yanhui.Hao  <br/>
     * 创建时间: 2019.09.05  <br/>
     */
    public static void  analysisJson(String parentKey, Object objJson,Map<String,Object> resultMap){
        if(parentKey==null){
            parentKey = "";
        }
        //如果obj为json数组
        if(objJson instanceof JSONArray){
            JSONArray objArray = (JSONArray)objJson;
            resultMap.put(parentKey, objArray);
        }
        //如果为json对象
        else if(objJson instanceof JSONObject){
            JSONObject jsonObject = (JSONObject)objJson;
            //Iterator it = jsonObject.keys();
            Iterator<String> it = jsonObject.keySet().iterator();
            while(it.hasNext()){
                String key = it.next().toString();
                Object object = jsonObject.get(key);
                //如果得到的是数组
                if(object instanceof JSONArray){
                    JSONArray objArray = (JSONArray)object;
                    analysisJson(parentKey+"."+key,objArray,resultMap);
                }
                //如果key中是一个json对象
                else if(object instanceof JSONObject){
                    analysisJson(parentKey+"."+key,(JSONObject)object,resultMap);
                }
                //如果key中是其他
                else{
                    resultMap.put(parentKey+"."+key, object);
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
//            String featureData = FileUtils.readFileToString(new File("/Users/fengjunkai/Documents/临时文件/百行征信/baihang/temp.txt"), "utf-8");
            String featureData = FileUtils.readFileToString(new File("/Users/fengjunkai/Documents/量化派文档/三方数据源/百行征信文档/百行查询返回查得数据/查得.txt"), "utf-8");
            JSONObject jsonObject = JSON.parseObject(featureData);
            Map<String, Object> resultMap = new HashMap<>();
            Map<String, Object> keyMap = new HashMap<>();

            getFeature(jsonObject, resultMap, keyMap, "baihang_");
            System.out.println(JSON.toJSONString(resultMap));
            System.out.println(JSON.toJSONString(keyMap));
//            System.out.println(JSONObject.toJSONString(resultMap));
//            Map<String,Object> terResultMap = new HashMap<>();
//            Iterator<Map.Entry<String, Object>> iterator = resultMap.entrySet().iterator();
//            while (iterator.hasNext()){
//                Map<String,Object> bodyMap = new HashMap<>();
//                Map.Entry<String,Object> entryMap = iterator.next();
//                String key = entryMap.getKey();
//                Object value = entryMap.getValue();
//                bodyMap.put("state", "200");
//                bodyMap.put("value", value);
//                terResultMap.put(key, bodyMap);
//            }
//            System.out.println(JSON.parseObject(JSON.toJSONString(terResultMap)));
            String sql = "INSERT INTO `merchant_field_mapping`(`field`, `third_field`, `method_name`, `location_method`, `field_name`, `field_source_name`, `field_type`, `parent_keys`, `service_name`, `created_at`) VALUES ('%s', '%s', '%s', '%s', '%s', '%s', '%s', '', '%s', CURRENT_TIMESTAMP());";
            List<String> list = FileUtils.readLines(new File("/Users/fengjunkai/Downloads/key_value_mapping.txt"), "utf-8");
            Iterator<String> iterator1 = list.iterator();
            while (iterator1.hasNext()){
                String next = iterator1.next();
                String third = next.split("###")[0];
                String localKey = next.split("###")[1];
                System.out.println(String.format(sql, localKey, third, "queryBaiHangPersionCreditReport", third, "", "百行个人征信报告", "Integer", "baiHangQueryService"));
            }
//
//            Iterator<Map.Entry<String, Object>> iterator = keyMap.entrySet().iterator();
//            while (iterator.hasNext()) {
//                Map.Entry<String, Object> next = iterator.next();
//                String key = next.getKey();
//                Object value = next.getValue();
//                System.out.println(String.format(sql, value, key, "moxieRiskV2", key, "", "魔蝎申请准入报告V2.0", "String", "moxieRiskService"));
//            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
