package cn.quantgroup.report.utils;


import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CheckUtils {

    private static final Pattern phone_pattern = Pattern.compile("^((\\d{11}))$");
    private static final Pattern name_pattern = Pattern.compile("^([a-zA-Z0-9\\u4e00-\\u9fa5\\·]{1,20})$");

    public static boolean checkIfPhoneOk(String phone){
        if(phone == null) return false;
        Matcher matcher = phone_pattern.matcher(phone);
        return matcher.matches();
    }

    public static boolean checkIfNameOk(String name){
        if(name == null) return false;
        Matcher matcher = name_pattern.matcher(name);
        return matcher.matches();
    }

}
