package cn.quantgroup.report.config.datasource.history;


import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

@Import(XyqbHistoryDataSourcePreperties.class)
@Configuration
@Slf4j
@MapperScan(basePackages = XyqbHistoryDataSourceConfig.PACKAGE, sqlSessionFactoryRef = "xyqbHistorySqlSessionFactory")
public class XyqbHistoryDataSourceConfig {


    static final String PACKAGE = "cn.quantgroup.report.mapper.baihang";

    @Value("${baihang.mapper-locations}")
    private String mapperLocations;

    @Value("${baihang.type-aliases-package}")
    private String typeAliasesPackage;
    
    @Value("${config-location}")
    private String configLocation;

    @Autowired
    private XyqbHistoryDataSourcePreperties xyqbHistoryDataSourcePreperties;

    @Bean(name = "xyqbHistoryDataSource")
    public DataSource xyqbHistoryDataSource() {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(xyqbHistoryDataSourcePreperties.getJdbcUrl());
        log.info("xyqb历史数据库地址:{}", xyqbHistoryDataSourcePreperties.getJdbcUrl());
        config.setPassword(xyqbHistoryDataSourcePreperties.getPassword());
        config.setUsername(xyqbHistoryDataSourcePreperties.getUsername());
        config.setMaximumPoolSize(xyqbHistoryDataSourcePreperties.getMaxPoolSize());
        config.setMinimumIdle(xyqbHistoryDataSourcePreperties.getMinPoolSize());
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        return new HikariDataSource(config);
    }

    @Bean(name = "xyqbHistoryTransactionManager")
    public DataSourceTransactionManager xyqbHistoryTransactionManager(@Qualifier("xyqbHistoryDataSource") DataSource xyqbHistoryDataSource) {
        return new DataSourceTransactionManager(xyqbHistoryDataSource);
    }

    @Bean(name = "xyqbHistorySqlSessionFactory")
    public SqlSessionFactory xyqbHistorySqlSessionFactory(@Qualifier("xyqbHistoryDataSource") DataSource xyqbHistoryDataSource) throws Exception {
        final SqlSessionFactoryBean sessionFactory = new SqlSessionFactoryBean();
        sessionFactory.setDataSource(xyqbHistoryDataSource);
        sessionFactory.setMapperLocations(new PathMatchingResourcePatternResolver()
                .getResources(mapperLocations));
        sessionFactory.setTypeAliasesPackage(typeAliasesPackage);
        sessionFactory.setConfigLocation(new PathMatchingResourcePatternResolver()
                .getResource(configLocation));
        return sessionFactory.getObject();
    }

    @Bean(name = "xyqbHistorySqlSessionTemplate")
    public SqlSessionTemplate xyqbHistorySqlSessionTemplate(@Qualifier("xyqbHistorySqlSessionFactory") SqlSessionFactory xyqbHistorySqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(xyqbHistorySqlSessionFactory);
    }

    @Bean(name = "xyqbHistoryJdbcTemplate")
    public JdbcTemplate primaryJdbcTemplate(@Qualifier("xyqbHistoryDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

}
