package cn.quantgroup.report.service.cache;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

/**
 * Created by Alan on 2018/5/29.
 */
@Service
@Slf4j
public class CacheServiceImpl implements CacheService{

    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public void clearLock(String lockName) {
        RedisConnection connection = redisTemplate.getConnectionFactory().getConnection();
        connection.del(lockName.getBytes());
        connection.close();
    }

    @Override
    public void clearCache(String configName) {
        redisTemplate.delete(configName);
    }
}
