package cn.quantgroup.report.domain.master;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

@Data
@NoArgsConstructor
public class IntelliCreditLoanIssue {
  private Long id;

  private String name;

  private String pid;

  private String mobile;

  private String loanType;

  private Long accountOpenDate;

  private Long applyDate;

  private Long issueDate;

  private BigDecimal loanAmount;

  private Long loanId;

  private Integer totalTerm;

  private Long firstRepaymentDate;

  private Integer termPeriod;

  private Integer planCount;

  private Integer status;

  private Date timeCreated;

  private String device;

  @Builder
  public IntelliCreditLoanIssue(Long id, String name, String pid, String mobile, String loanType, Long accountOpenDate, Long applyDate, Long issueDate, BigDecimal loanAmount, Long loanId, Integer totalTerm, Long firstRepaymentDate, Integer termPeriod, Integer planCount, Integer status, String device) {
    this.name = name;
    this.pid = pid;
    this.mobile = mobile;
    this.loanType = loanType;
    this.accountOpenDate = accountOpenDate;
    this.applyDate = applyDate;
    this.issueDate = issueDate == null ? 0l : issueDate;
    this.loanAmount = loanAmount == null ? BigDecimal.ZERO : loanAmount;
    this.loanId = loanId;
    this.totalTerm = totalTerm == null ? 0 : totalTerm;
    this.firstRepaymentDate = firstRepaymentDate == null ? 0 : firstRepaymentDate;
    this.termPeriod = termPeriod == null ? 0 : termPeriod;
    this.planCount = planCount == null ? 0 : planCount;
    this.status = status;
    this.timeCreated = new Date();
    this.device = device;
  }
}