package cn.quantgroup.report.cmpt;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpStatus;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Slf4j
@Component
public class CommonAlarmCmpt {

    @Value("${isDebug}")
    private Boolean isDebug;

    private static ThreadPoolExecutor pool = new ThreadPoolExecutor(10, 50, 200,
            TimeUnit.MILLISECONDS, new LinkedBlockingQueue<>(200), new ThreadPoolExecutor.DiscardPolicy());

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (pool != null) pool.shutdown();
        }));
    }

    @Value("${alarm.interface.url}")
    private String ALARM_INTERFACE_URL;

    RequestConfig config = RequestConfig.custom()
            .setSocketTimeout(6000)
            .setConnectTimeout(6000)
            .setConnectionRequestTimeout(6000)
            .build();

    CloseableHttpClient httpclient = HttpClients.createDefault();

    public void alarm(String alarmLevel, String msgTitle, String msgContent) {

        if(isDebug) return;

        pool.execute(new Runnable() {
            @Override
            public void run() {
                HttpPost httppost = new HttpPost(ALARM_INTERFACE_URL);
                httppost.setConfig(config);

                List<BasicNameValuePair> params = new ArrayList<>();
                params.add(new BasicNameValuePair("bizType", "RISK_DATASOURCE"));
                params.add(new BasicNameValuePair("alarmLevel", alarmLevel));
                params.add(new BasicNameValuePair("msgTitle", msgTitle));
                params.add(new BasicNameValuePair("msgContent", msgContent));
                CloseableHttpResponse response = null;
                try {
                    httppost.setEntity(new UrlEncodedFormEntity(params, "UTF-8"));
                    response = httpclient.execute(httppost);
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        log.error("告警失败，statusCode : {}", statusCode);
                    }
                } catch (Exception e) {
                    log.error("告警发送异常", e);
                } finally {
                    if(response != null) {
                        EntityUtils.consumeQuietly(response.getEntity());
                    }
                    IOUtils.closeQuietly(response);
                }
            }
        });

    }

    public void alarmAtman(String mobile, Long content){
        HttpPost httppost = new HttpPost("https://oapi.dingtalk.com/robot/send?access_token=5c787094003bb2bd5ed763dd7afa96f9bf984b4871e2f47369626c493dcb320e");
        httppost.setConfig(config);
        httppost.addHeader("Content-Type", "application/json; charset=utf-8");

        String textMsg = "{\"msgtype\":\"text\",\"text\":{\"content\":\"探知数据调用量:"+content+",  @"+mobile+" 是不一样的烟火\"},\"at\":{\"atMobiles\":[\""+mobile+"\"],\"isAtAll\":false}}";
        StringEntity se = new StringEntity(textMsg, "utf-8");
        httppost.setEntity(se);
        CloseableHttpResponse response = null;
        try{
            response = httpclient.execute(httppost);
        if (response.getStatusLine().getStatusCode()== HttpStatus.SC_OK){
            String result= EntityUtils.toString(response.getEntity(), "utf-8");
            System.out.println(result);
        }
        }catch(Exception e){
            log.error("告警发送异常", e);
        }finally {
            if(response != null) {
                EntityUtils.consumeQuietly(response.getEntity());
            }
            IOUtils.closeQuietly(response);
        }
    }


}
