package cn.quantgroup.report.utils;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.Months;
import org.joda.time.format.DateTimeFormat;

public class ClockUtils {
  public static final String TIME_ZONE = "Asia/Shanghai";
  public static final String DATE_FORMAT = "yyyyMMdd";

  public static final Long MILLS_PER_DAY = 24 * 60 * 60 * 1000l;
  public static final long MILLS_PER_MINUTE = 60 * 1000l;
  public static final String DATE_FORMAT_FOR_ORDER_PROGRESS_UPDATE_YEAR = "yyyy-MM-dd";
  public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
  public static final String ISO_8601_DATE_TIME_FORMAT = "yyyy-MM-ddTHH:mm:ss";
  public static final String HBASE_DATE_TIME_FORMAT = "yyyyMMddHHmmsss";

  public static long nowDateInMillis() {
    return nowDate()
      .withHourOfDay(0)
      .withMinuteOfHour(0)
      .withSecondOfMinute(0)
      .withMillisOfSecond(0)
      .getMillis();
  }

  public static long nowDateInMillsWithHour(int hour) {
    return nowDate()
      .withHourOfDay(hour)
      .withMinuteOfHour(0)
      .withSecondOfMinute(0)
      .withMillisOfSecond(0)
      .getMillis();
  }

  public static String dateTimeStringFromTimestamp(Long timestamp) {
    return dateTimeStringFromTimestamp(timestamp, DATE_TIME_FORMAT);
  }

  public static String hBaseDateTimeStringFromTimestamp(Long timestamp) {
    return dateTimeStringFromTimestamp(timestamp, HBASE_DATE_TIME_FORMAT);
  }

  public static String iso8601dateTimeStringFromTimestamp(Long timestamp) {
    return dateTimeStringFromTimestamp(timestamp, ISO_8601_DATE_TIME_FORMAT);
  }

  public static long hBaseParseTimestampFromDateTimeString(String dateTimeString) {
    return DateTime.parse(dateTimeString, DateTimeFormat.forPattern(HBASE_DATE_TIME_FORMAT)).getMillis();
  }

  public static long parseTimestampFromDateTimeString(String dateTimeString) {
    return DateTime.parse(dateTimeString, DateTimeFormat.forPattern(DATE_TIME_FORMAT)).getMillis();
  }


  public static String dateTimeStringFromTimestamp(Long timestamp, String format) {
    if (null == timestamp) {
      return null;
    }
    return date(timestamp).toString(DateTimeFormat.forPattern(format));
  }

  public static DateTime date(Long timestamp) {
    return new DateTime(timestamp, getTimeZone());
  }


  public static DateTime nowDate() {
    return new DateTime(getTimeZone());
  }

  public static DateTimeZone getTimeZone() {
    return DateTimeZone.forID(TIME_ZONE);
  }

  public static long daysAgoInMillis(int daysAgo) {
    return nowDateInMillis() - MILLS_PER_DAY * daysAgo;
  }

  public static long monthsAgoInMillis(int monthsAgo) {
    return nowDate()
      .withHourOfDay(0)
      .withMinuteOfHour(0)
      .withSecondOfMinute(0)
      .withMillisOfSecond(0)
      .minusMonths(monthsAgo)
      .getMillis();
  }

  public static long minutesAgoInMillis(int minutes) {
    return now() - MILLS_PER_MINUTE * minutes;
  }

  public static long now() {
    return nowDate().getMillis();
  }

  public static int getDaysBetween(Long startMillis, Long endMills) {
    return Days.daysBetween(date(startMillis), date(endMills)).getDays() + 1;
  }

  public static int getMonthsBetween(Long startMillis, Long endMills) {
    return Months.monthsBetween(date(startMillis), date(endMills)).getMonths() + 1;
  }

}
