package cn.quantgroup.report.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.google.common.collect.Maps;

import java.util.Map;

public class ConverterCacheUtils {
  private static final Map<Object, JSONObject> objectCache = Maps.newConcurrentMap();
  private static final SerializeConfig jsonConfig = new SerializeConfig();

  public static JSONObject convertedFromObject(Object object) {
    if (object == null) {
      return null;
    }
    JSONObject jsonObject = objectCache.get(object);
    if (jsonObject != null) {
      return jsonObject;
    }
    String jsonString = JSON.toJSONString(object, jsonConfig);//过滤null字段
    jsonObject = (JSONObject) JSON.parse(jsonString);
    if (jsonObject == null) {
      return null;
    }
    objectCache.put(object, jsonObject);
    return jsonObject;
  }
}
