package cn.quantgroup.report.service.baihang;

import cn.quantgroup.report.domain.baihang.*;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @Author fengjunkai
 * @Date 2019-07-10 16:14
 */
@Slf4j
@Service
public class ReSendBaiHangService extends BaiHangService {

    /**
     * 重新报送实时放款数据
     */
    public void sendLoaInfoReportToBaiHang(String startTime, String endTime) {
        AtomicInteger atomicInteger = new AtomicInteger();
        List<LoanInfoZhuDai> loanInfos = new ArrayList<>();
        Stopwatch sendWatch = Stopwatch.createStarted();
        try{
            Stopwatch queryWatch = Stopwatch.createStarted();
            loanInfos = loanInfoMapper.findLoanInfoByTime(BaiHangTimeRecord.builder().startTime(startTime).endTime(endTime).build());
            log.info("广达小贷TO百行放款申请报送开始, 大小: {} , 耗时: {} ", loanInfos.size(), queryWatch.stop().elapsed(TimeUnit.MILLISECONDS));

            for (int i = 0; i < loanInfos.size(); i++) {
                LoanInfoZhuDai loanInfo = loanInfos.get(i);
                String id = "";
                try {
                    String loanInfoReqId = loanInfo.getReqID();
                    if (loanInfo.getTotalTerm() > 1) {
                        List<String> targetRepaymentDayList = loanInfoMapper.findTargetRepaymentDayList(loanInfoReqId);
                        loanInfo.setTargetRepayDateList(String.join(",", targetRepaymentDayList));
                    }
                    UUID loanInfoId = UUID.randomUUID();
                    id = loanInfoId.toString().replaceAll("-", "");
                    loanInfo.setRecordId(id);
                    loanInfoDbMapper.saveLoanInfoRecordLog(loanInfo);
                    loanInfo.setRecordId(null);
                    loanInfo.setReqID(id);
                    loanInfo.setName(interfaceUploadClient(loanInfo.getName()));
                    loanInfo.setPid(interfaceUploadClient(loanInfo.getPid()));
                    loanInfo.setMobile(interfaceUploadClient(loanInfo.getMobile()));
                    String resultStr = iHttpService.postBaiHang(baiHangLoanInfoUrl, getHeader(), JSON.toJSONString(loanInfo));
                    if (Objects.isNull(resultStr) || !"success".equalsIgnoreCase(JSON.parseObject(resultStr).getString("status"))) {
                        log.warn("(重发)广达小贷TO百行征信报送放款返回结果不正确, recordId: {} , loanId: {} , bean: {} ", id, loanInfo.getLoanId(), JSON.toJSONString(loanInfo));
                        loanInfoDbMapper.updateCurrentRecordEnableFalce(BaiHangUpDateRecord.builder().enable("0").recordId(id).build());
                    } else {
                        atomicInteger.getAndIncrement();
                    }
                } catch (Exception e) {
                    log.error("广达小贷TO百行征信报送放款信息异常, recordId: {} , loanId: {} ", id, loanInfo.getLoanId(), e);
                }
            }
        }catch(Exception e){
            log.error("广达小贷放款报送异常", e);
        }
        log.info("广达小贷TO百行征信报送放款申请完成, 实际大小: {} , 报送成功大小: {} , 耗时: {} ", loanInfos.size(), atomicInteger.get(), sendWatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }

    /**
     * 手动报送实时还款数据
     */
    public void sendRepaymentReportToBaiHang(String startTime, String endTime) {

        for (int j = 0; j < 2; j++) {

            Stopwatch sendWatch = Stopwatch.createStarted();

            try {
                List<RepaymentInfoZhuDai> repaymentLoanInfos = null;
                if (j == 0) {
                    Stopwatch realTimeStopWatch = Stopwatch.createStarted();
                    repaymentLoanInfos = repaymentLoanInfoMapper.findRepayMentLoanInfo(BaiHangTimeRecord.builder().startTime(startTime).endTime(endTime).build());
                    log.info("广达小贷TO百行征信报送实时还款, startTime: {} , endTime: {} , 大小: {} , 耗时: {} ", startTime, endTime, repaymentLoanInfos.size(), realTimeStopWatch.stop().elapsed(TimeUnit.MILLISECONDS));
                } else {
                    Stopwatch realTimeOverdueStopWatch = Stopwatch.createStarted();
                    repaymentLoanInfos = repaymentLoanInfoMapper.findRepayMentLoanInfoOverdue(BaiHangTimeRecord.builder().startTime(startTime).endTime(endTime).build());
                    log.info("广达小贷TO百行征信报送实时还款逾期, startTime: {} , endTime: {} , 大小: {} , 耗时: {} ", startTime, endTime, repaymentLoanInfos.size(), realTimeOverdueStopWatch.stop().elapsed(TimeUnit.MILLISECONDS));
                }

                AtomicInteger atomicInteger = new AtomicInteger();

                for (int i = 0; i < repaymentLoanInfos.size(); i++) {
                    RepaymentInfoZhuDai repaymentLoanInfo = repaymentLoanInfos.get(i);
                    String id = "";
                    try {
                        RepaymentInfoZhuDai repaymentLoanInfo1 = repaymentLoanInfoDbMapper.findLastOne(BaiHangRepayment.builder().loanId(repaymentLoanInfo.getLoanId()).termNo(repaymentLoanInfo.getTermNo()).build());
                        if (j > 0 && Objects.nonNull(repaymentLoanInfo1)) {
                            log.info("广达小贷TO百行征信报送实时还款逾期跳过报送, startTime: {} , endTime: {} , bean: {} ", startTime, endTime, JSON.toJSONString(repaymentLoanInfo1));
                            continue;
                        }

                        id = UUID.randomUUID().toString().replaceAll("-", "");
                        repaymentLoanInfo.setRecordId(id);
                        try {
                            repaymentLoanInfoDbMapper.saveRepaymentLoanInfoLog(repaymentLoanInfo);
                        } catch (Exception e) {
                        }
                        repaymentLoanInfo.setPid(interfaceUploadClient(repaymentLoanInfo.getPid()));
                        repaymentLoanInfo.setName(interfaceUploadClient(repaymentLoanInfo.getName()));
                        repaymentLoanInfo.setMobile(interfaceUploadClient(repaymentLoanInfo.getMobile()));
                        repaymentLoanInfo.setReqID(id);
                        repaymentLoanInfo.setRecordId(null);
                        String resultStr = iHttpService.postBaiHang(baiHangRepayMentLoanInfoUrl, getHeader(), JSON.toJSONString(repaymentLoanInfo));
                        if (Objects.isNull(resultStr) || !"success".equalsIgnoreCase(JSON.parseObject(resultStr).getString("status"))) {
                            log.warn("广达小贷TO百行征信报送还款返回结果不正确, 开始时间: {} , 结束时间: {} , recordId: {} , loanId: {} , bean: {} ", startTime, endTime, id, repaymentLoanInfo.getLoanId(), JSON.toJSONString(repaymentLoanInfo));
                            repaymentLoanInfoDbMapper.updateCurrentRecordEnableFalse(BaiHangUpDateRecord.builder().enable("0").recordId(id).build());
                        } else {
                            atomicInteger.getAndIncrement();
                        }
                    } catch (Exception e) {
                        log.error("广达小贷TO百行征信报送还款信息异常, recordId: {} , loanId: {} ", id, repaymentLoanInfo.getLoanId(), e);
                    }
                }
                log.info("广达小贷TO百行征信报送还款申请完成 J: {} , 开始时间: {} , 结束时间: {} , 实际大小: {} , 报送成功大小: {} , 耗时: {} ", j, startTime, endTime, repaymentLoanInfos.size(), atomicInteger.get(), sendWatch.stop().elapsed(TimeUnit.MILLISECONDS));
            } catch (Exception e) {
                log.error("广达小贷TO百行征信还款报送异常 J: {} , 开始时间: {} , 结束时间: {} ", j, startTime, endTime, e);
            }
        }

    }

}
