package cn.quantgroup.report.controller;

import cn.quantgroup.report.response.GlobalResponse;
import cn.quantgroup.report.service.baihang.BaiHangFileReportService;
import cn.quantgroup.report.service.baihang.BaiHangZhuDaiService;
import cn.quantgroup.report.service.manualTool.CleanningTransactionLogService;
import cn.quantgroup.report.service.manualTool.ManualToolService;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.File;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping(value = "/manualtool")
public class ManualToolController {

  @Autowired
  private ManualToolService manualToolService;

  @Autowired
  BaiHangZhuDaiService zhuDaiService;

  @Autowired
  private CleanningTransactionLogService cleanningTransactionLogService;
  @Autowired
  private BaiHangFileReportService fileReportService;


  @RequestMapping("/send/baihang")
  public String sendBaihang(String p1,String p2,String p3,String p4,String p5,String secretKey, String isSend,String errorCode, String isProduct, String sendIncludeType) {
    try{
      Map<String,String> resultMap = manualToolService.sendBaiHangData(p1,p2,p3,p4,p5,secretKey,isSend,errorCode, isProduct, sendIncludeType);
      return JSON.toJSONString(resultMap);
    }catch (Exception e){
      log.error("众信利民助贷模式To百行征信手动报送异常, {} , {} ", e.getMessage(), e);
      return "众信利民助贷模式To百行征信手动报送异常";
    }
  }


  /**
   * 描述: 放款信息 D2 <br/>
   * 参数: [jsonFile]  <br/>
   * 返回值: GlobalResponse  <br/>
   * 创建人: yanhui.Hao  <br/>
   * 创建时间: 2019.09.27  <br/>
   */
  @RequestMapping("/build/d2")
  public GlobalResponse buildLoanInfoD2(String jsonFile) {
    try{
      return manualToolService.buildLoanInfoD2(jsonFile);
    }catch (Exception e){
      log.error("百行征信手动报送异常, {} , {} ", e.getMessage(), e);
      return GlobalResponse.generate(e.getMessage());
    }
  }


  @RequestMapping("/dealWithExcelData")
  public GlobalResponse dealWithExcelData(String filePath,String type){
    return manualToolService.dealWithExcelData(filePath,type);
  }


  @RequestMapping("/removeD3LoanIdChunfu")
  public String remove_D3_loanId_chunfu(String oldDataFile, String cfLoanIdLogFile, String newFileName, String rmIdFileName,String rmPhoneFileName){
    return manualToolService.remove_D3_loanId_chunfu(oldDataFile,cfLoanIdLogFile,newFileName,rmIdFileName,rmPhoneFileName);
  }
  @RequestMapping("/checkD3loanIdInD2")
  public String check_D3loanId_InD2(String d3LoanIdFile, String d2File, String inFileName, String notInFileName){
    return manualToolService.check_D3loanId_InD2(d3LoanIdFile,d2File,inFileName,notInFileName);
  }
  @RequestMapping("/checkD2loanIdInD3WanJie")
  public String check_D2loanId_InD3WanJie(String d3LoanIdFile, String d2File, String notWJFileName){
    return manualToolService.check_D2loanId_InD3WanJie(d3LoanIdFile,d2File,notWJFileName);
  }

  @RequestMapping("/newD3ReplaceReqId")
  public String newD3ReplaceReqId(String newD3FilePath, String newD3FileNames, String oldD3ReqIdFile, String mapNotEmptyFile){
     manualToolService.newD3ReplaceReqId(newD3FilePath,newD3FileNames,oldD3ReqIdFile,mapNotEmptyFile);
    return "调用结束";
  }

  @RequestMapping("/d2_saveLog")
  public String d2_saveLog(String d2JsonFileName,String reqIdFileName,String no_reqId_start, String isHaveRecordId){
    manualToolService.d2_saveLog(d2JsonFileName,reqIdFileName,no_reqId_start,isHaveRecordId);
    return "d2_saveLog调用结束";
  }

    @RequestMapping("/d3_saveLog")
    public String d3_saveLog(String d3FilePath, String d3JsonFileNames, String reqIdLogName, String no_reqId_start, String isHaveRecordId){
        manualToolService.d3_saveLog(d3FilePath,d3JsonFileNames,reqIdLogName,no_reqId_start,isHaveRecordId);
        return "d3_saveLog调用结束";
    }


  @RequestMapping("/synCallRecordNew")
  public String synCallRecordNew(String newYnrTime,String isExecuteOnce){
    cleanningTransactionLogService.synCallRecordNew(newYnrTime,isExecuteOnce);
    return "synCallRecordNew调度完成";
  }

  @RequestMapping("/checkCallRecordCF")
  public String checkCallRecordCF(String newYnrTime,String isExecuteOnce){
    cleanningTransactionLogService.checkCallRecordCF(newYnrTime,isExecuteOnce);
    return "checkCallRecordCF调度完成";
  }
  @RequestMapping("/checkTransactionLogCF")
  public String checkTransactionLogCF(String newYnrTime,String isExecuteOnce){
    cleanningTransactionLogService.checkTransactionLogCF(newYnrTime,isExecuteOnce);
    return "checkTransactionLogCF调度完成";
  }

  @RequestMapping("/checkCallRecordCFByTransactionLog")
  public String checkCallRecordCFByTransactionLog(String newYnrTime,String isExecuteOnce){
    cleanningTransactionLogService.checkCallRecordCFByTransactionLog(newYnrTime,isExecuteOnce);
    return "checkCallRecordCFByTransactionLog调度完成";
  }

  @RequestMapping("/checkCallRecordCFByTransactionLog2")
  public String checkCallRecordCFByTransactionLog2(String newYnrTime,String isExecuteOnce){
    cleanningTransactionLogService.checkCallRecordCFByTransactionLog2(newYnrTime,isExecuteOnce);
    return "checkCallRecordCFByTransactionLog2调度完成";
  }

  @RequestMapping("/deleteTidbCallRecordCF")
  public String deleteTidbCallRecordCF(String cfFileName, String bakFileName){
    cleanningTransactionLogService.deleteTidbCallRecordCF(cfFileName,bakFileName);
    return "deleteTidbCallRecordCF调度完成";
  }

  @RequestMapping("/deleteRedisKey")
  public Map<String,Object> deleteRedisKey(String key1, String key2, String key3){
    try{
      manualToolService.deleteRedisKey(key1, key2, key3);
      return ImmutableMap.of("code", 0, "msg", "手动删除redisKey成功");
    }catch(Exception e){
      return ImmutableMap.of("code", 1, "msg", "手动设置redisKey异常");
    }
  }

  @RequestMapping("/getRedisVal")
  public String getRedisVal(String key){
    try{
      return manualToolService.getRedisVal(key);
    }catch(Exception e){
      return "获取redis值异常";
    }
  }

  @RequestMapping("/createFile")
  public String testD2Repost(String type, String startDate, String endDate, Integer daySpilt, String loanStartDateStr, String loanEndDateStr, String prefix){
    try {
      fileReportService.createReportFile(type,startDate,endDate,daySpilt,loanStartDateStr,loanEndDateStr,prefix);
      return "SUCCESS";
    }catch (Exception e){
      return e.getMessage();
    }
  }

  @RequestMapping("/encryptFile")
  public String encryptFile(String filePath){
    try {
      File file = new File(filePath);
      fileReportService.encryptFile(file.getAbsolutePath());
      return "SUCCESS";
    }catch (Exception e){
      return e.getMessage();
    }
  }

  @RequestMapping("/deleteReportRedisKey")
  public String deleteReportRedisKey(String keyStr) {
    try {
      fileReportService.deleteReportRedisKey(keyStr);
      return "SUCCESS";
    } catch (Exception e) {
      return e.getMessage();
    }
  }

  @RequestMapping("/fileToBaiHangFtp")
  public String fileToBaiHangFtp(String collectFileName){
    try {
      fileReportService.fileToBaiHangFtp(collectFileName);
      return "SUCCESS";
    }catch (Exception e){
      return e.getMessage();
    }
  }

  @RequestMapping("/fileCollectDataCheck")
  public String fileCollectDataCheck(String type,String collectFileName,String fieldNames){
    try {
      fileReportService.fileCollectDataCheck(type,collectFileName,fieldNames);
      return "SUCCESS";
    }catch (Exception e){
      return e.getMessage();
    }
  }

  @RequestMapping("/singleFileDataCheck")
  public String singleFileDataCheck(String type,String singleFileName,String fieldNames){
    try {
      fileReportService.singleFileDataCheck(type,singleFileName,fieldNames);
      return "SUCCESS";
    }catch (Exception e){
      return e.getMessage();
    }
  }

  @RequestMapping("/fileDataCheckCopy")
  public String fileDataCheckCopy(String sourceFileName,String targetFileName,String checkFieldNames){
    try {
      fileReportService.fileDataCheckCopy(sourceFileName,targetFileName,checkFieldNames);
      return "SUCCESS";
    }catch (Exception e){
      return e.getMessage();
    }
  }

}
