package cn.quantgroup.report.job;

import cn.quantgroup.report.service.baihang.constant.Constant;
import com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;


/**
 * -----------------------------------------------------------------------------<br>
 * 描述: 量化派助贷模式(非循环贷) -
 *      (贷款申请/放款/还款(逾期)三类实时批量数据)-To百行报送<br>
 *     每日凌晨5点报送 <br>
 * 作者：yanhui.Hao <br>
 * 时间：2019.10.25 <br>
 * 授权: (C) Copyright (c) 2017 <br>
 * 公司: 北京众信利民信息技术有限公司 <br>
 * -----------------------------------------------------------------------------
 */
@Component
public class LoanApplicationManifestHistoryTask {

    private static final Logger log = LoggerFactory.getLogger(LoanApplicationManifestHistoryTask.class);

    @Autowired
    private RedisTemplate<String,String> redisTemplate;


    @Autowired
    private JdbcTemplate xyqbHistoryJdbcTemplate;

    private static AtomicBoolean SYN_Stop = new AtomicBoolean(false);

    private static String SQL_COMMONE_TEMPLATE = "INSERT xyqb_i_loan_a_m_history_bak " +
            " select * from xyqb_i_loan_application_manifest_history b " +
            " where b.funding_corp_id in (420,520,580,650,670,810,240,640,700) " +
            " and b.created_at >= '##STARTTIME##'  and b.created_at < '##ENDTIME##'; ";

    private static String SQL_COMMONE_TEMPLATE_PLAN = " INSERT xyqb_i_repayment_plan_bak " +
            "select a.* from xyqb_i_repayment_plan a " +
            " join xyqb_i_loan_a_m_history_bak b " +
            " on a.loan_application_history_id = b.loan_application_history_id " +
            "where b.created_at >= '##STARTTIME##'  and b.created_at < '##ENDTIME##'; ";


    @Async
    /*@Scheduled(cron = "0 06 16 * * ?")*/
    public void startHistoryDateCopy(){
        if(increment()){
            redisTemplate.expire(Constant.XYQB_HISTORY_DAI_REPORT_LOCK_KEY, 10, TimeUnit.SECONDS);

            //将xyqb_i_loan_application_manifest_history表的数据，同步到xyqb_i_loan_a_m_history_bak
            Stopwatch stopwatch = Stopwatch.createStarted();
            //yyyy-MM-dd
            //String startnyr = LocalDateTime.now().plusDays(-1).format(DateTimeFormatter.ISO_DATE);
            //String endnyr = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE);

            log.info("量化派-同步表xyqb_i_loan_application_manifest_history数据开始, newTime: {} ", LocalDateTime.now());
            //table_xyqb_i_loan_a_m_history_bak();
            table_xyqb_i_repayment_plan_bak();
            log.info("量化派-同步表xyqb_i_loan_application_manifest_history数据结束, endTime: {}, 耗时: {} ", LocalDateTime.now(), stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
    }


    public Boolean increment(){
        Long increment = redisTemplate.opsForValue().increment(Constant.XYQB_HISTORY_DAI_REPORT_LOCK_KEY, 1);
        return increment <= 1;
    }

    public void table_xyqb_i_loan_a_m_history_bak(){
        LocalDateTime erlyDate = LocalDateTime.parse("2016-08-23T00:00:00");//2016-08-23T16:29:10
        LocalDateTime endDate = LocalDateTime.parse("2019-11-01T00:00:00");//2019-11-11 12:32:08
        int counter = 0;
        while (true) {
            Stopwatch startwatch = Stopwatch.createStarted();

            if (SYN_Stop.get()) {
                log.error("同步xyqb_i_loan_application_manifest_history数据查询STOP, D3_Stop: {} , endTime: {} ", SYN_Stop.get(), erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE));
                break;
            }
            counter++;
            if (erlyDate.plusDays(counter).compareTo(endDate) > 0) {
                break;
            }

            String starTime = erlyDate.plusDays(counter - 1).format(DateTimeFormatter.ISO_DATE);
            String endTime = erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE);
            try {
                String tmp_sql = SQL_COMMONE_TEMPLATE.replace("##STARTTIME##",starTime);
                tmp_sql = tmp_sql.replace("##ENDTIME##",endTime);

                int upCount = xyqbHistoryJdbcTemplate.update(tmp_sql);
                log.info("同步xyqb_i_loan_application_manifest_history数据结束,startTime: {} , 耗时:{} , updateCount: {} ", starTime, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms", upCount);

            }catch (Exception e){
                log.error("同步xyqb_i_loan_application_manifest_history数据异常, startTime: {} , endTime: {} , counter: {} ", starTime, endTime,counter, e);
            }
        }
    }

    public void table_xyqb_i_repayment_plan_bak(){
        LocalDateTime erlyDate = LocalDateTime.parse("2016-08-23T00:00:00");//2016-08-23T16:29:10
        LocalDateTime endDate = LocalDateTime.parse("2019-11-01T00:00:00");//2019-11-11 12:32:08
        int counter = 0;
        while (true) {
            Stopwatch startwatch = Stopwatch.createStarted();

            if (SYN_Stop.get()) {
                log.error("同步xyqb_i_repayment_plan数据查询STOP, D3_Stop: {} , endTime: {} ", SYN_Stop.get(), erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE));
                break;
            }
            counter++;
            if (erlyDate.plusDays(counter).compareTo(endDate) > 0) {
                break;
            }

            String starTime = erlyDate.plusDays(counter - 1).format(DateTimeFormatter.ISO_DATE);
            String endTime = erlyDate.plusDays(counter).format(DateTimeFormatter.ISO_DATE);
            try {
                String tmp_sql = SQL_COMMONE_TEMPLATE_PLAN.replace("##STARTTIME##",starTime);
                tmp_sql = tmp_sql.replace("##ENDTIME##",endTime);

                int upCount = xyqbHistoryJdbcTemplate.update(tmp_sql);
                log.info("同步xyqb_i_repayment_plan数据结束,startTime: {} , 耗时:{} , updateCount: {} ", starTime, startwatch.stop().elapsed(TimeUnit.MILLISECONDS)+".ms", upCount);

            }catch (Exception e){
                log.error("同步xyqb_i_repayment_plan数据异常, startTime: {} , endTime: {} , counter: {} ", starTime, endTime,counter, e);
            }
        }
    }



}
