package cn.quantgroup.report;

import cn.quantgroup.report.job.QuantGroupZhuDaiReportToBaiHang;
import cn.quantgroup.report.service.baihang.BaiHangZhuDaiService;
import cn.quantgroup.report.service.baihang.client.BhFileCreditApiClient;
import cn.quantgroup.report.service.baihang.request.FileUploadRequest;
import cn.quantgroup.report.service.baihang.response.FileUploadResponse;
import cn.quantgroup.report.service.repair.RepairService;
import cn.quantgroup.report.utils.DateUtils;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Date;
import java.util.concurrent.TimeUnit;

@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest(classes = BaihangReportApplication.class)
public class BaihangReportApplicationTests {

	@Autowired
	QuantGroupZhuDaiReportToBaiHang  repoter;
	@Autowired
	RepairService service;
	@Autowired
	BaiHangZhuDaiService zhuDaiService;

	@Test
	public void contextLoads() {
		repoter.startZhuDaiReport();
	}

	@Test
	public void testD2Repost(){
		Stopwatch stopwatch = Stopwatch.createStarted();
		D2();
		log.info("跑了 {}",stopwatch.elapsed(TimeUnit.MILLISECONDS));
	}

	//2020-07-01
	private void D2(){
		String startTime = "2020-07-01",endTime = "2020-07-01";
		Date startDate;
		Date endDate = DateUtils.parseDate("yyyy-MM-dd",endTime);
		while (endDate.getTime() < System.currentTimeMillis()){
			log.info("开始报送D2----- {} -- {}",startTime,endTime);
			zhuDaiService.apiSend("D2",startTime+"T00:00:00",endTime+"T00:00:00");
			startDate = new Date(endDate.getTime());
			endDate = org.apache.commons.lang3.time.DateUtils.addMonths(endDate,1);
			startTime = DateUtils.formatDate(startDate,"yyyy-MM-dd");
			endTime = DateUtils.formatDate(endDate,"yyyy-MM-dd");
		}
	}

	private void D3(){
		String startTime = "2020-07-01",endTime = "2020-07-01";
		Date startDate;
		Date endDate = DateUtils.parseDate("yyyy-MM-dd",endTime);
		while (endDate.getTime() < System.currentTimeMillis()){
			log.info("开始报送D3----- {} -- {}",startTime,endTime);
			zhuDaiService.apiSend("D3",startTime+"T00:00:00",endTime+"T00:00:00");
			startDate = new Date(endDate.getTime());
			endDate = org.apache.commons.lang3.time.DateUtils.addMonths(endDate,1);
			startTime = DateUtils.formatDate(startDate,"yyyy-MM-dd");
			endTime = DateUtils.formatDate(endDate,"yyyy-MM-dd");
		}
	}

	@Test
	public void testRepair(){
		Stopwatch stopwatch = Stopwatch.createStarted();
		service.doRepair("normal_lh",0);
		service.doRepair("overdue_lh",0);
		service.doRepair("normal",0);
		service.doRepair("overdue",0);
		log.info("本次测试总耗时 {}",stopwatch.elapsed(TimeUnit.MILLISECONDS));
	}



}
