package cn.quantgroup.report.utils;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.*;
import java.security.cert.CertificateException;

public class SSLUtils {
  public static SSLSocketFactory getSSLContext(String password, InputStream keyStoreInputStream) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, CertificateException, IOException, KeyManagementException {
    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
    KeyStore keyStore = KeyStore.getInstance("JKS");
    keyStore.load(keyStoreInputStream, password.toCharArray());
    keyManagerFactory.init(keyStore, password.toCharArray());
    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
    trustManagerFactory.init(keyStore);
    SSLContext ctx = SSLContext.getInstance("TLS");
    ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), (SecureRandom) null);
    return ctx.getSocketFactory();
  }

}
